package com.bcxin.tenant.open.dubbo.common.configs.filters;

import com.bcxin.tenant.open.dubbo.common.configs.DubboConstants;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.valueTypes.TrafficTagValueType;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;
import org.apache.dubbo.rpc.cluster.filter.support.ConsumerContextFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 隐藏传输当前登入的用户信息
 */
@Activate(group = CommonConstants.CONSUMER,order = -99999)
public class CustomConsumerContextFilter extends ConsumerContextFilter {
    private static final Logger logger = LoggerFactory.getLogger(CustomConsumerContextFilter.class);

    public CustomConsumerContextFilter(ApplicationModel applicationModel) {
        super(applicationModel);

        System.err.println("CustomConsumerContextFilter");
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TenantContext tenantContext = TenantContext.getInstance();
        TenantEmployeeContext.TenantUserModel userModel = tenantContext.getUserContext().get();
        invocation.setAttachment(TenantEmployeeContext.CURRENT_TENANT_USER_INFO, userModel);

        Object tag = tenantContext.getAttachValue(TenantContext.FLOW_TAG_NAME);
        if (tag != null) {
            RpcContext.getClientAttachment().setAttachment(DubboConstants.TAG_NAME, tag);
        }

        Result result = super.invoke(invoker, invocation);

        RpcContextAttachment contextAttachment = RpcContext.getServerContext();
        TrafficTagValueType tagValueType = (TrafficTagValueType) contextAttachment.getObjectAttachment(TenantContext.PROVIDER_FLOW_TAG_NAME);
        if (tagValueType != null) {
            TenantContext.getInstance().addAttachValues(TenantContext.PROVIDER_FLOW_TAG_NAME, tagValueType);
        }

        return result;
    }
}