/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.components;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.components.JsonProvider;
import com.bcxin.backend.core.edis.JTLZResponseValueEDI;
import com.bcxin.signature.components.JTLZComponent;
import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.config.FileWriteConfig;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpUtil;
import com.bcxin.signature.util.ftp.FtpWriteUtil;
import com.bcxin.signature.util.ftp.ThreadFtpContext;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component
public class JTLZPushComponent {
    private static final Logger logger = LoggerFactory.getLogger(JTLZPushComponent.class);
    private static AtomicInteger IncrementStep = new AtomicInteger(0);
    private final JTLZComponent jtlzComponent;
    private final JsonProvider jsonProvider;

    public JTLZPushComponent(JTLZComponent jtlzComponent, JsonProvider jsonProvider) {
        this.jtlzComponent = jtlzComponent;
        this.jsonProvider = jsonProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(String traceId, String readFtpName) {
        block98: {
            String fileContent;
            HashSet<JTLZResponseValueEDI> jtlzEdis;
            Exception subException;
            Exception metaException;
            String[] list;
            FtpConnection ftp;
            StopWatch stopWatch;
            block89: {
                stopWatch = new StopWatch();
                stopWatch.start();
                ftp = ThreadFtpContext.getFtpConnection();
                list = null;
                metaException = null;
                subException = null;
                jtlzEdis = new HashSet<JTLZResponseValueEDI>();
                fileContent = null;
                try {
                    fileContent = FtpUtil.getFileContent((FtpConnection)ftp, (String)FileModeConfig.getFilePath(), (String)readFtpName);
                }
                catch (Exception ex) {
                    logger.error("RETRY-Failed to obtain ftp content :{}", (Object)readFtpName, (Object)ex);
                    fileContent = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)readFtpName);
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileContent)) break block89;
                stopWatch.stop();
                logger.error("{}-({}) Done for signatureJTLZ cost {} seconds {}.list.size=({}) jtlzTask.signatureJTLZ.noFile({},{}).readFtpName\uff1a{}; ", new Object[]{traceId, subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), readFtpName, list == null ? 0 : list.length, FileModeConfig.getUserName(), FileModeConfig.getFilePath(), readFtpName, subException});
                if (!CollectionUtils.isEmpty(jtlzEdis)) {
                    Exception lastException = null;
                    StringBuilder trace = new StringBuilder();
                    try {
                        String batchContent = JSONObject.toJSONString(jtlzEdis);
                        String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName.replace(".bcx", ""), ".bcx");
                        trace.append(String.format("filename=%s;", fileName));
                        boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                        trace.append(String.format("rt=%s", rt));
                    }
                    catch (Exception ex) {
                        try {
                            lastException = ex;
                        }
                        catch (Throwable throwable) {
                            logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                            throw throwable;
                        }
                        logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                    }
                    logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                }
                if (metaException != null) {
                    // empty if block
                }
                StringBuilder sb2222222222 = new StringBuilder();
                try {
                    sb2222222222.append("begin to delete filename=" + readFtpName);
                    try {
                        ftp.delectFile(FileModeConfig.getFilePath(), readFtpName);
                    }
                    catch (Exception ee) {
                        Exception tryException = null;
                        try {
                            FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)readFtpName);
                            logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                        }
                        catch (Exception e2) {
                            try {
                                tryException = e2;
                                logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                            }
                            catch (Throwable throwable) {
                                logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                                throw throwable;
                            }
                        }
                    }
                    sb2222222222.append("step2;");
                    logger.error("readFtpName-success:{}", (Object)readFtpName, (Object)metaException);
                }
                catch (Exception ex) {
                    logger.error("readFtpName-failed to delete filename={};step={};exception={}", new Object[]{readFtpName, sb2222222222, ex.getMessage()});
                }
                try {
                    try {
                        ftp.disconnect();
                    }
                    catch (Exception sb2222222222) {
                        // empty catch block
                    }
                    ThreadFtpContext.disConnectFtpWriter();
                }
                catch (Exception ex) {
                    logger.error("ThreadFtpContext disconnect", (Throwable)ex);
                }
                return;
            }
            try {
                for (String filename : list = fileContent.split(",")) {
                    Exception lastException;
                    StopWatch subStopWatch;
                    block92: {
                        if (!StringUtils.hasLength((String)filename)) {
                            logger.error("unexpected filename={}", (Object)filename);
                            continue;
                        }
                        JTLZResponseValueEDI ediValue = null;
                        subStopWatch = new StopWatch();
                        subStopWatch.start();
                        lastException = null;
                        try {
                            String content = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)filename);
                            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)content)) {
                                ediValue = this.jtlzServer(filename, content, false);
                                logger.error("success with {}->", (Object)filename, (Object)ediValue.getFileName());
                            }
                            if (ediValue == null) break block92;
                            jtlzEdis.add(ediValue);
                        }
                        catch (Exception e) {
                            block93: {
                                try {
                                    lastException = e;
                                    if (ediValue == null) break block93;
                                    jtlzEdis.add(ediValue);
                                }
                                catch (Throwable throwable) {
                                    if (ediValue != null) {
                                        jtlzEdis.add(ediValue);
                                    }
                                    subStopWatch.stop();
                                    logger.error("{}-{} ====>filename: {} cost {} seconds jtlzTask.signatureJTLZ.jtlzServer,{}", new Object[]{traceId, readFtpName, filename, subStopWatch.getTotalTimeSeconds(), lastException == null ? "success" : "failed", lastException});
                                    throw throwable;
                                }
                            }
                            subStopWatch.stop();
                            logger.error("{}-{} ====>filename: {} cost {} seconds jtlzTask.signatureJTLZ.jtlzServer,{}", new Object[]{traceId, readFtpName, filename, subStopWatch.getTotalTimeSeconds(), lastException == null ? "success" : "failed", lastException});
                            continue;
                        }
                    }
                    subStopWatch.stop();
                    logger.error("{}-{} ====>filename: {} cost {} seconds jtlzTask.signatureJTLZ.jtlzServer,{}", new Object[]{traceId, readFtpName, filename, subStopWatch.getTotalTimeSeconds(), lastException == null ? "success" : "failed", lastException});
                }
            }
            catch (Exception ex) {
                subException = ex;
            }
            stopWatch.stop();
            logger.error("{}-({}) Done for signatureJTLZ cost {} seconds {}.list.size=({}) jtlzTask.signatureJTLZ.noFile({},{}).readFtpName\uff1a{}; ", new Object[]{traceId, subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), readFtpName, list == null ? 0 : list.length, FileModeConfig.getUserName(), FileModeConfig.getFilePath(), readFtpName, subException});
            if (!CollectionUtils.isEmpty(jtlzEdis)) {
                Exception lastException = null;
                StringBuilder trace = new StringBuilder();
                try {
                    String batchContent = JSONObject.toJSONString(jtlzEdis);
                    String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName.replace(".bcx", ""), ".bcx");
                    trace.append(String.format("filename=%s;", fileName));
                    boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                    trace.append(String.format("rt=%s", rt));
                }
                catch (Exception ex) {
                    try {
                        lastException = ex;
                    }
                    catch (Throwable throwable) {
                        logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                        throw throwable;
                    }
                    logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                }
                logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
            }
            if (metaException != null) {
                // empty if block
            }
            StringBuilder sb3222222222 = new StringBuilder();
            try {
                sb3222222222.append("begin to delete filename=" + readFtpName);
                try {
                    ftp.delectFile(FileModeConfig.getFilePath(), readFtpName);
                }
                catch (Exception ee) {
                    Exception tryException = null;
                    try {
                        FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)readFtpName);
                        logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                    }
                    catch (Exception e2) {
                        try {
                            tryException = e2;
                            logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                        }
                        catch (Throwable throwable) {
                            logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                            throw throwable;
                        }
                    }
                }
                sb3222222222.append("step2;");
                logger.error("readFtpName-success:{}", (Object)readFtpName, (Object)metaException);
            }
            catch (Exception ex) {
                logger.error("readFtpName-failed to delete filename={};step={};exception={}", new Object[]{readFtpName, sb3222222222, ex.getMessage()});
            }
            try {
                try {
                    ftp.disconnect();
                }
                catch (Exception sb3222222222) {
                    // empty catch block
                }
                ThreadFtpContext.disConnectFtpWriter();
            }
            catch (Exception ex) {
                logger.error("ThreadFtpContext disconnect", (Throwable)ex);
            }
            break block98;
            catch (Exception ex) {
                try {
                    metaException = ex;
                    logger.error("metaException-ERROR {}", (Object)readFtpName, (Object)ex);
                }
                catch (Throwable throwable) {
                    stopWatch.stop();
                    logger.error("{}-({}) Done for signatureJTLZ cost {} seconds {}.list.size=({}) jtlzTask.signatureJTLZ.noFile({},{}).readFtpName\uff1a{}; ", new Object[]{traceId, subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), readFtpName, list == null ? 0 : list.length, FileModeConfig.getUserName(), FileModeConfig.getFilePath(), readFtpName, subException});
                    if (!CollectionUtils.isEmpty(jtlzEdis)) {
                        Exception lastException = null;
                        StringBuilder trace = new StringBuilder();
                        try {
                            String batchContent = JSONObject.toJSONString(jtlzEdis);
                            String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName.replace(".bcx", ""), ".bcx");
                            trace.append(String.format("filename=%s;", fileName));
                            boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                            trace.append(String.format("rt=%s", rt));
                        }
                        catch (Exception ex2) {
                            try {
                                lastException = ex2;
                            }
                            catch (Throwable throwable2) {
                                logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                                throw throwable2;
                            }
                            logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                        }
                        logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                    }
                    if (metaException != null) {
                        // empty if block
                    }
                    StringBuilder sb42222222222 = new StringBuilder();
                    try {
                        sb42222222222.append("begin to delete filename=" + readFtpName);
                        try {
                            ftp.delectFile(FileModeConfig.getFilePath(), readFtpName);
                        }
                        catch (Exception ee) {
                            Exception tryException = null;
                            try {
                                FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)readFtpName);
                                logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                            }
                            catch (Exception e2) {
                                try {
                                    tryException = e2;
                                    logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                                }
                                catch (Throwable throwable3) {
                                    logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                                    throw throwable3;
                                }
                            }
                        }
                        sb42222222222.append("step2;");
                        logger.error("readFtpName-success:{}", (Object)readFtpName, (Object)metaException);
                    }
                    catch (Exception ex3) {
                        logger.error("readFtpName-failed to delete filename={};step={};exception={}", new Object[]{readFtpName, sb42222222222, ex3.getMessage()});
                    }
                    try {
                        try {
                            ftp.disconnect();
                        }
                        catch (Exception sb42222222222) {
                            // empty catch block
                        }
                        ThreadFtpContext.disConnectFtpWriter();
                    }
                    catch (Exception ex4) {
                        logger.error("ThreadFtpContext disconnect", (Throwable)ex4);
                    }
                    throw throwable;
                }
                stopWatch.stop();
                logger.error("{}-({}) Done for signatureJTLZ cost {} seconds {}.list.size=({}) jtlzTask.signatureJTLZ.noFile({},{}).readFtpName\uff1a{}; ", new Object[]{traceId, subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), readFtpName, list == null ? 0 : list.length, FileModeConfig.getUserName(), FileModeConfig.getFilePath(), readFtpName, subException});
                if (!CollectionUtils.isEmpty(jtlzEdis)) {
                    Exception lastException = null;
                    StringBuilder trace = new StringBuilder();
                    try {
                        String batchContent = JSONObject.toJSONString(jtlzEdis);
                        String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName.replace(".bcx", ""), ".bcx");
                        trace.append(String.format("filename=%s;", fileName));
                        boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                        trace.append(String.format("rt=%s", rt));
                    }
                    catch (Exception ex5) {
                        try {
                            lastException = ex5;
                        }
                        catch (Throwable throwable) {
                            logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                            throw throwable;
                        }
                        logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                    }
                    logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                }
                if (metaException != null) {
                    // empty if block
                }
                StringBuilder sb52222222222 = new StringBuilder();
                try {
                    sb52222222222.append("begin to delete filename=" + readFtpName);
                    try {
                        ftp.delectFile(FileModeConfig.getFilePath(), readFtpName);
                    }
                    catch (Exception ee) {
                        Exception tryException = null;
                        try {
                            FtpUtil.delFilename((String)FileModeConfig.getFilePath(), (String)readFtpName);
                            logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                        }
                        catch (Exception e2) {
                            try {
                                tryException = e2;
                                logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                            }
                            catch (Throwable throwable) {
                                logger.error("({})RETRY-Failed to delete ftp", (Object)(tryException == null ? "SUCCESS" : "ERROR"), (Object)readFtpName);
                                throw throwable;
                            }
                        }
                    }
                    sb52222222222.append("step2;");
                    logger.error("readFtpName-success:{}", (Object)readFtpName, (Object)metaException);
                }
                catch (Exception ex6) {
                    logger.error("readFtpName-failed to delete filename={};step={};exception={}", new Object[]{readFtpName, sb52222222222, ex6.getMessage()});
                }
                try {
                    try {
                        ftp.disconnect();
                    }
                    catch (Exception sb52222222222) {
                        // empty catch block
                    }
                    ThreadFtpContext.disConnectFtpWriter();
                }
                catch (Exception ex7) {
                    logger.error("ThreadFtpContext disconnect", (Throwable)ex7);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(String traceId, String[] list, boolean isFz) {
        block30: {
            HashSet<JTLZResponseValueEDI> jtlzEdis = new HashSet<JTLZResponseValueEDI>();
            Exception subException = null;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            for (String filename : list) {
                Exception lastException;
                StopWatch subStopWatch;
                block28: {
                    if (!StringUtils.hasLength((String)filename)) {
                        logger.error("directly-execute unexpected filename={}", (Object)filename);
                        continue;
                    }
                    JTLZResponseValueEDI ediValue = null;
                    subStopWatch = new StopWatch();
                    subStopWatch.start();
                    lastException = null;
                    try {
                        String content = FtpUtil.getFileContent((String)FileModeConfig.getFilePath(), (String)filename);
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)content)) {
                            ediValue = this.jtlzNullRet(filename, true);
                        } else if (isFz) {
                            this.jtlzFzServer(filename, content);
                        } else {
                            ediValue = this.jtlzServer(filename, content, true);
                        }
                        logger.error("directly-execute success with {}->", (Object)filename, (Object)ediValue.getFileName());
                        if (ediValue == null) break block28;
                        jtlzEdis.add(ediValue);
                    }
                    catch (Exception e) {
                        block29: {
                            try {
                                lastException = e;
                                ediValue = this.jtlzErrRet(filename, e.getMessage(), true);
                                if (ediValue == null) break block29;
                                jtlzEdis.add(ediValue);
                            }
                            catch (Throwable throwable) {
                                if (ediValue != null) {
                                    jtlzEdis.add(ediValue);
                                }
                                subStopWatch.stop();
                                logger.error("{}-{} ====>directly-execute: {} cost {} seconds jtlzTask.signatureJTLZ.jtlzServer,{}", new Object[]{traceId, list == null ? "EMPTY" : Integer.valueOf(list.length), filename, subStopWatch.getTotalTimeSeconds(), lastException == null ? "success" : "failed", lastException});
                                throw throwable;
                            }
                        }
                        subStopWatch.stop();
                        logger.error("{}-{} ====>directly-execute: {} cost {} seconds jtlzTask.signatureJTLZ.jtlzServer,{}", new Object[]{traceId, list == null ? "EMPTY" : Integer.valueOf(list.length), filename, subStopWatch.getTotalTimeSeconds(), lastException == null ? "success" : "failed", lastException});
                        continue;
                    }
                }
                subStopWatch.stop();
                logger.error("{}-{} ====>directly-execute: {} cost {} seconds jtlzTask.signatureJTLZ.jtlzServer,{}", new Object[]{traceId, list == null ? "EMPTY" : Integer.valueOf(list.length), filename, subStopWatch.getTotalTimeSeconds(), lastException == null ? "success" : "failed", lastException});
            }
            stopWatch.stop();
            logger.error("{}-Done for directly-execute process files cost {} seconds size=({})", new Object[]{subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), list == null ? "EMPTY" : Integer.valueOf(list.length), subException});
            if (CollectionUtils.isEmpty(jtlzEdis)) break block30;
            Exception lastException = null;
            StringBuilder trace = new StringBuilder();
            String readFtpName = String.format("directly-%s", DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMddHHmm"));
            try {
                String batchContent = JSONObject.toJSONString(jtlzEdis);
                String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName, ".bcx");
                trace.append(String.format("filename=%s;", fileName));
                boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                trace.append(String.format("rt=%s", rt));
            }
            catch (Exception ex) {
                try {
                    lastException = ex;
                }
                catch (Throwable throwable) {
                    logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                    throw throwable;
                }
                logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                break block30;
            }
            logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
            break block30;
            catch (Exception ex) {
                try {
                    subException = ex;
                }
                catch (Throwable throwable) {
                    stopWatch.stop();
                    logger.error("{}-Done for directly-execute process files cost {} seconds size=({})", new Object[]{subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), list == null ? "EMPTY" : Integer.valueOf(list.length), subException});
                    if (!CollectionUtils.isEmpty(jtlzEdis)) {
                        Exception lastException2 = null;
                        StringBuilder trace2 = new StringBuilder();
                        String readFtpName2 = String.format("directly-%s", DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMddHHmm"));
                        try {
                            String batchContent = JSONObject.toJSONString(jtlzEdis);
                            String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName2, ".bcx");
                            trace2.append(String.format("filename=%s;", fileName));
                            boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                            trace2.append(String.format("rt=%s", rt));
                        }
                        catch (Exception ex2) {
                            try {
                                lastException2 = ex2;
                            }
                            catch (Throwable throwable2) {
                                logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException2 == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace2, readFtpName2, lastException2});
                                throw throwable2;
                            }
                            logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException2 == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace2, readFtpName2, lastException2});
                        }
                        logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException2 == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace2, readFtpName2, lastException2});
                    }
                    throw throwable;
                }
                stopWatch.stop();
                logger.error("{}-Done for directly-execute process files cost {} seconds size=({})", new Object[]{subException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), list == null ? "EMPTY" : Integer.valueOf(list.length), subException});
                if (CollectionUtils.isEmpty(jtlzEdis)) break block30;
                lastException = null;
                trace = new StringBuilder();
                readFtpName = String.format("directly-%s", DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMddHHmm"));
                try {
                    String batchContent = JSONObject.toJSONString(jtlzEdis);
                    String fileName = String.format("%s-%s_%s%s", "BATCH-OUT-JTLZ-", IncrementStep.incrementAndGet(), readFtpName, ".bcx");
                    trace.append(String.format("filename=%s;", fileName));
                    boolean rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)fileName, (String)batchContent);
                    trace.append(String.format("rt=%s", rt));
                }
                catch (Exception ex3) {
                    try {
                        lastException = ex3;
                    }
                    catch (Throwable throwable) {
                        logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                        throw throwable;
                    }
                    logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
                }
                logger.error("{}-Done-IMPORTANT for batch file(jtlzEdis={},track={}, fileName={})-{}", new Object[]{lastException == null ? "SUCCESS" : "ERROR", jtlzEdis.size(), trace, readFtpName, lastException});
            }
        }
    }

    private JTLZResponseValueEDI jtlzNullRet(String filename, boolean outputFile) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        String outFilename = filename.replace("IN-", "OUT-");
        String result = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5185\u5bb9\u4e3a\u7a7a\u6216\u5f02\u5e38\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        boolean rt = false;
        if (!outputFile) {
            // empty if block
        }
        rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
        return JTLZResponseValueEDI.create((String)outFilename, (String)result, (boolean)rt);
    }

    private JTLZResponseValueEDI jtlzErrRet(String filename, String msg, boolean outputFile) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        String outFilename = filename.replace("IN-", "OUT-");
        String result = "{\"ack_code\":\"FAILURE\",\"errors\":[{\"code\":\"12409\",\"severity\":\"ERROR\",\"message\":\"" + msg + "\",\"innerCode\":\"\"}],\"sign\":null,\"sign_method\":null,\"timestamp\":null,\"correlation_id\":null,\"response_id\":\"a40e028c-d566-44fc-a2fa-ee4b8df715dc\",\"data\":null}";
        boolean rt = false;
        if (!outputFile) {
            // empty if block
        }
        rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
        return JTLZResponseValueEDI.create((String)outFilename, (String)result, (boolean)rt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JTLZResponseValueEDI jtlzServer(String filename, String content, boolean outputFile) {
        String result;
        String outFilename;
        block6: {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filename)) {
                return null;
            }
            outFilename = filename.replace("IN-", "OUT-");
            String[] arr = filename.split("-");
            String item_code = arr[3];
            result = this.jtlzComponent.license_issue(item_code, content);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)result) || !result.contains("\u91cd\u590d\u7684\u7535\u5b50\u8bc1\u7167")) break block6;
            StringBuilder trace = new StringBuilder();
            Exception lastException = null;
            try {
                trace.append("step0;");
                Map map = (Map)this.jsonProvider.getData(content, Map.class);
                trace.append(String.format("step1;=%s;", map == null));
                JSONObject dataObject = (JSONObject)map.get("data");
                trace.append(String.format("step2;=%s;", dataObject == null));
                JSONObject feizhiMap = new JSONObject();
                feizhiMap.put("service_item_code", dataObject.get((Object)"service_item_code"));
                feizhiMap.put("service_item_name", dataObject.get((Object)"service_item_name"));
                feizhiMap.put("biz_num", (Object)UUID.randomUUID().toString());
                trace.append(String.format("step3;=%s;", dataObject == null));
                JSONObject data_fields = dataObject.getJSONObject("data_fields");
                trace.append(String.format("step4;=%s;", data_fields == null));
                String ZZHM = data_fields.getString("ZZHM");
                trace.append(String.format("step5;=%s;", ZZHM == null));
                feizhiMap.put("id_code", (Object)ZZHM);
                feizhiMap.put("operator", dataObject.get((Object)"operator"));
                trace.append("step6;");
                JSONObject data = new JSONObject();
                data.put("data", (Object)feizhiMap);
                String body = data.toJSONString();
                result = this.jtlzComponent.license_issue_fz(item_code, body);
                trace.append("step7;");
            }
            catch (Exception ex) {
                try {
                    lastException = ex;
                }
                catch (Throwable throwable) {
                    logger.error("{}-Ignore-retry to license_issue_fz before license={};trace={}", new Object[]{filename, result, trace, lastException});
                    throw throwable;
                }
                logger.error("{}-Ignore-retry to license_issue_fz before license={};trace={}", new Object[]{filename, result, trace, lastException});
            }
            logger.error("{}-Ignore-retry to license_issue_fz before license={};trace={}", new Object[]{filename, result, trace, lastException});
            result = this.jtlzComponent.license_issue(item_code, content);
        }
        boolean rt = false;
        if (!outputFile) {
            // empty if block
        }
        rt = FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
        return JTLZResponseValueEDI.create((String)outFilename, (String)result, (boolean)rt);
    }

    protected void jtlzFzServer(String filename, String content) {
        String outFilename = filename.replace("IN-", "OUT-");
        String[] arr = filename.split("-");
        String item_code = arr[3];
        String result = this.jtlzComponent.license_issue_fz(item_code, content);
        FtpWriteUtil.uploadBase64((String)FileWriteConfig.getFilePath(), (String)outFilename, (String)result);
    }
}

