/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.backend.domain.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static AtomicInteger fileLockCount = new AtomicInteger(0);

    public static boolean mkdirs(File file) {
        if (null == file) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        return file.mkdirs();
    }

    public static boolean mkdirs(String directory) {
        if (StringUtils.isBlank((CharSequence)directory)) {
            return false;
        }
        return FileUtils.mkdirs(new File(directory));
    }

    public static boolean exists(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        File file = new File(fileName);
        return file.exists();
    }

    public static List<File> filenames(String path, String keyword) {
        List matchedFiles = null;
        List<File> recentlyMatchFiles = null;
        File folder = new File(path);
        if (folder == null) {
            return Collections.EMPTY_LIST;
        }
        File[] subFiles = folder.listFiles();
        if (subFiles == null) {
            return Collections.EMPTY_LIST;
        }
        StringBuilder trace = new StringBuilder();
        try {
            trace.append(String.format("Obtaining normal files:%s;", keyword));
            matchedFiles = Arrays.stream(subFiles).filter(ii -> ii.isFile() && (StringUtils.isEmpty((CharSequence)keyword) || ii.getName().startsWith(keyword))).collect(Collectors.toList());
            trace.append(String.format("size=:%s;", matchedFiles == null ? "0" : Integer.valueOf(matchedFiles.size())));
            recentlyMatchFiles = matchedFiles.stream().sorted((f1, f2) -> {
                try {
                    return Long.compare(f2.lastModified(), f1.lastModified());
                }
                catch (Exception ex) {
                    logger.error("\u6bd4\u8f83\u6587\u4ef6\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38:{}={}-{}={}", new Object[]{f1.getName(), f1.lastModified(), f2.getName(), f2.lastModified()});
                    return 0;
                }
            }).limit(100L).collect(Collectors.toList());
            logger.error("Filenames: success in getting files({})(original={},size={})", new Object[]{keyword, subFiles.length, matchedFiles.size()});
            return recentlyMatchFiles;
        }
        catch (Exception ex) {
            logger.error("failed to getting files({}); track={}", new Object[]{keyword, trace, ex});
            throw ex;
        }
    }

    public static void writeFile(String filePath, String fileName, String content) {
        File file = new File(filePath + File.separator + fileName);
        if (!file.exists()) {
            FileUtils.touch(file);
        }
        FileUtil.writeString((String)content, (File)file, (String)"UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String urlToBase64(HttpClient httpClient, String url) {
        try {
            HttpGet httpGet = new HttpGet(url);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            try (InputStream inputStream = httpResponse.getEntity().getContent();){
                byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
                String string = Base64.encode((byte[])bytes);
                return string;
            }
        }
        catch (Exception ex) {
            logger.error("urlToBase64({})", (Object)url, (Object)ex);
            throw new RuntimeException(String.format("urlToBase64(%s)", url), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileToBase64(String filePath) {
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String string = Base64.encode((byte[])bytes);
            return string;
        }
        catch (Exception e) {
            logger.error("fileToBase64({})", (Object)filePath, (Object)e);
            return "";
        }
    }

    public static void touch(File file) {
        try {
            while (fileLockCount.get() > 500) {
                ThreadUtil.sleep((long)500L);
                logger.error("Not Allowed to touch file={} count={}", (Object)file, (Object)fileLockCount.get());
            }
            fileLockCount.incrementAndGet();
            FileUtil.touch((File)file);
        }
        finally {
            fileLockCount.decrementAndGet();
        }
    }
}

