package com.bcxin.backend.domain.syncs.services.impls;

import com.bcxin.backend.domain.syncs.services.CleanQueuesCacheService;
import org.apache.http.client.utils.DateUtils;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Service
public class CleanQueuesCacheServiceImpl implements CleanQueuesCacheService {
    private static Map<String, Map<String, String>> queuesIds = new ConcurrentHashMap();

    @Override
    public void cleanQueuesCache() {
        Date today = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.add(Calendar.DAY_OF_MONTH, -2);
        Date twoDay = calendar.getTime();
        String dateKey = DateUtils.formatDate(twoDay, "yyyy-MM-dd");
        queuesIds.remove(dateKey);
    }

    @Override
    public Map<String, Map<String, String>> getQueuesIds() {
        return queuesIds;
    }
}
