package com.bcxin.backend.domain.syncs.dtos;

import com.bcxin.runtime.domain.syncs.dtos.FileItemRequestDto;
import lombok.Getter;

import java.util.Collection;

@Getter
public class FileSyncRequestDto {
    private final String id;
    private final Collection<FileItemRequestDto> fileItems;

    public FileSyncRequestDto(String id, Collection<FileItemRequestDto> fileItems) {
        this.id = id;
        this.fileItems = fileItems;
    }

    public static FileSyncRequestDto create(String id, Collection<FileItemRequestDto> fileItems) {
        return new FileSyncRequestDto(id, fileItems);
    }
}
