package com.bcxin.backend.domain.configs;


import javax.sql.DataSource;
import javax.xml.crypto.Data;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;

import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.core.JdbcTemplate;



@Configuration
public class ScreenDataSourceConfig {

    @Bean
    @ConfigurationProperties(prefix = "spring.datasource.screen")
    public DataSourceProperties screenDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @Qualifier("primaryDataSource")
    public DataSource primaryDataSource() {
        DataSource ds = screenDataSourceProperties().initializeDataSourceBuilder().build();

        return ds;
    }


    @Bean
    @Qualifier("primaryJdbcTemplate")
    public JdbcTemplate primaryJdbcTemplate(
            @Qualifier("primaryDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }
}
