package com.bcxin.backend.domain.system.dispatch.requests;

import com.bcxin.backend.domain.system.dispatch.snapshots.ValueSnapshot;

import java.util.HashMap;
import java.util.Map;

public abstract class DispatchRequestAbstract {
    private final DispatchType dispatchType;
    private final ValueSnapshot valueSnapshot;

    public DispatchRequestAbstract(DispatchType dispatchType,
                                   ValueSnapshot valueSnapshot) {
        this.dispatchType = dispatchType;
        this.valueSnapshot = valueSnapshot;

        Map<String, Object> params = this.getPostData().getAdditionalParams();
        if (params == null) {
            params = new HashMap<>();
        }
        params.put("dispatchType", dispatchType);
        params.put("dispatch-data-source", "v5");

        this.valueSnapshot.setAdditionalParams(params);
    }

    public DispatchType getDispatchType() {
        return dispatchType;
    }

    public ValueSnapshot getPostData() {
        return this.valueSnapshot;
    }

    /**
     * 返回对应application.yml中的patch.dispatch.api.certificates的类型(比如: user/doamin/depart..)
     *
     * @return
     */
    public abstract String getConfigKey();
}
