/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.signature.service.SignatureToPDFService;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class SignatureToPDFServiceImpl
implements SignatureToPDFService {
    private static final Logger log = LoggerFactory.getLogger(SignatureToPDFServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final String cgiApi = "https://192.168.60.61:8890/XMPSignQuicklyExCGI.cgi";
    private final SignatureQueuesRepository signatureQueuesRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.signature.unSignaturePDF}")
    String unSignatureSignatureToPDFServiceImplPDF;
    @Value(value="${myapps.signature.signaturePDF}")
    String signaturePDF;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Autowired
    private ConvertServiceImpl convertService;

    public SignatureToPDFServiceImpl(@Qualifier(value="primaryJdbcTemplate") JdbcTemplate jdbcTemplate, SignatureQueuesRepository signatureQueuesRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.signatureQueuesRepository = signatureQueuesRepository;
    }

    @Override
    public void cerPDF() {
        Long a = System.currentTimeMillis();
        log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a1");
        log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date()));
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a1");
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date()));
        try {
            this.createPDF();
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1asignaturePDF create pdf to FTP end !");
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1asignaturePDF create pdf to FTP end !");
        }
        catch (Exception e) {
            log.error("=====> \u6279\u91cf\u751f\u6210pdf\u6587\u4ef6:createPDF(),ERROR:" + e.getMessage());
        }
        log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activateXMPSignQuicklyExCGI() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject json = new JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001009256");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in");
            json.put("out", (Object)"/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", (Object)405);
            pos.put("centerY", (Object)312);
            pos.put("page", (Object)1);
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.url\uff1ahttps://192.168.60.61:8890/XMPSignQuicklyExCGI.cgi");
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.param\uff1a" + json.toJSONString());
            String ret = HttpUtil.post((String)"https://192.168.60.61:8890/XMPSignQuicklyExCGI.cgi", (String)json.toJSONString());
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                boolean bl = false;
                return bl;
            }
            JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            if ("1".equals(String.valueOf(result.get((Object)"code")))) {
                sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.boolean\uff1atrue");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            log.error(sb.toString());
        }
    }

    private void createPDF() {
        System.err.println("=============> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cbcreatePDF() <=============");
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueues("0", PageRequest.of((int)0, (int)10));
        System.err.println("=============> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u7b2c\u4e00\u884cpageQueues\u6267\u884c\u5b8c\u6bd5,pageQueues\u7684\u503c\u4e3a\uff1a <=============" + pageQueues);
        List queues = pageQueues.getContent();
        System.err.println("=============> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u7b2c\u4e8c\u884cgetContent\u6267\u884c\u5b8c\u6bd5,queues\u7684\u503c\u4e3a\uff1a <=============" + queues);
        if (Collections.isEmpty((Collection)queues)) {
            return;
        }
        System.err.println("=============> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u7b2c\u4e09\u884cisEmpty\u6267\u884c\u5b8c\u6bd5,queues\u7684\u503c\u4e3a\uff1a <=============" + queues);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        int i = 1;
        while (i <= queues.size()) {
            int finalI = i++;
            CompletableFuture<Void> f = CompletableFuture.runAsync(() -> {
                SignatureQueuesDTO queuesDTO = (SignatureQueuesDTO)queues.get(finalI);
                this.accept(queuesDTO);
                System.err.println("=============> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1accept\u6267\u884c\u6210\u529f <=============" + finalI);
            });
            futures.add(f);
        }
        System.err.println("=========>>\u5df2\u5206\u914d\u5185\u5b58: " + Runtime.getRuntime().totalMemory() / 1024L / 1024L + "m  \u5df2\u5206\u914d\u5185\u5b58\u4e2d\u7684\u5269\u4f59\u7a7a\u95f4: " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "m  \u6700\u5927\u53ef\u7528\u5185\u5b58: " + (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "m<<===========");
    }

    public static void main(String[] args) {
        ArrayList<String> queues = new ArrayList<String>();
        for (int i = 0; i < 101; ++i) {
            queues.add(i + "");
        }
        int count = queues.size() / 10;
        if (queues.size() % 10 != 0) {
            ++count;
        }
        for (int i = 1; i <= count; ++i) {
            ArrayList arrayList = new ArrayList();
            for (int j = (i - 1) * 10; j < i * 10 && j != queues.size(); ++j) {
                arrayList.add(queues.get(j));
            }
            System.out.println(arrayList);
        }
        System.out.println("count\u4e3a\uff1a" + count);
    }

    private void accept(SignatureQueuesDTO queue) {
        Long a = System.currentTimeMillis();
        SignatureData data = (SignatureData)JSONObject.parseObject((String)queue.getData(), SignatureData.class);
        data.setUnSignaturePDF(this.tempPDF + "/queueId_" + queue.getId() + ".pdf");
        String toDay = data.getFzDate();
        if (StringUtils.isEmpty((CharSequence)toDay)) {
            toDay = DateUtil.today();
        }
        data.setZYear(toDay.split("-")[0]);
        data.setZMonth(toDay.split("-")[1]);
        data.setZDay(toDay.split("-")[2]);
        data.setHeadphoto(data.getHeadphoto().startsWith("http") ? data.getHeadphoto() : this.urlHead + data.getHeadphoto());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tempUrl", (Object)queue.getTemplate_url());
        jsonObject.put("formData", (Object)data);
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.1param\uff1a" + jsonObject.toJSONString());
        String result = "";
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(queue.getTemplate_url());
        sharedConvertDto.setFormData(data);
        try {
            result = this.convertService.execConvertHtmltopdfForTemp(sharedConvertDto);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.result\uff1a" + result);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.signatureQueuesRepository.updateSignature("3", new Date(), "PDF\u5df2\u751f\u6210\u5f85\u7b7e\u7ae0", queue.getId());
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.result\uff1aPDF\u5df2\u751f\u6210\u5230temp\u4e34\u65f6\u76ee\u5f55\uff1a" + data.getUnSignaturePDF());
        } else {
            this.signatureQueuesRepository.updateSignature("2", new Date(), "PDF\u751f\u6210\u5931\u8d25", queue.getId());
        }
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.\u7535\u5b50\u7b7e\u7ae0\u6d41\u7a0b\u7ed3\u675f\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSignature() {
        System.err.println("====> doSignature\u5f00\u59cb................");
        Long a = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tempUrl", (Object)this.tempPDF);
        jsonObject.put("formData", (Object)30);
        StringBuilder sb = new StringBuilder();
        StopWatch stopWatch = new StopWatch();
        try {
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.doSignature.param\uff1a" + jsonObject.toJSONString());
            stopWatch.start("\u5f00\u59cb\u6267\u884c\u526a\u5207\u6587\u4ef6\u64cd\u4f5c");
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            String tempUrl = jsonObject.getString("tempUrl");
            String formData = jsonObject.getString("formData");
            sharedConvertDto.setTempUrl(tempUrl);
            sharedConvertDto.setFormData(formData);
            String result = this.convertService.existsPdfCopy(sharedConvertDto);
            stopWatch.stop();
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.doSignature.result\uff1a" + result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                return;
            }
            String couStr = result.split(",")[0];
            String idStr = result.split(",")[1];
            if (StringUtils.isEmpty((CharSequence)idStr)) {
                return;
            }
            String qidS = "(" + idStr.replace(".pdf", "'").replace("queueId_", "'").replace(";", ",") + ")";
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.doSignature.qidS\uff1a" + qidS);
            stopWatch.start("\u5f00\u59cb\u89e6\u53d1\u76ee\u5f55\u8fdb\u884c\u7b7e\u7ae0\u64cd\u4f5c");
            if (!this.activateXMPSignQuicklyExCGI()) {
                stopWatch.stop();
                stopWatch.start("\u5f00\u59cb\u4fee\u6539\u7b7e\u7ae0\u961f\u5217\u72b6\u6001");
                this.signatureQueuesRepository.updateSignatures("2", new Date(), "PDF\u7b7e\u7ae0\u5931\u8d25", qidS);
                sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.doSignature\uff1aactivateXMPSignQuicklyExCGI task Fail !");
                stopWatch.stop();
                return;
            }
            stopWatch.stop();
            stopWatch.start("\u5f00\u59cb\u5faa\u73af\u8bfb\u53d6\u961f\u5217");
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.doSignature.signaturePDF.star");
            this.scan();
            stopWatch.stop();
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.doSignature.\u7535\u5b50\u7b7e\u7ae0\u6d41\u7a0b\u7ed3\u675f\u5355\u6b21\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        finally {
            log.error(stopWatch.toString() + ":" + sb.toString());
            System.err.println("====> stopWatch message:" + stopWatch.toString() + ":" + sb.toString());
        }
    }

    @Override
    public void changeStatus() {
        String updateSql = "update obpm2_security.signature_queues set status = '0' where status = '3' and TIMESTAMPDIFF(HOUR, last_processed_time, NOW()) > 3";
        System.err.println("===========>updateStatusSql\u4e3a\uff1a<================" + updateSql);
        this.jdbcTemplate.update(updateSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan() {
        StringBuilder sb = new StringBuilder();
        try {
            Long a = System.currentTimeMillis();
            JSONObject jsonObject = new JSONObject();
            String pdfFile = "/uploads/pdf/dianziqianzhang/out";
            jsonObject.put("tempUrl", (Object)pdfFile);
            jsonObject.put("formData", null);
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.param\uff1a" + jsonObject.toJSONString());
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            sharedConvertDto.setTempUrl(pdfFile);
            sharedConvertDto.setFormData(null);
            String result = this.convertService.existsScanSignature(sharedConvertDto);
            if (StringUtils.isEmpty((CharSequence)result)) {
                return;
            }
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.result\uff1a" + result);
            JSONObject json = JSONObject.parseObject((String)result);
            Object success = json.get((Object)"success");
            Object fail = json.get((Object)"fail");
            String successQidS = "";
            String failQidS = "";
            String successFile = "";
            String failFile = "";
            if (success != null) {
                successFile = (String)success;
                successQidS = "(" + successFile.replace(".pdf", "'").replace("queueId_", "'") + ")";
                sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successQidS\uff1a" + successQidS);
            }
            if (fail != null) {
                failFile = (String)fail;
                failQidS = "(" + failFile.replace(".pdf", "'").replace("queueId_", "'") + ")";
                sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.failQidS\uff1a" + failQidS);
            }
            if (StringUtils.isNotEmpty((CharSequence)successQidS)) {
                String[] successSplit;
                for (String string : successSplit = successFile.split(",")) {
                    String successFilePath = pdfFile + "/" + string;
                    String id = string.replace("queueId_", "").replace(".pdf", "");
                    String updateSql = "UPDATE tlk_certificate a INNER JOIN obpm2_security.signature_queues b ON a.id = b.businness_id SET a.ITEM_SIGNATURED_PROCESSED_STATUS='2',a.ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),a.ITEM_CERTIFICATEDATE=IFNULL(ITEM_CERTIFICATEDATE,NOW()),a.ITEM_LAST_SIGNATURED_PROCESSED_RESULT='\u5b8c\u6210',a.ITEM_ATTACHMENT='" + successFilePath + "' WHERE b.ID='" + id + "';";
                    sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.updateSql\uff1a" + updateSql);
                    this.jdbcTemplate.update(updateSql);
                }
                this.signatureQueuesRepository.updateSignatures("1", new Date(), "\u6210\u529f", successQidS);
                sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.update\uff1asucceful");
            } else if (StringUtils.isNotEmpty((CharSequence)failQidS)) {
                this.signatureQueuesRepository.updateSignatures("2", new Date(), "\u672a\u6210\u529f\u7b7e\u7ae0", failQidS);
                sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.update\uff1afail");
            }
            sb.append("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.30\u4e2aPDF\u5df2\u7b7e\u7ae0\u6587\u4ef6\u5b58FTP\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        finally {
            log.error(sb.toString());
            System.err.println("====> scan message:" + sb.toString());
        }
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureToPDFServiceImpl.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "SignatureToPDFServiceImpl.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

