/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.common;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.util.StringUtils;

public class TimestampPropertyEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;
    private final boolean useTimestamp;
    private final int exactDateLength;

    public TimestampPropertyEditor(DateFormat dateFormat, boolean allowEmpty, boolean useTimestamp) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
        this.useTimestamp = useTimestamp;
        this.exactDateLength = -1;
    }

    public TimestampPropertyEditor(DateFormat dateFormat, boolean allowEmpty, int exactDateLength) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
        this.useTimestamp = false;
        this.exactDateLength = exactDateLength;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            if (text != null && this.exactDateLength >= 0 && text.length() != this.exactDateLength) {
                throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength + "characters long");
            }
            if (text.indexOf(":") < 0) {
                text = text.trim() + " 00:00:00";
            }
            try {
                Date value = this.dateFormat.parse(text);
                if (this.useTimestamp) {
                    value = new Timestamp(value.getTime());
                }
                this.setValue((Object)value);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage());
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = null;
        value = this.useTimestamp ? (Date)this.getValue() : (Date)this.getValue();
        return value != null ? this.dateFormat.format(value) : "";
    }
}

