package com.baichuanxin.openrestapi.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/***
 *@Author duxiangyun
 *@Description 设立分公司
 *@Date 2024/8/24
 */
@Data
@TableName("tlk_Establish")
public class RegistrationBranch {

    //办件数据
    @TableField("taskId")
    private String taskId;
    //表单需求数据
    @TableId("ID")
    private String id;
    //创建时间
    @TableField("CREATED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date created;
    @TableField("LASTMODIFIED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date lastmodified;
    @TableField("FORMNAME")
    private String formname ;
    @TableField("FORMID")
    private String formid;
    @TableField("ISTMP")
    private boolean istmp;
    @TableField("APPLICATIONID")
    private String applicationid;
    @TableField("DOMAINID")
    private String domainid;
    @TableField("ITEM_REGION")
    private String itemRegion;
    /**
     *1、选择办事区域
     */
    //所属监管机构
    @TableField(value = "item_officePoliceAddress")
    private String itemOfficePoliceAddress;
    @TableField("ITEM_OFFICEPOLICEADDRESSID")
    private String itemitemOfficePoliceAddressid;
    @TableField("ITEM_OFFICEPOLICEIDINDEX")
    private String itemOfficePoliceidindex;
    /**
     * 2、填写总公司信息
     */
    //总公司名称
    @TableField(value = "item_companyName" )
    private String itemCompanyName;
    //公司地址
    @TableField(value = "item_address")
    private String itemAddress;
    //统一社会信用代码
    @TableField(value = "item_creditCode")
    private String itemCreditCode;
    //保安服务许可证号
    @TableField(value = "item_licenceNum")
    private String itemLicenceNum;
    //联系电话
    @TableField("item_phone")
    private String itemPhone;
    //法人姓名
    @TableField(value = "item_legalName")
    private String itemLegalName;
    //法人证证件类型
    @TableField(value = "item_legalType")
    private String  itemLegalType;
    //法人证件号码
    @TableField(value = "item_legalCardnumber")
    private String itemLegalCardnumber;
    //法人手机号码
    @TableField(value = "item_legalPhone")
    private String itemLegalPhone;


    /**
     *  3、拟设立分公司信息*****************************
     */
    //分公司名称
    @TableField("ITEM_SONCOMPANYNAME")
    private String itemSonCompanyName;
    //办公地址
    @TableField("ITEM_SONADDRESS")
    private String itemSonAddress;
    //统一社会信用代码
    @TableField("ITEM_SON_CREDITCODE")
    private String itemSonCreditCode;
    //联系电话
    @TableField("ITEM_SON_PHONE")
    private String itemSonPhone;
    //经营范围
    @TableField("ITEM_SON_BUSINESSSCOPE")
    private String itemSonBusinessScope;

    /**
     * 4、填写分公司负责人信息
     */
    //姓名
    @TableField(value = "item_chargeName")
    private String itemChargeName;
    //联系电话
    @TableField(value = "item_chargePhone")
    private String itemChargePhone;
    //职务
    @TableField(value = "item_chargePost")
    private String itemChargePost;
    //居民身份证号
    @TableField(value = "item_chargeCardnumber")
    private String itemChargeCardnumber;
    //性别
    @TableField(value = "item_charge_sex")
    private String itemChargeSex;
    //年龄
    @TableField(value = "item_charge_age")
    private String itemChargeAge;
    //籍贯
    @TableField(value = "item_charge_household")
    private String itemChargeHousehold;
    //民族
    @TableField(value = "item_charge_nation")
    private String itemChargeNation;
    //现住址
    @TableField(value = "item_charge_address")
    private String itemChargeAddress;
    //中华人民共和国职业资格证书号
    @TableField(value = "item_charge_certificate")
    private String itemChargeCertificate;
    //工作简历
    @TableField(value = "item_job_resume")
    private String itemJobResume;

    /**
     * 5、保安员信息（可多行）  保安员表tlk_securityinformation、SecurityMan
     */
    @TableField("ITEM_PERSON_NUM")
    private String itemPersonNum;
    /**
     * 6、经办人信息
     */
    //姓名
    @TableField(value = "item_applicant_name")
    private String itemApplicantName;
    //联系电话
    @TableField(value = "item_applicant_phone")
    private String itemApplicantPhone;

    /**
     * 8、承诺上述填报信息真实有效
     */
    //承诺上述填报信息真实有效
    @TableField(value = "item_permit")
    private String itemPermit;

    /**
     * 9、上传电子版材料（模版下载）
     */

    /**
     * 10、申请审核信息
     */


    //审核状态
    @TableField("ITEM_AUDITSTATUS")
    private String itemAuditStatus;
    //审核时间
    @TableField("item_over_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date itemOverTime;
    //审核意见
    @TableField("item_apply_remark")
    private String  itemApplyRemark;
    //审核文书
    @TableField("item_service_file")
    private String itemServiceFile;
    @TableField("isdelivery")
    private String isdelivery;
}
