package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.ChangeLegalPerson;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.Shareholder;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *@Author duxiangyun
 *@Description 法人变更业务数据解析
 *@Date 2024/8/30
 */
@Data
public class ChangeLegalPersonDto {


    /**
     * 1、选择办事区域
     */
    //所属监管机构
    private String item_officePoliceAddress;
    /**
     * 2、填写单位基本信息
     */
    //申请单位名称
    private  String item_companyName;
    //办公住所
    private  String item_address;
    //注册资本
    private  String item_registeredCapital;
    //统一社会信用代码
    private String  socialCreditNo;
    //保安服务许可证号
    private String bafwxkzh;
    //服务范围
    private  List<String> item_businessScope;
    //批准文号
    private String pzwh;
    /**
     * 3、填写原股东信息
     */
    private List<ShareholderDto> item_shareholder;

    /**
     * 填写原法定代表人信息
     */
    //姓名
    private String item_legalName;
    //性别
    private String item_legalSex;
    //民族
    private String item_nation;
    //政治面貌
    private String item_identity;
    //文化程度
    private String item_education;
    //保安师资格证编号
    private String item_vocational_certificate;
    //证件类型
    private String item_legalType;
    //证件号码
    private String item_legalCardnumber;
    //联系电话
    private String item_hunan_telephone;
    /**
     * 5、填写拟定代表人信息
     */
    //姓名
    private String item_appointmentLegalName;
    //联系电话
    private String item_new_hunan_telephone;
    //身份证件号码
    private String item_new_hunan_legal;
    /**
     * 6、填写许可证领取方式
     */
    //新证领取方式
    private String item_claim_way;
    //领取地址
    private String xzlqdz;
    //收件人
    private String jzsjr;
    //手机号
    private String agentPhone_2;
    //收件地址
    private String sjdz;
    //旧证收回方式
    private String item_jiu_claim;
    //收回地址
    private String jzshdz;
    //收件人
    private String jzhssjr;
    //手机号
    private String jzhssjrsjh;
    //收件地址
    private String jzhssjdz;
    /**
     * 7、经办人信息
     */
    //姓名
    private String item_applicant_name;
    //联系电话
    private String item_applicant_phone;
    /**
     * 8、承诺上述填报信息真实有效
     */
    //承诺上述填报信息真实有效
    private String item_premit;

    public ChangeLegalPerson convert(Notice notice){
        ChangeLegalPerson changeLegalPerson  =new ChangeLegalPerson();
        Date now  = new Date();
        //办件数据
        changeLegalPerson.setTaskId(notice.getTaskId());
        //表单需求数据
        changeLegalPerson.setId(StrUtil.join("--",notice.getTaskId(), OnlineTaskConstant.CHANGE_LEGAL_PERSON));
        changeLegalPerson.setCreated(now);
        changeLegalPerson.setLastmodified(now);
        changeLegalPerson.setFormname("");
        changeLegalPerson.setFormid(OnlineTaskConstant.CHANGE_LEGAL_PERSON);
        changeLegalPerson.setIstmp(true);
        changeLegalPerson.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        changeLegalPerson.setDomainid("__UDa4uPMdcOYgP7HETaf");
        changeLegalPerson.setItemRegion("湖南省");
        changeLegalPerson.setIsdelivery("0");
        //办事区域
        changeLegalPerson.setItemOfficePoliceAddress(this.getItem_officePoliceAddress());  ////
        changeLegalPerson.setItemCompanyName(this.getItem_companyName());
        //格式化公司地址
        AddressDto addressDto = JSON.parseObject(this.getItem_address(), AddressDto.class);
        changeLegalPerson.setItemAddress(addressDto.convert());
        changeLegalPerson.setItemRegisteredCapital(this.getItem_registeredCapital());

        changeLegalPerson.setItemUscc(this.getSocialCreditNo());   //社会信用代码
        changeLegalPerson.setItemSecurityTrainPermitNo(this.getBafwxkzh()); //保安服务许可证号
        changeLegalPerson.setItemBusinessScope(OnlineTaskUtil.scopConvert(this.getItem_businessScope()));
        changeLegalPerson.setItemApprovalNumber(this.getPzwh());  //批准文号
        //原法定代表人信息
        changeLegalPerson.setItemLegalName(this.getItem_legalName());
        changeLegalPerson.setItemLegalSex(this.getItem_legalSex());
        changeLegalPerson.setItemNation(this.getItem_nation());
        changeLegalPerson.setItemIdentity(OnlineTaskUtil.identConvert(this.getItem_identity()));
        changeLegalPerson.setItemEducation(this.getItem_education());
        changeLegalPerson.setItemVocationalCertificate(this.getItem_vocational_certificate());
        changeLegalPerson.setItemLegalType(OnlineTaskUtil.idCardTypeConvert(this.getItem_legalType()));
        changeLegalPerson.setItemLegalCardnumber(OnlineTaskUtil.decrypt(this.getItem_legalCardnumber()));
        changeLegalPerson.setItemLegalPhone(this.getItem_hunan_telephone());
        //  拟定代表人信息
        changeLegalPerson.setItemAppointmentLegalName(this.getItem_appointmentLegalName());
        changeLegalPerson.setItemNewHunanTelephone(this.getItem_new_hunan_telephone());
        changeLegalPerson.setItemNewHunanLegal(OnlineTaskUtil.decrypt(this.getItem_new_hunan_legal()));

        //许可证领取方式
        changeLegalPerson.setItemClaimWay(this.getItem_claim_way());
        if (this.getItem_claim_way().equals("1")){
            changeLegalPerson.setItemRecipientAddress(this.getXzlqdz());
        }else {
            changeLegalPerson.setItemRecipientAddress(this.getSjdz());
        }
        changeLegalPerson.setItemRecipient(this.getJzsjr());
        changeLegalPerson.setItemRecipientPhone(this.getAgentPhone_2());

        //旧证回收
        changeLegalPerson.setItemJiuClaim(this.getItem_jiu_claim());

        changeLegalPerson.setItemConsignee(this.getJzhssjr());
        changeLegalPerson.setItemConsigneePhone(this.getJzhssjrsjh());
        if (this.getItem_jiu_claim().equals("1")){  //2 是线下邮寄
            changeLegalPerson.setItemRecipientAddress(this.getJzshdz());
        }else {
            changeLegalPerson.setItemConsigneeAddress(this.getJzhssjdz());
        }
        //经办人信息
        changeLegalPerson.setItemHunanName(this.getItem_applicant_name());
        changeLegalPerson.setItemHunanOfficeTelephone(this.getItem_applicant_phone());
        //承诺上述信息真实有效
        changeLegalPerson.setItemPermit(this.getItem_premit());
        //审核状态数据
        changeLegalPerson.setItemAuditStatus("3");
        return changeLegalPerson;
    }

}
