package com.bcxin.risk.sys;


import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

/**
 * 系统提示
 *
 * @author 张建华
 */
@Entity
@Table(name = "sys_tips")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SysTips extends BaseBean {

    private static final long serialVersionUID = 1L;


    /**
     * 状态
     */
    private String status;

    /**
     * 站点
     */
    private String website;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Temporal(TemporalType.TIMESTAMP)
    private Date startTime;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Temporal(TemporalType.TIMESTAMP)
    private Date endTime;

    /**
     * 提示标题
     */
    private String title;

    /**
     * 提示内容
     */
    private String content;

    /**s
     * 省份代码
     */
    private String provinceCode;

}
