package com.bcxin.risk.survey.domain.dto.data;

import lombok.Data;

import java.util.Map;

/**
 * 整改意见列表
 * @author luopeng
 *
 */
@Data
public class SurveyInfoDTO {

	private String venueName;
	 
	/** 评估机构的勘查意见*/
	private String opinion;
	
	/** 承办方对应的整改反馈*/
	private String solve;
	
	/** 评估机构的勘查意见对应的图片附件*/
	private String opinionAttachmentUrl; // www.abc.com/a.jpg#www.abc.com/b.jpg

	/** 承办方的整改反馈对应的图片附件*/
	private String solveAttachmentUrl; // www.abc.com/a.jpg#www.abc.com/b.jpg

	public SurveyInfoDTO(){}

	public SurveyInfoDTO(Map<String,Object> map){
		this.venueName = safeTransfor(map.get("venueName"));
		this.opinion = safeTransfor(map.get("opinion"));
		this.solve = safeTransfor(map.get("solve"));
		this.opinionAttachmentUrl = safeTransfor(map.get("opinionAttachmentUrl"));
		this.solveAttachmentUrl = safeTransfor(map.get("solveAttachmentUrl"));
	}


	/**
	 *
	 * <b>Function 将Object安全转换为String</b>
	 *
	 * @param obj
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月22日 下午5:17:02
	 * @注意事项 </b>
	 * <b>
	 */
	private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
	
}
