package com.bcxin.risk.survey.domain;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.Type;

import com.bcxin.risk.base.domain.BaseBean;

/**
 * 整改意见列表
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_Rectification_Info")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class Survey_Rectification_Info extends BaseBean {

	 
	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Survey_Rectification.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "survey_RectificationId")
	private Survey_Rectification survey_Rectification;
	
	/** 评估机构的勘查意见*/
	private String opinion;
	
	/** 承办方对应的整改反馈*/
	private String solve;
	
	/** 评估机构的勘查意见对应的图片附件*/
	@Type(type="text")
	private String opinionAttachmentUrl; // www.abc.com/a.jpg#www.abc.com/b.jpg

	/** 承办方的整改反馈对应的图片附件*/
	@Type(type="text")
	private String solveAttachmentUrl; // www.abc.com/a.jpg#www.abc.com/b.jpg
	
}
