package com.bcxin.risk.survey.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import com.bcxin.risk.activity.Venue;
import lombok.Data;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.report.enums.TaskStatus;


/**
 * <b>活动勘查阶段下关联场馆问卷 </b>
 * 
 * @author LinQingLin
 * @date 2016年12月14日 下午6:44:55
 * @注意事项 </b>
 * <b>
 */
@Entity
@Table(name = "RISK_Survey_Questionnaire")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class Survey_Questionnaire extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**  所属活动勘察阶段*/
	@ManyToOne(targetEntity = Survey_FeedBack.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "feedBackId")
	private Survey_FeedBack feedBack = new Survey_FeedBack();
	
	/**  勘察阶段*/
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;
	
	/**  各勘察项目问题明细*/
	@OneToMany(targetEntity = Survey_Info.class, cascade = CascadeType.REMOVE, mappedBy="questionnaire", fetch = FetchType.LAZY)
	@OrderBy("sort,oid asc")
    private List<Survey_Info> surveyInfos = new ArrayList<Survey_Info>();

	/**  所属场馆信息*/
	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venueId")
    private Venue venue = new Venue();

	/**  状态*/
	@Enumerated(EnumType.STRING)
	private TaskStatus taskStatus;

	/**  勘查开始时间*/
	private Date beginTime;
	
	/**  勘查结束时间*/
	private Date endTime;

	/**  是否整改*/
	private boolean correction = false;
	
	/**  是否生成问卷*/
	private boolean generate = false;
	
	/**  勘查报告路径*/
	private String reportPath;

	/**  勘查计划*/
	@OneToMany(targetEntity = SurveyPlan.class, mappedBy="questionnaire", fetch = FetchType.LAZY)
    private List<SurveyPlan> surveyPlans = new ArrayList<SurveyPlan>();
	

}
