package com.bcxin.risk.survey.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

import com.fasterxml.jackson.annotation.JsonBackReference;


/**
 * 勘查签到表
 * @author luopeng
 *
 */
@Entity
@Table(name = "risk_surveySign")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class SurveySign extends BaseBean {
	 
	private static final long	serialVersionUID	= 1L;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "userId")
	private User user;

	/** 经度 **/
	public double latitude;

	/** 纬度 **/
	public double longitude;

	/** 勘查计划ID **/
	public String planId;

	/** 签到日期 **/
	@Temporal(TemporalType.TIMESTAMP)
	private Date signDate;

}
