package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;

/**
 * 活动材料上传表单属性，元素
 * @author Ethan
 */
@Entity
@Table(name = "RISK_MaterialFormAttr")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormAttr extends BaseBean {

	private static final long serialVersionUID = -2963605545476898489L;

	/**  对应的活动*/
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;
	
	/**  排序*/
	private int seq;

	/**  元素编码，如A1，A2等*/
	private String attrCode;
	
	/**  元素名称，如公司名称等*/
	private String attrName;

	/**  是否必填*/
	private boolean isRequired;
	
	/**  元素类型，包括（text,number,radio,textarea,select,pic,file,checkbox）*/
	private String type;

	/**
	 * 多选，下拉，单选框的类型
	 */
	private String optionType;

	/**  脚本事件，如onclick="clickA59(this.value)"*/
	private String events;
	
	/**  具体js脚本 function a()*/
	@Type(type="text")
	private String script;
	
	/**  提示*/
	private String tips;

	/** 第一主体的元素**/
	private String mainEle; //0代表不是，1代表是，（如果是，则该元素只会在第一个主体中出现，新增主体对象不出现该元素）

	/***
	 * 是否在页面显示
	 */
	private String isPageHidden = "1"; //0 代表不展示 ， 1 代表展示 ; 默认展示

	/**
	 * 最大文件上传个数
	 */
	private String maxFilesize;

	/**
	 * 是否锁定，不让修改
	 */
	private String locked;


	@ManyToOne(targetEntity = MaterialFormMenu.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "menu_id")
	private MaterialFormMenu materialFormMenu;


	public boolean isFile(){
		String attrTypes = "pic,file";
		if (attrTypes.contains(this.type)) {
			return true;
		}
		return false;
	}


	public boolean isOption(){
		String attrTypes = "radio,select,checkbox";
		if (attrTypes.contains(this.type)) {
			return true;
		}
		return false;
	}
}
