package com.bcxin.risk.report.enums.draft;

import java.util.ArrayList;
import java.util.List;


public enum RiskRank {
	
	PERSON {public String getValue(){return "1";} 
			public String getName(){return "（一）人的因素15分";} 
			public String getLevel(){return "1";}},

	SITE {public String getValue(){return "2";} 
			public String getName(){return "（二）场地因素";} 
			public String getLevel(){return "1";}},		

	EVENT {public String getValue(){return "3";} 
			public String getName(){return "（三）事件因素30分";} 
			public String getLevel(){return "1";}},	
			
	GOODS {public String getValue(){return "4";} 
			public String getName(){return "（四）物品因素10分";} 
			public String getLevel(){return "1";}},	
			
	EMERGENCY {public String getValue(){return "5";} 
			public String getName(){return "（五）紧急疏散10分";} 
			public String getLevel(){return "1";}},	
			
	SAFE {public String getValue(){return "6";} 
			public String getName(){return "（六）安全防范及安全管理10分";} 
			public String getLevel(){return "1";}},	

	VERIFY {public String getValue(){return "7";} 
			public String getName(){return "（七）事项审核10分";} 
			public String getLevel(){return "1";}},
	
			
	PERSON_ONE {public String getValue(){return "1_1";} 
			public String getName(){return "1、活动承办者、各主要服务提供商的背景与举办此类活动的经验，灾害事故情况下的赔偿能力（0-2分）";} 
			public String getLevel(){return "2";}},
			
	PERSON_TWO {public String getValue(){return "1_2";} 
			public String getName(){return "2、参加的要人及国内外贵宾的安保措施（0-3分）";} 
			public String getLevel(){return "2";}},
			
	PERSON_THREE {public String getValue(){return "1_3";} 
			public String getName(){return "3、活动承办者的安全管理组织能力（0-2分）";} 
			public String getLevel(){return "2";}},
			
	PERSON_FOUR {public String getValue(){return "1_4";} 
			public String getName(){return "4、承办者本身具备的直接从事安全工作的能力（0-3分）";} 
			public String getLevel(){return "2";}},
			
	PERSON_FIVE {public String getValue(){return "1_5";} 
			public String getName(){return "5、活动承办者或组织者有无违法犯罪等不良记录，该不良记录对活动安全的影响（0-3分）";} 
			public String getLevel(){return "2";}},
			
	PERSON_SIX {public String getValue(){return "1_6";} 
			public String getName(){return "6、参加活动的群体性质、年龄比例、文化程度、数量、国籍等(0-2分)";} 
			public String getLevel(){return "2";}},
			
	SITE_ONE {public String getValue(){return "2_1";} 
			public String getName(){return "1、场地建筑基本情况（0-1分）";} 
			public String getLevel(){return "2";}},
			
	SITE_TWO {public String getValue(){return "2_2";} 
			public String getName(){return "2、活动主要分布区域的容量，场地开放程度、避难与紧急疏散能力（0-2分）";} 
			public String getLevel(){return "2";}},
			
	SITE_THREE {public String getValue(){return "2_3";} 
			public String getName(){return "3、内部停车位配备、周边道路交通情况及内部人流、车流控制与管理（0-4分）";} 
			public String getLevel(){return "2";}},
			
	SITE_FOUR {public String getValue(){return "2_4";} 
			public String getName(){return "4、场地安全保障设施服务能力与运行状态（应急广播、通风、照明），包括场地消检、电检、电梯、主要服务设施情况（0-3分）";} 
			public String getLevel(){return "2";}},
			
	SITE_FIVE {public String getValue(){return "2_5";} 
			public String getName(){return "5、临时应急或动力电源增容保障情况（0-1分）";} 
			public String getLevel(){return "2";}},
			
	SITE_SIX {public String getValue(){return "2_6";} 
			public String getName(){return "6、防爆安检措施（0-2分）";} 
			public String getLevel(){return "2";}},
			
	SITE_SEVEN {public String getValue(){return "2_7";} 
			public String getName(){return "7、周边建筑、商业密度、加油（气）站、危险化学品仓库等状况（0-2分）";} 
			public String getLevel(){return "2";}},
		
	EVENT_ONE {public String getValue(){return "3_1";} 
			public String getName(){return "1、活动的内容与规模（社会关注度、社会影响力、知名度、热度情况），参与活动各类人群的政治目的性、互动性、刺激性、社会敏感性(0-10分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_TWO {public String getValue(){return "3_2";} 
			public String getName(){return "2、举办该项活动历史上是否曾经发生过恐怖滋事事件或安全方面的问题，有无不良安全记录(0-7分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_THREE {public String getValue(){return "3_3";} 
			public String getName(){return "3、台风、暴雨、酷热等气象变化可能对活动带来的影响(0-5分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_FOUR {public String getValue(){return "3_4";} 
			public String getName(){return "4、媒体宣传及舆论导向情况(0-2分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_FIVE {public String getValue(){return "3_5";} 
			public String getName(){return "5、社会重大疫情对活动影响(0-2分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_SIX {public String getValue(){return "3_6";} 
			public String getName(){return "6、医疗救护设置情况、餐饮卫生管理情况(0-2分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_SEVEN {public String getValue(){return "3_7";} 
			public String getName(){return "7、票务销售渠道与发行情况(0-1分)";} 
			public String getLevel(){return "2";}},
			
	EVENT_EIGHT {public String getValue(){return "3_8";} 
			public String getName(){return "8、活动使用的音响、焰火、灯光、大屏幕及主题内容对公共环境的噪声、视觉、交通等环境的影响(0-1分)";} 
			public String getLevel(){return "2";}},
	
	GOODS_ONE {public String getValue(){return "4_1";} 
			public String getName(){return "1、临建设施情况（0-5分）";} 
			public String getLevel(){return "2";}},
			
	GOODS_TWO {public String getValue(){return "4_2";} 
			public String getName(){return "2、活动主要配套及相关设备设施的安全保障情况（0-3分）";} 
			public String getLevel(){return "2";}},
			
	GOODS_THREE {public String getValue(){return "4_3";} 
			public String getName(){return "3、活动所涉及的贵重物品、危险物品情况（0-2分）";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_ONE {public String getValue(){return "5_1";} 
			public String getName(){return "1、疏散通道与应急出入口状况（0-2分）";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_TWO {public String getValue(){return "5_2";} 
			public String getName(){return "2、重要环节和区域的人员流量状态及控制方案（0-2分）";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_THREE {public String getValue(){return "5_3";} 
			public String getName(){return "3、活动入场及结束后的人流、车流疏导方案（0-1分）";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_FOUR {public String getValue(){return "5_4";} 
			public String getName(){return "4、周边建筑环境及交通对紧急疏散的影响（0-2分）";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_FIVE {public String getValue(){return "5_5";} 
			public String getName(){return "5、停车场所和进出通道实施人车分离情况（0－1分）";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_SIX {public String getValue(){return "5_6";} 
			public String getName(){return "6、事故状态下专项疏散方案及其演练情况(0-1分)";} 
			public String getLevel(){return "2";}},
			
	EMERGENCY_SEVEN {public String getValue(){return "5_7";} 
			public String getName(){return "7、应急广播系统与通讯等相关保障情况（0-1分）";} 
			public String getLevel(){return "2";}},
	
	SAFE_ONE {public String getValue(){return "6_1";} 
			public String getName(){return "1、防爆安检设置及人员资格(0-1分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_TWO {public String getValue(){return "6_2";} 
			public String getName(){return "2、禁限带物品的管控措施及物品储存方案(0-1分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_THREE {public String getValue(){return "6_3";} 
			public String getName(){return "3、视频监控状况(0-3分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_FOUR {public String getValue(){return "6_4";} 
			public String getName(){return "4、活动拖延、取消、提前终止的应对方案等突发事件的处置方案预案(0-1分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_FIVE {public String getValue(){return "6_5";} 
			public String getName(){return "5、要人警卫工作方案(0-1分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_SIX {public String getValue(){return "6_6";} 
			public String getName(){return "6、各项安全方案预案的编制、演练及人员培训情况(0-1分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_SEVEN {public String getValue(){return "6_7";} 
			public String getName(){return "7、各项安全方案预案的演练及组织落实情况(0-1分)";} 
			public String getLevel(){return "2";}},
			
	SAFE_EIGHT {public String getValue(){return "6_8";} 
			public String getName(){return "8、指挥调度及通讯保障方案(0-1分)";} 
			public String getLevel(){return "2";}},

	VERIFY_ONE {public String getValue(){return "7_1";} 
			public String getName(){return "1、政府相关行业主管部门的批准文件(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_TWO {public String getValue(){return "7_2";} 
			public String getName(){return "2、承办者、活动各服务提供商签署的《大型活动安全管理协议书》（0-1分）";} 
			public String getLevel(){return "2";}},
			
	VERIFY_THREE {public String getValue(){return "7_3";} 
			public String getName(){return "3、保安公司资质及合同(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_FOUR {public String getValue(){return "7_4";} 
			public String getName(){return "4、活动场地布置平面图及主要尺寸(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_FIVE {public String getValue(){return "7_5";} 
			public String getName(){return "5、活动策划方案，包括流程、活动细节及预期效果等(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_SIX {public String getValue(){return "7_6";} 
			public String getName(){return "6、场地租用方应急广播、消防、照明、监控系统保障有关文件(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_SEVEN {public String getValue(){return "7_7";} 
			public String getName(){return "7、场地租用方供热、水、电、气系统运行保障有关文件(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_EIGHT {public String getValue(){return "7_8";} 
			public String getName(){return "8、场地活动区域安全防范设施、安检系统运行有关保障文件及其它方面涉及的行政许可文件(0-1分)";} 
			public String getLevel(){return "2";}},

	VERIFY_NINE {public String getValue(){return "7_9";} 
			public String getName(){return "9、主承办者安全工作责任制情况(0-1分)";} 
			public String getLevel(){return "2";}},
			
	VERIFY_TEN {public String getValue(){return "7_10";} 
			public String getName(){return "10、各类突发事件处置预案，主要包括：突发恐怖爆炸事件，火灾，临建倒塌，医疗救护，活动因故拖延、停办、提前举办，群体性事件，紧急疏散，抢险自救，应急处置等(0-1分)";} 
			public String getLevel(){return "2";}};
			
			
    public abstract String getValue();
    
    public abstract String getName();

    public abstract String getLevel();

    
    public static List<RiskRank> getTop(){
    	List<RiskRank> ranks = new ArrayList<RiskRank>();
    	ranks.add(PERSON);
    	ranks.add(SITE);
    	ranks.add(EVENT);
    	ranks.add(GOODS);
    	ranks.add(EMERGENCY);
    	ranks.add(SAFE);
    	ranks.add(VERIFY);
    	return ranks;
    }
    
    public static List<RiskRank> getSecond(){
    	List<RiskRank> ranks = new ArrayList<RiskRank>();
    	ranks.add(PERSON_ONE);
    	ranks.add(PERSON_TWO);
    	ranks.add(PERSON_THREE);
    	ranks.add(PERSON_FOUR);
    	ranks.add(PERSON_FIVE);
    	ranks.add(PERSON_SIX);
    	ranks.add(SITE_ONE);
    	ranks.add(SITE_TWO);
    	ranks.add(SITE_THREE);
    	ranks.add(SITE_FOUR);
    	ranks.add(SITE_FIVE);
    	ranks.add(SITE_SIX);
    	ranks.add(SITE_SEVEN);
    	ranks.add(EVENT_ONE);
    	ranks.add(EVENT_TWO);
    	ranks.add(EVENT_THREE);
    	ranks.add(EVENT_FOUR);
    	ranks.add(EVENT_FIVE);
    	ranks.add(EVENT_SIX);
    	ranks.add(EVENT_SEVEN);
    	ranks.add(EVENT_EIGHT);
    	ranks.add(GOODS_ONE);
    	ranks.add(GOODS_TWO);
    	ranks.add(GOODS_THREE);
    	ranks.add(EMERGENCY_ONE);
    	ranks.add(EMERGENCY_TWO);
    	ranks.add(EMERGENCY_THREE);
    	ranks.add(EMERGENCY_FOUR);
    	ranks.add(EMERGENCY_FIVE);
    	ranks.add(EMERGENCY_SIX);
    	ranks.add(EMERGENCY_SEVEN);
    	ranks.add(SAFE_ONE);
    	ranks.add(SAFE_TWO);
    	ranks.add(SAFE_THREE);
    	ranks.add(SAFE_FOUR);
    	ranks.add(SAFE_FIVE);
    	ranks.add(SAFE_SIX);
    	ranks.add(SAFE_SEVEN);
    	ranks.add(SAFE_EIGHT);
    	ranks.add(VERIFY_ONE);
    	ranks.add(VERIFY_TWO);
    	ranks.add(VERIFY_THREE);
    	ranks.add(VERIFY_FOUR);
    	ranks.add(VERIFY_FIVE);
    	ranks.add(VERIFY_SIX);
    	ranks.add(VERIFY_SEVEN);
    	ranks.add(VERIFY_EIGHT);
    	ranks.add(VERIFY_NINE);
    	ranks.add(VERIFY_TEN);
    	return ranks;
    }
    
//    public static RiskRank convert_value(String value){
//    	if ( "1".equals(value) ) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "3".equals(value)) {
//    		return EVENT;
//    	} else if ( "4".equals(value)) {
//    		return GOODS;
//    	} else if ( "5".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "6".equals(value)) {
//    		return SAFE;
//    	} else if ( "7".equals(value)) {
//    		return VERIFY;
//    	} else if ( "1_1".equals(value)) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return PERSON;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return SITE;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return EVENT;
//    	} else if ( "2".equals(value)) {
//    		return GOODS;
//    	} else if ( "2".equals(value)) {
//    		return GOODS;
//    	} else if ( "2".equals(value)) {
//    		return GOODS;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return EMERGENCY;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return SAFE;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} else if ( "2".equals(value)) {
//    		return VERIFY;
//    	} 
//    	return null;
//    }
}
