package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

/**
 *报告加急
 */
public enum ReportUrgent {
	
	ZERO {public String getValue(){return "0";} public String getName(){return "不需要加急";}}, 
	
	ONE{public String getValue(){return "1";} public String getName(){return "需要（1个工作日）";}},
	
    THREE{public String getValue(){return "3";} public String getName(){return "需要（3个工作日）";}},
    
    FIVE{public String getValue(){return "5";} public String getName(){return "需要（5个工作日）";}};


    public abstract String getValue();
    
    public abstract String getName();
    
    public static ReportUrgent convert_name(String name){
    	if ( "ZERO".equals(name) ) {
    		return ReportUrgent.ZERO;
    	} else if ("ONE".equals(name)) {
    		return ReportUrgent.ONE;
    	} else if ("THREE".equals(name)) {
    		return ReportUrgent.THREE;
    	} else if ("FIVE".equals(name)) {
    		return ReportUrgent.FIVE;
    	} 
    	return null;
    }
    
    public static ReportUrgent convert_value(String value){
    	if ( "0".equals(value) ) {
    		return ReportUrgent.ZERO;
    	} else if ("1".equals(value)) {
    		return ReportUrgent.ONE;
    	} else if ("2".equals(value)) {
    		return ReportUrgent.THREE;
    	} else if ("3".equals(value)) {
    		return ReportUrgent.FIVE;
    	} 
    	return null;
    }
    
    public static List<ReportUrgent> list(){
    	List<ReportUrgent> list = new ArrayList<ReportUrgent>();
    	list.add(ReportUrgent.ZERO);
      //	list.add(ReportUrgent.ONE); 	list.add(ReportUrgent.FIVE);
    	list.add(ReportUrgent.THREE);
    
    	return list;
    }
}
