package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum InvoiceType {

	ORDINARYINVOICE {
		public String getValue() {
			return "0";
		}

		public String getName() {
			return "增值税普通发票";
		}
	},
	VATINVOICE {
		public String getValue() {
			return "1";
		}

		public String getName() {
			return "增值税专用发票";
		}
	},
	NULLINVOICE {
		public String getValue() {
			return "2";
		}

		public String getName() {
			return "无发票";
		}
	};

	public abstract String getValue();

	public abstract String getName();

	public static List<InvoiceType> list() {
		List<InvoiceType> list = new ArrayList<InvoiceType>();
		list.add(ORDINARYINVOICE);
		list.add(VATINVOICE);
		// list.add(NULLINVOICE);
		return list;
	}

	public static InvoiceType convertValue(String value) {
		if ("0".equals(value)) {
			return InvoiceType.ORDINARYINVOICE;
		} else if ("1".equals(value)) {
			return InvoiceType.VATINVOICE;
		}
		return InvoiceType.ORDINARYINVOICE;

	}

}
