package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * 寄送模式
 * @author luopeng
 *
 */
public enum ExpressMode {
	
	NULL{public String getValue(){return "0";} public String getName(){return "无需寄送";}},
	
	REPORT{public String getValue(){return "1";} public String getName(){return "纸质报告";}},
	
	INVOICE_COMMON {public String getValue(){return "2";} public String getName(){return "普通发票";}},
	
	INVOICE_VAT {public String getValue(){return "3";} public String getName(){return "增值税发票";}},
	
	REPORT_INVOICE_COMMON {public String getValue(){return "4";} public String getName(){return "报告+普通发票";}},

	REPORT_INVOICE_VAT {public String getValue(){return "5";} public String getName(){return "报告+增值税发票";}};
	
    public abstract String getValue();
    
    public abstract String getName();


    public static boolean needReport(ExpressMode mode){
    	List<ExpressMode> list = new ArrayList<ExpressMode>();
    	list.add(REPORT);
    	list.add(REPORT_INVOICE_COMMON);
    	list.add(REPORT_INVOICE_VAT);
    	for (ExpressMode expressMode : list) {
    		if (mode.equals(expressMode)) {
    			return true;
    		}
		}
    	return false;
    }
    
    
    public static boolean needCoomonInvoice(ExpressMode mode){
    	List<ExpressMode> list = new ArrayList<ExpressMode>();
    	list.add(INVOICE_COMMON);
    	list.add(REPORT_INVOICE_COMMON);
    	for (ExpressMode expressMode : list) {
    		if (mode.equals(expressMode)) {
    			return true;
    		}
		}
    	return false;
    }
    
    
    public static boolean needVatInvoice(ExpressMode mode){
    	List<ExpressMode> list = new ArrayList<ExpressMode>();
    	list.add(INVOICE_VAT);
    	list.add(REPORT_INVOICE_VAT);
    	for (ExpressMode expressMode : list) {
    		if (mode.equals(expressMode)) {
    			return true;
    		}
		}
    	return false;
    }
    public static boolean needInvoice(ExpressMode mode){
    	List<ExpressMode> list = new ArrayList<ExpressMode>();
    	list.add(INVOICE_COMMON);
    	list.add(INVOICE_VAT);
    	list.add(REPORT_INVOICE_COMMON);
    	list.add(REPORT_INVOICE_VAT);
    	for (ExpressMode expressMode : list) {
    		if (mode.equals(expressMode)) {
    			return true;
    		}
		}
    	return false;
    }
    
    public static boolean needBoth(ExpressMode mode){
    	List<ExpressMode> list = new ArrayList<ExpressMode>();
    	list.add(REPORT_INVOICE_COMMON);
    	list.add(REPORT_INVOICE_VAT);
    	for (ExpressMode expressMode : list) {
    		if (mode.equals(expressMode)) {
    			return true;
    		}
		}
    	return false;
    }

	public static List<ExpressMode> list(){
		ArrayList<ExpressMode> list = new ArrayList<ExpressMode>();
		list.add(ExpressMode.NULL);
		list.add(ExpressMode.REPORT);
		list.add(ExpressMode.INVOICE_COMMON);
		list.add(ExpressMode.INVOICE_VAT);
		list.add(ExpressMode.REPORT_INVOICE_COMMON);
		list.add(ExpressMode.REPORT_INVOICE_VAT);

		return list;


	}

}
