package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum ActivityScale {
	
	/**少于1000人*/
	LESSTHOUSAND {public String getValue(){return "0";} public String getName(){return "少于1000人";}}, 
	/** 1000-5000人*/
	LESSFIVETHOUSAND{public String getValue(){return "1";} public String getName(){return "1000-5000人";}},
	/** 5000-10000*/
	LESSTENTHOUSAND{public String getValue(){return "2";} public String getName(){return "5000-10000人";}},
	/**10000以上*/
	MORETENTHOUSAND{public String getValue(){return "3";} public String getName(){return "10000人以上";}};


    public abstract String getValue();
    
    public abstract String getName();
    
    public static ActivityScale convert(String value){
    	if ( "LESSTHOUSAND".equals(value) ) {
    		return ActivityScale.LESSTHOUSAND;
    	} else if ("LESSFIVETHOUSAND".equals(value)) {
    		return ActivityScale.LESSFIVETHOUSAND;
    	} else if ("LESSTENTHOUSAND".equals(value)) {
    		return ActivityScale.LESSTENTHOUSAND;
    	} else if ("MORETENTHOUSAND".equals(value)) {
    		return ActivityScale.MORETENTHOUSAND;
    	} 
    	return ActivityScale.MORETENTHOUSAND;
    }
    
    public static List<ActivityScale> list(){
    	List<ActivityScale> list = new ArrayList<ActivityScale>();
    	list.add(ActivityScale.LESSFIVETHOUSAND);
      	list.add(ActivityScale.LESSTENTHOUSAND);
      	list.add(ActivityScale.MORETENTHOUSAND);
     
    	return list;
    }
}
