package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum ActivityCount {
	
	/** 从无*/
	ZERO {public String getValue(){return "0";} public String getName(){return "无经验";}}, 
	/** 1-3次*/
	FOUR{public String getValue(){return "1";} public String getName(){return "1-12次";}},
	/** 4-7次*/
    SEVEN{public String getValue(){return "2";} public String getName(){return "13-24次";}},
	/**8次以上*/
    OTHER{public String getValue(){return "3";} public String getName(){return "25次以上";}};


    public abstract String getValue();
    
    public abstract String getName();
    
    public static ActivityCount convert(String value){
    	if ( "ZERO".equals(value) ) {
    		return ActivityCount.ZERO;
    	} else if ("FOUR".equals(value)) {
    		return ActivityCount.FOUR;
    	} else if ("SEVEN".equals(value)) {
    		return ActivityCount.SEVEN;
    	} else if ("OTHER".equals(value)) {
    		return ActivityCount.OTHER;
    	} 
    	return ActivityCount.OTHER;
    }
    
    public static List<ActivityCount> list(){
    	List<ActivityCount> list = new ArrayList<ActivityCount>();
    	list.add(ActivityCount.ZERO);
      	list.add(ActivityCount.FOUR);
      	list.add(ActivityCount.SEVEN);
       	list.add(ActivityCount.OTHER);
    	return list;
    }
}
