package com.bcxin.risk.policy.enums;

/**
 * @author LeeJungHyun
 **/
public enum RelatedToRoleCode {

	// 配偶
	SPOUSE(1, "配偶"),

	// 子女
	CHILD(2, "子女"),

	// 父母
	PARENT(3, "父母"),

	// 亲属
	FAMILY(4, "亲属"),

	// 本人
	SELF(5, "本人"),

	// 其他
	OTHER(6, "其他"),

	// 雇佣关系
	GUYONG(7, "雇佣关系");

	private RelatedToRoleCode(int code, String description) {
		this.code = code;
		this.description = description;
	}

	private int code;
	private String description;

	public Integer code() {
		return code;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public static RelatedToRoleCode convert(String value){
    	if ( "SPOUSE".equals(value) ) {
    		return RelatedToRoleCode.SPOUSE;
    	} else if ("CHILD".equals(value)) {
    		return RelatedToRoleCode.CHILD;
    	} else if ("PARENT".equals(value)) {
    		return RelatedToRoleCode.PARENT;
    	} else if ("FAMILY".equals(value)) {
    		return RelatedToRoleCode.FAMILY;
    	} else if ("SELF".equals(value)) {
    		return RelatedToRoleCode.SELF;
    	} else if ("GUYONG".equals(value)) {
    		return RelatedToRoleCode.GUYONG;
    	}
    	return RelatedToRoleCode.OTHER;
    }

	/**
	  * 保众网类型转换
	  * @param relation
	  * @return
	  */
	 public static String convert_bzw(RelatedToRoleCode relation){
		String return_code = "";
		switch (relation) {
		case SELF:
			return_code = "00";
			break;
		case SPOUSE:
			return_code = "01";
			break;
		case PARENT:
			return_code = "02";
			break;	
		case CHILD:
			return_code = "07";
			break;
		case FAMILY:
			return_code = "27";
			break;
		case OTHER:
			return_code = "99";
			break;
		default:
			break;
		}
		 return return_code;
	 }
}
