package com.bcxin.risk.policy.domain;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.risk.policy.enums.ClauseStatus;
import com.fasterxml.jackson.annotation.JsonBackReference;

/**
 * 产品条款，pdf附件上传
 * @author luopeng
 *
 */
@Entity
@Table(name = "risk_PRODUCTLITERATURE")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ProductLiterature extends BaseBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String docPath;
	
	private String fileNames;
	
	@Enumerated(EnumType.STRING)
	private ClauseStatus status;
	
	@ManyToOne(targetEntity = InsuranceProduct.class)
	@JoinColumn(name = "insuranceProduct_id")
	@JsonBackReference
	private InsuranceProduct insuranceProduct;


}
