package com.bcxin.risk.policy.domain;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.policy.enums.*;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;


/**
 * 保费计算
 * @author luopeng
 *
 */
public class PremiumCalc{
	

	
	
	//---太保---
	private BigDecimal standard = new BigDecimal("2000");//标准款
	Map<Policy_ActivityQuota,String> cpic_quotaMap = new HashMap<Policy_ActivityQuota,String>();
	Map<Policy_ActivityType,String> cpic_typeMap = new HashMap<Policy_ActivityType,String>();
	Map<Policy_ActivityScale,String> cpic_scaleMap = new HashMap<Policy_ActivityScale,String>();
	Map<Policy_ActivityPeriod,String> cpic_periodMap = new HashMap<Policy_ActivityPeriod,String>();
	Map<Policy_ActivityFireFight,String> cpic_fireMap = new HashMap<Policy_ActivityFireFight,String>();
	Map<Policy_ActivityLocal,String> cpic_localMap = new HashMap<Policy_ActivityLocal,String>();
	Map<Whether,String> cpic_guestMap = new HashMap<Whether,String>();
	Map<Whether,String> cpic_dangerMap = new HashMap<Whether,String>();
	
	//---华泰---
	private BigDecimal even = new BigDecimal("250");//标准款
	Map<Policy_ActivityType,String> ht_typeMap = new HashMap<Policy_ActivityType,String>();
	Map<Policy_ActivityQuota,String> ht_quotaMap = new HashMap<Policy_ActivityQuota,String>();
	Map<Policy_ActivityLocal,String> ht_localMap = new HashMap<Policy_ActivityLocal,String>();
	Map<Policy_ActivityFireFight,String> ht_fireMap = new HashMap<Policy_ActivityFireFight,String>();
	Map<Policy_ActivityScale,String> ht_scaleMap = new HashMap<Policy_ActivityScale,String>();
	Map<Whether,String> ht_dangerMap = new HashMap<Whether,String>();
	
	
	private void load_cpic_data(){
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_ONE, "1.1");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_TWO, "1.2");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_THREE, "1.3");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_FOUR, "1.4");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_FIVE, "1.5");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_SIX, "1.6");
		
		cpic_typeMap.put(Policy_ActivityType.EXHIBITION, "1");
		cpic_typeMap.put(Policy_ActivityType.LITERATURE, "1.2");
		cpic_typeMap.put(Policy_ActivityType.SPORTS, "1.3");
		cpic_typeMap.put(Policy_ActivityType.GARDENLANTERN, "1.4");
		cpic_typeMap.put(Policy_ActivityType.OTHER, "1.2");
		
		cpic_scaleMap.put(Policy_ActivityScale.CPIC_BELOW, "1");
		cpic_scaleMap.put(Policy_ActivityScale.CPIC_MIDDLE, "1.2");
		cpic_scaleMap.put(Policy_ActivityScale.CPIC_UP, "1.4");
		
		cpic_periodMap.put(Policy_ActivityPeriod.BELOW, "1");
		cpic_periodMap.put(Policy_ActivityPeriod.MIDDLE, "1.2");
		cpic_periodMap.put(Policy_ActivityPeriod.UP, "1.3");
		
		cpic_fireMap.put(Policy_ActivityFireFight.ACCEPTANCE, "1");
		cpic_fireMap.put(Policy_ActivityFireFight.EXTINGUISHER, "1.1");
		cpic_fireMap.put(Policy_ActivityFireFight.NO_EXTINGUISHER, "1.3");
		
		cpic_localMap.put(Policy_ActivityLocal.INDOOR, "1");
		cpic_localMap.put(Policy_ActivityLocal.OPEN, "1.1");
		cpic_localMap.put(Policy_ActivityLocal.OUTDOOR, "1.2");
		
		cpic_guestMap.put(Whether.HAVE, "1");
		cpic_guestMap.put(Whether.WITHOUT, "1.1");
		
		cpic_dangerMap.put(Whether.HAVE, "1");
		cpic_dangerMap.put(Whether.WITHOUT, "1.2");
	}
	
	private void load_ht_data(){
		//基本保费
		ht_typeMap.put(Policy_ActivityType.EXHIBITION, "2000");
		ht_typeMap.put(Policy_ActivityType.LITERATURE, "2500");
		ht_typeMap.put(Policy_ActivityType.SPORTS, "3500");
		ht_typeMap.put(Policy_ActivityType.GARDENLANTERN, "4000");
		ht_typeMap.put(Policy_ActivityType.OTHER, "4000");
		//保险累计赔偿限额
		ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_ONE, "1.1");
		ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_TWO, "1.4");
		ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_THREE, "1.5");
		ht_quotaMap.put(Policy_ActivityQuota.HT_LEVEL_FOUR, "1.6");
		//活动地点
		ht_localMap.put(Policy_ActivityLocal.INDOOR, "1");
		ht_localMap.put(Policy_ActivityLocal.OPEN, "1.1");
		ht_localMap.put(Policy_ActivityLocal.OUTDOOR, "1.2");
		//消防情况
		ht_fireMap.put(Policy_ActivityFireFight.ACCEPTANCE, "1");
		ht_fireMap.put(Policy_ActivityFireFight.EXTINGUISHER, "1.1");
		//活动人数
		ht_scaleMap.put(Policy_ActivityScale.HT_BELOW, "1");
		ht_scaleMap.put(Policy_ActivityScale.HT_MIDDLE, "1.2");
		ht_scaleMap.put(Policy_ActivityScale.HT_SE_MIDDLE, "1.5");
		ht_scaleMap.put(Policy_ActivityScale.HT_UP, "2");
		//有无危险环节（如烟花）
		ht_dangerMap.put(Whether.WITHOUT, "1");
		ht_dangerMap.put(Whether.HAVE, "1.3");
	}
	
	public BigDecimal calc(InsuranceProduct product,PolicyExtra extra) {
		
		if (product.getInsuranceCompany().equals(InsuranceCompany.CPIC_PROPERTY)) { //太保
			load_cpic_data();
			BigDecimal premium = standard;
			
			String quota = cpic_quotaMap.get(extra.getActivityQuota());//限额
			String type = cpic_typeMap.get(extra.getActivityType());//类型
			String scale = cpic_scaleMap.get(extra.getActivityScale());//规模
			String period = cpic_periodMap.get(extra.getActivityPeriod());
			String fire = cpic_fireMap.get(extra.getActivityFireFight());//有无危险
			String local = cpic_localMap.get(extra.getActivityLocal());//活动地点
			String guest = cpic_guestMap.get(extra.getGuest());//来宾
			String danger = cpic_dangerMap.get(extra.getDanger());//有无危险
			
			if ( StringUtil.isEmpty(quota) ) {
				quota = "1.1";
			}
			if ( StringUtil.isEmpty(type) ) {
				type = "1";
			}
			if ( StringUtil.isEmpty(scale) ) {
				scale = "1";
			}
			if (  StringUtil.isEmpty(period)) {
				period = "1";
			}
			if ( StringUtil.isEmpty(fire) ) {
				fire = "1";
			}
			if (  StringUtil.isEmpty(local)  ) {
				local = "1";
			}
			if ( StringUtil.isEmpty(guest)  ) {
				guest  = "1";
			}
			if ( StringUtil.isEmpty(danger) ) {
				danger = "1";
			}
			premium = premium.multiply(new BigDecimal(quota)).multiply(new BigDecimal(type))
					.multiply(new BigDecimal(scale)).multiply(new BigDecimal(period))
					.multiply(new BigDecimal(fire)).multiply(new BigDecimal(local))
					.multiply(new BigDecimal(guest)).multiply(new BigDecimal(danger));
			
			return premium.setScale(2,BigDecimal.ROUND_HALF_UP);
			
		} else if ( product.getInsuranceCompany().equals(InsuranceCompany.HT) ) { //华泰
			load_ht_data();
			BigDecimal premium = even;
			Policy_ActivityQuota	 xiane=extra.getActivityQuota();
			if(extra.getAmount()!=null&&!"".equals(extra.getAmount())){//组装限额系数
				xiane=Policy_ActivityQuota.getLevel(extra.getAmount());
			}
			String quota = ht_quotaMap.get(xiane);//限额
			String type = ht_typeMap.get(extra.getActivityType());//类型
			String scale = ht_scaleMap.get(extra.getActivityScale());//规模
			String fire = ht_fireMap.get(extra.getActivityFireFight());//
			String local = ht_localMap.get(extra.getActivityLocal());//室内
			String danger = ht_dangerMap.get(extra.getDanger());//有无危险
			String days = extra.getInsureDays();
			
			if ( StringUtil.isEmpty(quota) ) {
				quota = "1";
			}
			if ( StringUtil.isEmpty(type) ) {
				type = "2000";
			}
			if ( StringUtil.isEmpty(scale) ) {
				scale = "1";
			}
			if ( StringUtil.isEmpty(fire) ) {
				fire = "1";
			}
			if (  StringUtil.isEmpty(local)  ) {
				local = "1";
			}
			if ( StringUtil.isEmpty(danger) ) {
				danger = "1";
			}
			if ( StringUtil.isEmpty(days)){
				days = "1";
			}
			BigDecimal dayprice = premium.multiply(new BigDecimal(days));
			premium = new BigDecimal(quota).multiply(new BigDecimal(type))
					.multiply(new BigDecimal(scale)).multiply(new BigDecimal(danger))
					.multiply(new BigDecimal(fire)).multiply(new BigDecimal(local));
			
			premium = premium.add(dayprice);
			return premium.setScale(2,BigDecimal.ROUND_HALF_UP);
		}
		
		return BigDecimal.ZERO;
	}

}
