package com.bcxin.risk.org.domain;

import javax.persistence.*;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.risk.report.enums.ApprovalStatus;

/**
 * 待审核的政府机构
 * @author llc
 *
 */
@Entity
@Table(name = "risk_govOrg")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class GovOrg extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	private String userName;//登陆用户名，与user对应

	private String name; // 单位名称

	private String address; // 单位地址
	
	private String govOrgFlag; // 政府单位标志
	
	private String organizationCode; // 组织机构代码
	
	private String organizationCode_license; // 组织机构代码扫描件

	private String approvalStatus ;//审核状态，（字典）

	private String comment;//审核备注

	@OneToOne(targetEntity = User.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "user_id")
	private User user; //用户

	private Long area_id;  // 区域ID

	private Long city_id;  // 城市ID

	private Long province_id;  // 省份ID

}
