package com.bcxin.risk.enums;

/**
 * @author hzp
 * 动态看板类型
 */
public enum DynamicPermissionEnum {

    DYNAMIC_CONTRACTOR("CONTRACTOR","承办方"),
    DYNAMIC_FENGPING("FENGPING","评估公司"),
    DYNAMIC_ALL("ALL","所有");

    private String key;
    private String alias;

    DynamicPermissionEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(DynamicPermissionEnum e : DynamicPermissionEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
