package com.bcxin.risk.compose.dto.data;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class ComposeFrameDataDto {

    private String oid;

    /**
     * 模版名称
     */
    private String name;

    /**
     * 模版类型
     * 字典：COMPOSEFRAMETYPE
     */
    private String type;

    /**
     * 备注
     */
    private String comment;

    /**
     * 来源 （0代表贡献，1代表私有）
     */
    private String nature;

    /**
     * 模板文件
     */
    private String fileUrl;

    /**
     * 所属风评机构（如果为空，则代表默认模板）
     */
    private Long org_id;

    /**
     * 激活状态
     */
    private String active;

    private String createOn;

    private Page page;



    public ComposeFrameDataDto(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.name = safeTransfor(map.get("name"));
        this.active = safeTransfor(map.get("active"));
        this.createOn = safeTransfor(map.get("createOn"));
        this.type = safeTransfor(map.get("type"));
        this.comment = safeTransfor(map.get("comment"));
        this.nature = safeTransfor(map.get("nature"));
        this.fileUrl = safeTransfor(map.get("fileUrl"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }


}
