package com.bcxin.risk.compose.draft;

import com.bcxin.risk.survey.domain.Task;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 撰写任务
 * @author luopeng
 *
 */

@Entity
@Table(name = "RISK_ComposeTask")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeTask extends Task{

	private static final long serialVersionUID = 1L;

	private String description;

	/**
	 * 专家审核意见
	 */
	private String comment;

	private Integer seq;

	/**
	 * 签名状态
	 */
	private String signStatus;

}
