package com.bcxin.risk.compose.draft;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 撰写生成的评估报告，每个阶段均保存一份
 */
@Entity
@Table(name = "RISK_ComposeFile")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ComposeFile extends BaseBean {

	private static final long serialVersionUID = -6403313540738849131L;

	/**
	 * 阶段 （字典表） COMPOSEFILELEVEL
	 */
	private String level;

	/**
	 * 所属任务
	 */
	@ManyToOne(targetEntity = ComposeTask.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "composeTask_id")
	private ComposeTask composeTask;

	@Column(name="composeTask_id", updatable=false, insertable=false)
	private Long composeTaskId;//用户id
	/**
	 * 报告文件
	 */
	private String fileUrl;

	/**
	 * 是否通过pageoffice保存过
	 */
	private String saved;

	/**
	 * 所属报告
	 */
	private Long report_id;

	/**
	 * 总页数
	 */
	private Integer pages;

	/**
	 * 提交后即冻结，不能再编辑和保存文件。
	 * 与saved 的区别是，freeze代表编辑完成（当前步骤已定稿，不可修改），saved代表编辑过。
	 *
	 * */
	private String freeze;

}
