package com.bcxin.risk.common.dto.data;


import lombok.Data;

import java.util.Map;

/**
 * 通用返回值DTO
 * @author 罗鹏
 */
@Data
public class ValueDTO {

    private String oid;

    private String name;

    public ValueDTO(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.name = safeTransfor(map.get("name"));
    }

    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}

