package com.bcxin.risk.base.domain.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DomainDateUtil {
	public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
	public static final String FORMAT2 = "yyyy-MM-dd";
	public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
	public static final String FORMAT4 = "MM/dd/yyyy";
	public static final String FORMAT5 = "HH:mm:ss";
	public static final String FORMAT6 = "yyyy/MM/dd";
	public static final String FORMAT7 = "yyyy-MM-dd HH:mm";
	public static final String FORMAT8 ="yyyyMMddhhmmss";

	public static SimpleDateFormat chinaDate = new SimpleDateFormat("yyyy年MM月dd日");

	public static SimpleDateFormat chinaTime = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分");


	/**
	 * 年
	 */
	public static final int DATATYPE_YEAR = 1;

	/**
	 * 月
	 */
	public static final int DATATYPE_MONTH = 2;

	/**
	 * 日
	 */
	public static final int DATATYPE_DAY = 3;

	/**
	 * 小时
	 */
	public static final int DATATYPE_HOUR = 4;

	/**
	 * 分钟
	 */
	public static final int DATATYPE_MINUTE = 5;

	/**
	 * 秒
	 */
	public static final int DATATYPE_SECOND = 6;

	private DomainDateUtil() {
	}

	/**
	 * 根据string日期获取其格式
	 * 
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static String getFormat(String date) throws Exception {
		String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2}";
		String reg3 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4}";
		String reg5 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
		if (date.matches(reg1)) {
			return FORMAT1;
		} else if (date.matches(reg2)) {
			return FORMAT2;
		} else if (date.matches(reg3)) {
			return FORMAT3;
		} else if (date.matches(reg4)) {
			return FORMAT4;
		} else if (date.matches(reg5)) {
			return FORMAT7;
		} else {
			throw new Exception("不支持的日期格式：" + date);
		}
	}

	/**
	 * 获取当前日期
	 * 
	 * @return
	 */
	public static String getCurrentDate() {
		return getCurrentDateTime(FORMAT2);
	}

	/**
	 * 获取当前日期yyyymmddhhmmss
	 * 
	 * @return
	 */
	public static String getTimestamp() {
		return getCurrentDateTime(FORMAT8);
	}

	/**
	 * 获取当前日期
	 * 
	 * @return
	 */
	public static String getCurrentDate(String format) {
		return getCurrentDateTime(format);
	}

	/**
	 * 获取当前时间
	 * 
	 * @return 时分秒
	 */
	public static String getCurrentTime() {
		return getCurrentDateTime(FORMAT5);
	}

	/**
	 * 获取当前日期时间
	 * 
	 * @return
	 */
	public static String getCurrentDateTime() {
		return getCurrentDateTime(FORMAT1);
	}

	/**
	 * 根据特定格式获取当前时间
	 * 
	 * @param format
	 * @return
	 */
	public static String getCurrentDateTime(String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(new Date());
	}

	/**
	 * 获取昨天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getYesterday() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, -1);
		return df.format(c.getTime());
	}

	/**
	 * 获取明天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getTomorrow() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, 1);
		return df.format(c.getTime());
	}

	public static Date addDay(Date date, int day) {
		Calendar gc = prepare(date);
		gc.add(Calendar.DAY_OF_MONTH, day);
		return gc.getTime();
	}


	private static Calendar prepare(Date date) {
		Calendar gc = Calendar.getInstance();
		gc.setTime(date);
		return gc;
	}


	public static Date parseDate(String value) {
		Date date = java.sql.Date.valueOf(value);
		return date;
	}

}
