/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.survey.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;

@Entity
@Table(name="risk_surveySign")
@Inheritance(strategy=InheritanceType.JOINED)
public class SurveySign
extends BaseBean {
    private static final long serialVersionUID = 1L;
    @ManyToOne(targetEntity=User.class, fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="userId")
    private User user;
    public double latitude;
    public double longitude;
    public String planId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date signDate;

    @Generated
    public SurveySign() {
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public double getLatitude() {
        return this.latitude;
    }

    @Generated
    public double getLongitude() {
        return this.longitude;
    }

    @Generated
    public String getPlanId() {
        return this.planId;
    }

    @Generated
    public Date getSignDate() {
        return this.signDate;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @Generated
    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SurveySign)) {
            return false;
        }
        SurveySign other = (SurveySign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$planId = this.getPlanId();
        String other$planId = other.getPlanId();
        if (this$planId == null ? other$planId != null : !this$planId.equals(other$planId)) {
            return false;
        }
        Date this$signDate = this.getSignDate();
        Date other$signDate = other.getSignDate();
        return !(this$signDate == null ? other$signDate != null : !((Object)this$signDate).equals(other$signDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SurveySign;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $planId = this.getPlanId();
        result = result * 59 + ($planId == null ? 43 : $planId.hashCode());
        Date $signDate = this.getSignDate();
        result = result * 59 + ($signDate == null ? 43 : ((Object)$signDate).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SurveySign(user=" + this.getUser() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", planId=" + this.getPlanId() + ", signDate=" + this.getSignDate() + ")";
    }
}

