package com.bcxin.oa.old.service.web;

import com.bcxin.oa.old.dto.count.AppPerTaskCountDTO;
import com.bcxin.oa.old.dto.count.CountPerTaskDTO;
import com.bcxin.oa.old.dto.count.PerTaskDateDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

import javax.servlet.http.HttpServletResponse;

/**
 * 人员外勤日统计
 *
 * @author llc
 * @date 2019-01-14
 */
public interface CountPerTaskDateService {

    /**
     * 定时器生成外勤报表
     * @author llc
     * @date 2019-01-14
     * @param
     * @return
     */
    Result createTaskCountReport() throws BusinessException;

    /**
     * 获取人员外勤日统计情况
     * @author llc
     * @date 2019-01-14
     * @param dto
     * @return
     */
    Result getPerTaskDateCountList(CountPerTaskDTO dto) throws BusinessException;


    /**
     * 获取人员外勤月统计情况
     * @author llc
     * @date 2019-01-14
     * @param dto
     * @return
     */
    Result getPerTaskMonthCountList(CountPerTaskDTO dto)throws BusinessException;


    /**
     * 人员外勤月统计导出
     * @author llc
     * @date 2019-01-14
     * @param dto
     * @return
     */
    Result exportCountPerTaskMonth(CountPerTaskDTO dto, HttpServletResponse response)throws BusinessException;


    /**
     * 查询人员某日打卡详情
     * @author llc
     * @date 2019-01-14
     * @param dto
     * @return
     */
    Result getTaskRecodeList(PerTaskDateDTO dto)throws BusinessException;


    /**
     * 修改人员打卡记录
     * @author llc
     * @date 2019-01-14
     * @param dto
     * @return
     */
    Result updateTaskRecord(PerTaskDateDTO dto)throws BusinessException;


    /**
     * app外勤统计
     * @author llc
     * @date 2019-01-24
     * @param dto
     * @return
     */
    Result outStatisTics(AppPerTaskCountDTO dto)throws BusinessException;


}