package com.bcxin.oa.old.service.web;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReflectUtil;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.attend.CountPerAttendDateMapper;
import com.bcxin.oa.old.entity.count.CountPerAttendDate;
import com.bcxin.oa.old.dto.CountPerAttendDTO;
import com.bcxin.oa.old.dto.ExportPerAttendMonthDTO;
import com.bcxin.oa.old.dto.PerAttendDateDTO;
import com.bcxin.oa.old.dto.PerAttendTimeDTO;
import com.bcxin.oa.old.dto.count.AppPerAttendCountDTO;
import com.bcxin.oa.old.dto.count.AppPerAttendCountResultDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.utils.ExcelUtil;
import com.github.pagehelper.PageHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

/**
 * 人员考勤日统计
 *
 * @author llc
 * @date 2018-12-03
 */
@Service
@Transactional
public class CountPerAttendDateServiceImpl implements CountPerAttendDateService {

    @Resource
    private CountPerAttendDateMapper countPerAttendDateMapper;

    @Resource
    private IdWorker idWorker;
    /**
     * 定时器生成考勤报表
     *
     * @param
     * @return
     * @author llc
     * @date 2018-12-17
     */
    @Override
    public Result createAttendCountReport() throws BusinessException {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("prm_date", DateUtils.formatDate(DateUtil.yesterday()));

        /** 调用生成考勤统计数据存储过程，处理业务逻辑 ***/
        countPerAttendDateMapper.prc_createAttendCountReport(paramMap);

        String prm_success = paramMap.get("prm_success").toString();

        if (prm_success.equalsIgnoreCase(CommonConst.N)) {
            throw new BusinessException(Result.ERROR, "生成考勤统计数据失败");
        }
        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    /**
     * 获取人员考勤日统计情况
     *
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-03
     */

    @Override
    public Result getPerAttendDateCountList(CountPerAttendDTO dto) throws BusinessException {
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<Map<String, Object>> list = countPerAttendDateMapper.getPerAttendDateCountList(dto);
        PageInfoUtils pageInfo = new PageInfoUtils(list);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 获取人员考勤月统计情况
     *
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-04
     */
    @Override
    public Result getPerAttendMonthCountList(CountPerAttendDTO dto) throws BusinessException {
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<ExportPerAttendMonthDTO> list = countPerAttendDateMapper.getPerAttendMonthCountList(dto);
        PageInfoUtils pageInfo = new PageInfoUtils(list);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 人员考勤月统计导出
     *
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-04
     */
    @Override
    public Result exportCountPerAttendMonth(CountPerAttendDTO dto, HttpServletResponse response)
            throws BusinessException {
        if (StringUtils.isEmpty(dto.getMonth())) {
            throw new BusinessException(Result.ERROR, "月份不能为空");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "_" + dto.getMonth() + "考勤报表" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("考勤统计");

            List<ExportPerAttendMonthDTO> list = countPerAttendDateMapper.getPerAttendMonthCountList(dto);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);// 水平居中
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /*** 合并单元格 ***/

            for (int i = 0; i <= 14; i++) {
                sheet1.addMergedRegion(new CellRangeAddress(0, (short) 1, i, i));
            }
            sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 15, 17));
            sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 18, 25));

            /*** 填充第一行数据 ***/
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = {"序号", "姓名", "手机号码", "部门", "统计时段", "出勤天数", "休息天数", "工作总时长", "迟到次数", "迟到总分钟", "早退次数",
                    "早退总分钟", "漏卡次数", "缺勤天数", "缺勤时长", "工作日加班", "休息日加班", "节假日加班", "事假", "病假", "年假", "婚假", "调休", "产假",
                    "公假", "主管假"};
            int column;
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 2 || (i >= 5 && i <= 17)) {
                    column = 4000;
                } else if (i == 3 || i == 4) {
                    column = 6000;
                } else {
                    column = 2000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            String[] arr = {"序号", "姓名", "手机号码", "部门", "统计时段", "出勤天数", "休息天数", "工作总时长", "迟到次数", "迟到总分钟", "早退次数",
                    "早退总分钟", "漏卡次数", "缺勤天数", "缺勤时长", "加班时长"};

            for (int i = 0; i < arr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
                cell.setCellValue(arr[i]);
                cell.setCellStyle(titleStyle);
            }
            HSSFCell cell17 = rowFirst.createCell(18);
            cell17.setCellValue("请假时长");
            cell17.setCellStyle(titleStyle);

            /*** 填充第一行数据 ***/
            ;
            HSSFRow rowSecond = sheet1.createRow(1);
            String[] secondArr = {"工作日加班", "休息日加班", "节假日加班", "事假", "病假", "年假", "婚假", "调休", "产假", "公假", "主管假"};
            for (int i = 0; i < secondArr.length; i++) {
                HSSFCell cell = rowSecond.createCell(i + 15); // 获取第二行的每个单元格
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            rowFirst.setHeight((short) 500);
            /*** 写第一行 ***/

            /**** 填充数据 ***/

            /*** 字体橙色样式 ***/
            CellStyle orangeStyle = ExcelUtil.getOrangeStyle(wb);
            HSSFRow row = null;
            int rowIndex = 2;
            for (ExportPerAttendMonthDTO result : list) {
                row = sheet1.createRow(rowIndex);
                Field[] fields = result.getClass().getDeclaredFields(); // 反射获取值
                int cellIndex = 0;
                for (Field f : fields) {
                    f.setAccessible(true); // 可以访问private对象不抛异常
                    String filedCode = f.getName();
                    Object value = ReflectUtil.getFieldValue(result, filedCode);
                    HSSFCell cell = row.createCell(cellIndex);
                    cell.setCellValue(value != null ? value.toString() : null);
                    if (filedCode.equalsIgnoreCase("lateTimes") || filedCode.equalsIgnoreCase("totalLateTime")
                            || filedCode.equalsIgnoreCase("leaveEarlyTimes")
                            || filedCode.equalsIgnoreCase("totalLeaveEarlyTime")
                            || filedCode.equalsIgnoreCase("missCardTimes")
                            || filedCode.equalsIgnoreCase("absenteeismDays")) {
                        if (!value.toString().equalsIgnoreCase("0")) {
                            cell.setCellStyle(orangeStyle);
                        }
                    }
                    if (filedCode.equalsIgnoreCase("absenceTime")) {
                        if (!value.toString().equalsIgnoreCase("0.00")) {
                            cell.setCellStyle(orangeStyle);
                        }
                    }
                    cellIndex++;
                }
                rowIndex++;
            }
            wb.write(os);
            os.close();
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, e.getMessage());
        } finally {
            try {
                os.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出考勤统计报表失败");
    }

    /**
     * 查询人员某日打卡详情
     *
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-06
     */
    @Override
    public Result getAttendRecodeList(PerAttendDateDTO dto) throws BusinessException {
        Map<String, String> map = countPerAttendDateMapper.getPerBaseInfo(dto.getPerId());
        List<Map<String, Object>> list = countPerAttendDateMapper.getAttendRecodeList(dto);
        Map<String, Object> result = new HashMap();
        result.put("photoUrl", map.get("photoUrl"));
        result.put("list", list);
        return Result.success(Result.SUCCESS_QUERY_MSG, result);
    }

    /**
     * 修改人员打卡记录
     *
     * @param dto
     * @return
     * @author llc
     * @date 2018-12-06
     */
    @Override
    public Result updateAttendRecord(PerAttendDateDTO dto) throws BusinessException {

        if (!dto.getAttendStatus().equals(DictConst.ATTENDSTATUS_ZC)
                && !dto.getAttendStatus().equals(DictConst.ATTENDSTATUS_CD)
                && !dto.getAttendStatus().equals(DictConst.ATTENDSTATUS_ZT)) {
            throw new BusinessException(Result.BUSINESS_ERROR, "考勤状态错误！");
        }

        /*** 这里分开写是为了以后分服务 ***/
        Map<String, String> map = countPerAttendDateMapper.getPerBaseInfo(dto.getCreateBy());
        String remark = map.get("name") + "改为";
        if (dto.getAttendStatus().equals(DictConst.ATTENDSTATUS_ZC)) {
            dto.setMinute(0);
            remark = remark + "正常";
        } else if (dto.getAttendStatus().equals(DictConst.ATTENDSTATUS_ZT)) {
            remark = remark + "早退" + dto.getMinute() + "分钟";
            dto.setMinute(0 - dto.getMinute());
        } else {
            remark = remark + "迟到" + dto.getMinute() + "分钟";
        }
        dto.setRemark(remark);
        /***
         * 1.打卡记录ID为-1则代表是漏卡进来，需要插入 2.如果存在打卡记录则更新
         ***/
        if (dto.getAttendCardRecordId() == -1L) {
            dto.setAttendCardRecordId(idWorker.nextId());
            countPerAttendDateMapper.insertPerAttendRecord(dto);
        } else {
            countPerAttendDateMapper.updatePerAttendRecord(dto);
        }

        /***
         * 1.修改第1-5轮的上下班状态 2.判断出勤天数 3.修改总时长、迟到次数、迟到总分钟、早退次数、早退总分钟、漏卡次数、缺勤天数、缺勤时长
         * 不管怎么修改，都重新计算
         ***/
        CountPerAttendDate countPerAttendDate = new CountPerAttendDate();
        List<PerAttendDateDTO> list = countPerAttendDateMapper.getAttendRecodeAgain(dto);

        for (PerAttendDateDTO perAttendDateDTO : list) {
            if (perAttendDateDTO.getAttendStatus().equals(DictConst.ATTENDSTATUS_CD)) { // 迟到
                countPerAttendDate.setLateTimes(countPerAttendDate.getLateTimes() + 1); // 迟到次数加1
                long lateTime = DateUtil.between(perAttendDateDTO.getAttendTime(), perAttendDateDTO.getClockInTime(),
                        DateUnit.MINUTE);
                countPerAttendDate.setTotalLateTime(countPerAttendDate.getTotalLateTime() + (int) lateTime); // 迟到时长
            }
            if (perAttendDateDTO.getAttendStatus().equals(DictConst.ATTENDSTATUS_ZT)) { // 早退
                countPerAttendDate.setLeaveEarlyTimes(countPerAttendDate.getLeaveEarlyTimes() + 1); // 早退次数加1
                long leaveEarlyTime = DateUtil.between(perAttendDateDTO.getClockInTime(),
                        perAttendDateDTO.getAttendTime(), DateUnit.MINUTE);
                countPerAttendDate
                        .setTotalLeaveEarlyTime(countPerAttendDate.getTotalLeaveEarlyTime() + (int) leaveEarlyTime); // 早退时长
            }
            if (perAttendDateDTO.getAttendStatus().equals(DictConst.ATTENDSTATUS_QK)) { // 缺卡
                countPerAttendDate.setMissCardTimes(countPerAttendDate.getMissCardTimes() + 1); // 缺卡次数加1
            }
        }

        String attendTime = "";
        for (PerAttendDateDTO perAttendDateDTO : list) {
            if (perAttendDateDTO.getCommutRound() == dto.getCommutRound()
                    && perAttendDateDTO.getClockInType().equals(dto.getClockInType())) {
                if (perAttendDateDTO.getClockInTime() != null) {
                    /*** 校验打卡日期和打卡时间是否为同一天 **/
                    if (DateUtils.formatDate(perAttendDateDTO.getClockInTime(), "yyyy-MM-dd")
                            .equals(dto.getAttendDate())) {
                        attendTime = DateUtils.formatDate(perAttendDateDTO.getClockInTime(), "HH:mm");
                    } else {
                        attendTime = "次日" + DateUtils.formatDate(perAttendDateDTO.getClockInTime(), "HH:mm");
                    }
                }
                break;
            }
        }

        /*** 更新轮次上下班结果 ***/
        // 11:50($早退$)
        remark = attendTime + "($" + remark + "$)";

        switch (dto.getCommutRound()) {
            case 1:
                if (dto.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                    countPerAttendDate.setFirstRoundOnWork(remark);
                } else {
                    countPerAttendDate.setFirstRoundOffWork(remark);
                }
                break;
            case 2:
                if (dto.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                    countPerAttendDate.setSecondRoundOnWork(remark);
                } else {
                    countPerAttendDate.setSecondRoundOffWork(remark);
                }
                break;
            case 3:
                if (dto.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                    countPerAttendDate.setThirdRoundOnWork(remark);
                } else {
                    countPerAttendDate.setThirdRoundOffWork(remark);
                }
                break;
            case 4:
                if (dto.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                    countPerAttendDate.setFourthRoundOnWork(remark);
                } else {
                    countPerAttendDate.setFourthRoundOffWork(remark);
                }
                break;
            case 5:
                if (dto.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                    countPerAttendDate.setFifthRoundOnWork(remark);
                } else {
                    countPerAttendDate.setFifthRoundOffWork(remark);
                }
                break;
            default:
                break;
        }

        /*** 计算是否出勤、缺勤时长、工作总时长 ***/

        countPerAttendDate.setIsAbsenteeism(CommonConst.Y);
        for (PerAttendDateDTO perAttendDateDTO : list) {
            if (!perAttendDateDTO.getAttendStatus().equals(DictConst.ATTENDSTATUS_QK)) { // 不等于缺卡
                countPerAttendDate.setIsAbsenteeism(CommonConst.N);
                countPerAttendDate.setAbsenceTime(BigDecimal.ZERO);
                break;
            }
        }

        if (countPerAttendDate.getIsAbsenteeism().equals(CommonConst.Y)) { // 如果缺勤(工作总时长为0)
            countPerAttendDate.setWorkHours(BigDecimal.ZERO);
            /*** 计算缺勤时长 ***/
            List<PerAttendTimeDTO> perAttendTimeList = new ArrayList<>();
            for (PerAttendDateDTO perAttendDateDTO : list) {
                if (perAttendDateDTO.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                    PerAttendTimeDTO perAttendTimeDTO = new PerAttendTimeDTO();
                    perAttendTimeDTO.setCommutRound(perAttendDateDTO.getCommutRound());
                    perAttendTimeDTO.setClockInType(perAttendDateDTO.getClockInType());
                    perAttendTimeDTO.setStartTime(perAttendDateDTO.getAttendTime());
                    perAttendTimeList.add(perAttendTimeDTO);
                }
            }
            for (PerAttendDateDTO perAttendDateDTO : list) {
                for (PerAttendTimeDTO perAttendTimeDTO : perAttendTimeList) {
                    if (perAttendDateDTO.getClockInType().equals(DictConst.CLOCKINTYPE_XBDK)
                            && perAttendDateDTO.getCommutRound() == perAttendTimeDTO.getCommutRound()) {
                        perAttendTimeDTO.setEndTime(dto.getAttendTime());
                    }
                }
            }

            Long absenceTime = 0L;
            for (PerAttendTimeDTO perAttendTimeDTO : perAttendTimeList) {
                if (perAttendTimeDTO.getStartTime() != null && perAttendTimeDTO.getEndTime() != null) {
                    absenceTime += DateUtil.between(perAttendTimeDTO.getStartTime(), perAttendTimeDTO.getEndTime(),
                            DateUnit.MINUTE);
                }
            }
            countPerAttendDate
                    .setAbsenceTime(new BigDecimal(absenceTime).divide(new BigDecimal(60), 2, BigDecimal.ROUND_DOWN));

        } else {
            /*** 计算工作总时长 （需要上下班均打卡才能计算时长）如果有缺卡则不计算轮次 ***/

            List<PerAttendTimeDTO> perAttendTimeList = new ArrayList<>();
            for (PerAttendDateDTO perAttendDateDTO : list) {
                if (!perAttendDateDTO.getAttendStatus().equals(DictConst.ATTENDSTATUS_QK)) { // 排除缺卡情况
                    if (perAttendDateDTO.getClockInType().equals(DictConst.CLOCKINTYPE_SBDK)) {
                        PerAttendTimeDTO perAttendTimeDTO = new PerAttendTimeDTO();
                        perAttendTimeDTO.setCommutRound(perAttendDateDTO.getCommutRound());
                        perAttendTimeDTO.setClockInType(perAttendDateDTO.getClockInType());
                        /***
                         * 不管什么状态，只要有考勤时间就需要纳入计算范围 上班开始时间取考勤时间和打卡时间后面的时间
                         ***/
                        if (perAttendDateDTO.getClockInTime() != null) {
                            if (perAttendDateDTO.getAttendTime().getTime() > perAttendDateDTO.getClockInTime()
                                    .getTime()) {
                                perAttendTimeDTO.setStartTime(perAttendDateDTO.getAttendTime());
                            } else {
                                perAttendTimeDTO.setStartTime(perAttendDateDTO.getClockInTime());
                            }
                            perAttendTimeList.add(perAttendTimeDTO);
                        }
                    }
                }
            }
            for (PerAttendDateDTO perAttendDateDTO : list) {
                for (PerAttendTimeDTO perAttendTimeDTO : perAttendTimeList) {
                    if (!perAttendDateDTO.getAttendStatus().equals(DictConst.ATTENDSTATUS_QK)) { // 排除缺卡情况
                        if (perAttendDateDTO.getClockInType().equals(DictConst.CLOCKINTYPE_XBDK)
                                && perAttendDateDTO.getCommutRound() == perAttendTimeDTO.getCommutRound()) {
                            /***
                             * 不管什么状态，只要有考勤时间就需要纳入计算范围 下班结束时间取考勤时间和打卡时间前面的时间
                             ***/
                            if (perAttendDateDTO.getClockInTime() != null) {
                                if (perAttendDateDTO.getAttendTime().getTime() < perAttendDateDTO.getClockInTime()
                                        .getTime()) {
                                    perAttendTimeDTO.setEndTime(perAttendDateDTO.getAttendTime());
                                } else {
                                    perAttendTimeDTO.setEndTime(perAttendDateDTO.getClockInTime());
                                }
                            }
                        }
                    }
                }
            }
            Long workTime = 0L;
            for (PerAttendTimeDTO perAttendTimeDTO : perAttendTimeList) {
                if (perAttendTimeDTO.getStartTime() != null && perAttendTimeDTO.getEndTime() != null) {
                    workTime += DateUtil.between(perAttendTimeDTO.getStartTime(), perAttendTimeDTO.getEndTime(),
                            DateUnit.MINUTE);
                }
            }
            countPerAttendDate
                    .setWorkHours(new BigDecimal(workTime).divide(new BigDecimal(60), 2, BigDecimal.ROUND_DOWN));
        }

        /*** 更新每日统计情况 ***/

        countPerAttendDate.setUpdateBy(dto.getUpdateBy());
        countPerAttendDate.setUpdateTime(dto.getUpdateTime());
        countPerAttendDate.setAttendDate(DateUtil.parse(dto.getAttendDate()));
        countPerAttendDate.setPerId(dto.getPerId());
        countPerAttendDateMapper.updateCountPerAttendDate(countPerAttendDate);
        return Result.success("修改成功", null);
    }

    /**
     * app内勤统计
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-04
     */
    @Override
    public Result inStatisTics(AppPerAttendCountDTO dto) throws BusinessException {

        if (StringUtils.isEmpty(dto.getCountDimension())) {
            return Result.fail("统计维度不能为空");
        }
        String startDate = "";
        String endDate = "";

        if (dto.getCountDimension().equalsIgnoreCase(DictConst.COUNTDIMENSION_BZ)) {
            startDate = DateUtil.formatDate(DateUtil.beginOfWeek(new Date())); // 本周第一天
            endDate = DateUtils.formatDate(new Date());// 今天
        } else if (dto.getCountDimension().equalsIgnoreCase(DictConst.COUNTDIMENSION_SZ)) {
            startDate = DateUtil.formatDate(DateUtil.beginOfWeek(DateUtil.lastWeek())); // 上周第一天
            endDate = DateUtil.formatDate(DateUtil.endOfWeek(DateUtil.lastWeek()));// 上周最后一天
        } else if (dto.getCountDimension().equalsIgnoreCase(DictConst.COUNTDIMENSION_BY)) {
            startDate = DateUtil.formatDate(DateUtil.beginOfMonth(new Date())); // 本月第一天
            endDate = DateUtils.formatDate(new Date()); // 今天
        } else if (dto.getCountDimension().equalsIgnoreCase(DictConst.COUNTDIMENSION_SY)) {
            startDate = DateUtil.formatDate(DateUtil.beginOfMonth(DateUtil.lastMonth())); // 上月第一天
            endDate = DateUtil.formatDate(DateUtil.endOfMonth(DateUtil.lastMonth())); // 上月最后一天
        } else {
            return Result.fail("统计维度错误");
        }

        /*** 查询内勤统计信息***/
        AppPerAttendCountResultDTO attendInfo = countPerAttendDateMapper.getInAttendCount(dto.getPerId(), dto.getComId(), startDate, endDate);


        List<Map<String, String>> lateList = new ArrayList<>();  // 迟到列表

        List<Map<String, String>> leaveEarlyList = new ArrayList<>(); // 早退列表

        List<Map<String, String>> missCardList = new ArrayList<>(); // 缺卡列表

        List<Map<String, String>> patchCardList = new ArrayList<>(); // 补卡列表

        List<Map<String, Object>> leaveList = new ArrayList<>(); // 请假列表

        List<Map<String, Object>> overTimeList = new ArrayList<>(); // 加班列表


        /*** 如果日统计结果没数据，其余就不需要再查询了 ***/
        if (attendInfo == null) {
            AppPerAttendCountResultDTO attendCountResult = new AppPerAttendCountResultDTO();
            attendCountResult.setAttendDays(0); // 出勤天数
            attendCountResult.setRestDays(0); // 休息天数
            attendCountResult.setAbsenteeismDays(0); // 缺勤天数
            attendCountResult.setWorkHours(new BigDecimal(0)); // 工作总时长
            attendCountResult.setLeaveTime(new BigDecimal(0)); // 请假总时长
            attendCountResult.setOverTime(new BigDecimal(0)); // 加班总时长
            attendCountResult.setLateInfo("0次/共0分钟"); // 迟到信息
            attendCountResult.setLeaveEarlyInfo("0次/共0分钟"); // 早退信息
            attendCountResult.setMissCardTimes("0次"); // 缺卡次数
            attendCountResult.setPatchCardTimes("0次"); // 补卡次数
            attendCountResult.setLeaveInfo("0次/共0小时"); // 请假信息
            attendCountResult.setOverTimeInfo("0次/共0小时"); // 加班信息
            Map<String, Object> result = new LinkedHashMap<>();
            result.put("attendInfo", attendCountResult);
            result.put("lateList", lateList); // 迟到列表
            result.put("leaveEarlyList", leaveEarlyList); // 早退列表
            result.put("missCardList", missCardList);// 缺卡列表
            result.put("patchCardList", patchCardList); // 补卡列表
            result.put("leaveList", leaveList); // 请假列表
            result.put("overTimeList", overTimeList); // 加班列表
            return Result.success(Result.SUCCESS_QUERY_MSG, result);
        }

        /*** 查询异常考勤信息 ***/
        List<PerAttendDateDTO> list = countPerAttendDateMapper.getAbnormalAttendInfo(dto.getPerId(), dto.getComId(), startDate, endDate);

        if (list.size() > 0) {
            /*** 缺卡记录需要单独查询考勤组设置的规则 ***/
            List<PerAttendDateDTO> missCardRecordList = new ArrayList<>(); // 缺卡记录
            List<PerAttendDateDTO> abnormalList = new ArrayList<>(); // 其他异常记录
            for (PerAttendDateDTO attendDateDTO : list) {
                if (attendDateDTO.getAttendStatus().equalsIgnoreCase(DictConst.ATTENDSTATUS_QK)) {
                    missCardRecordList.add(attendDateDTO);
                } else {
                    abnormalList.add(attendDateDTO);
                }
            }

            if (missCardRecordList.size() > 0) {

                missCardList = countPerAttendDateMapper.getMissCardRecord(dto.getPerId(), dto.getComId(), startDate, endDate, missCardRecordList);
            }

            if (abnormalList.size() > 0) {
                /*** 异常打卡记录 包含 (2:迟到,3:早退,1:补卡) ***/
                List<Map<String, String>> abnormalAttendList = countPerAttendDateMapper.getAbnormalAttendRecord(dto.getPerId(), dto.getComId(), abnormalList);
                for (Map<String, String> map : abnormalAttendList) {
                    if (map.get("attendStatus").equalsIgnoreCase(DictConst.ATTENDSTATUS_CD)) {
                        lateList.add(map);
                    } else if (map.get("attendStatus").equalsIgnoreCase(DictConst.ATTENDSTATUS_ZT)) {
                        leaveEarlyList.add(map);
                    } else {
                        patchCardList.add(map);
                    }
                }

            }
        }

        /*** 先查询是否存在请假和加班情况如果有再查询请假加班列表
         * （由于字符串转BigDecimal会丢失进度，所以不从列表来计算）***/

        Map<String, Object> approveInfo = countPerAttendDateMapper.getLeaveAndOverTimeInfo(dto.getPerId(), dto.getComId(), startDate, endDate);

        String leaveInfo = "";
        if (approveInfo.get("leaveCount").equals("0")) {
            leaveInfo = "0次/共0小时";
        } else {
            leaveInfo = approveInfo.get("leaveCount") + "次/共" + approveInfo.get("leaveLongTime") + "小时";
            /*** 查询请假列表 ***/
            leaveList = countPerAttendDateMapper.getAttendLeaveList(dto.getPerId(), dto.getComId(), startDate, endDate);
        }
        String overTimeInfo = "";
        if (approveInfo.get("overtimeCount").equals("0")) {
            overTimeInfo = "0次/共0小时";
        } else {
            overTimeInfo = approveInfo.get("overtimeCount") + "次/共" + approveInfo.get("overtime") + "小时";
            /*** 查询加班列表 ***/
            overTimeList = countPerAttendDateMapper.getOverTimeList(dto.getPerId(), dto.getComId(), startDate, endDate);
        }
        attendInfo.setPatchCardTimes(patchCardList.size()+"次");
        attendInfo.setLeaveInfo(leaveInfo);
        attendInfo.setOverTimeInfo(overTimeInfo);
        Map<String, Object> result = new LinkedHashMap<>();
        result.put("attendInfo", attendInfo);
        result.put("lateList", lateList); // 迟到列表
        result.put("leaveEarlyList", leaveEarlyList); // 早退列表
        result.put("missCardList", missCardList);// 缺卡列表
        result.put("patchCardList", patchCardList); // 补卡列表
        result.put("leaveList", leaveList); // 请假列表
        result.put("overTimeList", overTimeList); // 加班列表
        return Result.success(Result.SUCCESS_QUERY_MSG, result);
    }


}