package com.bcxin.oa.old.service.task.html;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.app.AppComTaskAttendAddressDTO;
import com.bcxin.oa.old.dto.app.AppComTaskContentDTO;
import com.bcxin.oa.old.dto.app.AppComTaskScheduleDTO;
import com.bcxin.oa.old.entity.enterprise.company.ComBaseInfo;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.mapper.app.PerTaskCardRecordMapper;
import com.bcxin.oa.old.mapper.system.SysPoliceMapper;
import com.bcxin.oa.old.mapper.task.CountPerTaskDateMapper;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.service.system.CacheService;
import com.bcxin.oa.old.service.task.ComTaskPerShiftService;
import com.bcxin.oa.old.service.task.ComTaskService;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * APP html5 外勤排班
 *
 * @author luopeng
 * @since 2018-12-18
 */
@Service
@Transactional
public class HtmlComTaskServiceImpl implements HtmlComTaskService {

    //private final static String[] SHIFT_ALIAS_ARRAY = {"班次A", "班次B", "班次C", "班次D", "班次E", "班次F", "班次G", "班次H", "班次I",
    //        "班次J", "班次K", "班次L", "班次M", "班次N", "班次O", "班次P", "班次Q", "班次R", "班次S", "班次T", "班次U", "班次V", "班次W", "班次X",
    //        "班次Y", "班次Z", "休"};

    private final static String[] SHIFT_ALIAS_ALPHA_ARRAY = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K",
            "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "XX"};

    private final static String REST_SHIFT_ALIAS = "休：休息";

    private final static String REST_EN = "xiu";

    @Resource
    private ComTaskAttendAddressMapper comTaskAttendAddressMapper;

    @Resource
    private ComTaskSchedulMapper comTaskSchedulMapper;

    @Resource
    private CommonService commonService;

    @Resource
    private ComTaskMapper comTaskMapper;

    @Resource
    private ComTaskImplementMapper comTaskImplementMapper;

    @Resource
    private ComTaskShiftMapper comTaskShiftMapper;

    @Resource
    private ComTaskSchedulCycleMapper comTaskSchedulCycleMapper;

    @Resource
    private ComTaskCycleShiftMapper comTaskCycleShiftMapper;

    @Resource
    private ComTaskInsidePushMapper comTaskInsidePushMapper;

    @Resource
    private ComShiftRuleMapper comShiftRuleMapper;

    @Resource
    private TaskCardRemindMapper taskCardRemindMapper;

    @Resource
    private ComTaskPerShiftService comTaskPerShiftService;

    @Resource
    private ComTaskService comTaskService;

    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;

    @Resource
    private CountPerTaskDateMapper countPerTaskDateMapper;

    @Resource
    private SysPoliceMapper sysPoliceMapper;

    @Resource
    private PerTaskCardRecordMapper perTaskCardRecordMapper;

    @Resource
    private BbdTestService bbdTestService;

    @Resource
    private IdWorker idWorker;

    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;

    @Resource
    private CacheService cacheService;

    /*----------------------------APP html5 外勤排班发布设置------------------------*/

    /**
     * 保存排班，手动排班
     *
     * @return
     */
    @Override
    public Result publishTask(ParamDTO paramDTO) {
        AppComTaskContentDTO dto = JSON.parseObject(paramDTO.getTaskDetail(), AppComTaskContentDTO.class);
        // 1.新增任务表
        ComTask comTask = new ComTask();
        /* 修改操作 */
        if (dto.getComTaskId() != null) {
            comTask = comTaskMapper.getByPrimaryKey(dto.getComTaskId());
            comTask.setTaskName(dto.getTaskName());
            comTask.setTaskType(dto.getTaskType());
			/* 先清除之前的地址 */
            comTaskAttendAddressMapper.deleteTaskAttendAddressById(comTask.getComTaskId());
			/* 再保存 */
            saveTaskAttendAddress(paramDTO, dto, idWorker, comTask);
            return Result.success(Result.SUCCESS_MSG, comTask.getComTaskId());
        }
        comTask.setComTaskId(idWorker.nextId());
        comTask.setIsDelete(CommonConst.N);
        comTask.setComId(paramDTO.getComId());
        /*** 如果任务开始日期早于或者等于当前日期为进行中，否则为未开始 ***/
        if (DateUtils.dateCompare(dto.getStartDate(), DateUtils.getDate())) {
            comTask.setTaskStatus(DictConst.TASKSTATUS_JXZ);
        } else {
            comTask.setTaskStatus(DictConst.TASKSTATUS_WKS);
        }
        comTask.setCreateBy(paramDTO.getCreateBy());
        comTask.setTaskName(dto.getTaskName());
        comTask.setTaskAssign(DictConst.TASKASSIGN_WQ);
        comTask.setTaskType(dto.getTaskType());
        comTask.setTaskNature(DictConst.TASKNATURE_GD);
        comTask.setAttendType(DictConst.ATTENDTYPE_PBZ);
        comTask.setTaskLevel(DictConst.TASKLEVEL_QYJ);
        /* config_industry_dict codeType:serviceType*/
        comTask.setServiceType("010009");
        comTask.setUrgentLevel(DictConst.URGENTLEVEL_PT);
        //projectLevel
        comTask.setAttendSubType(StringUtil.isEmpty(paramDTO.getAttendSubType()) ? DictConst.ATTENDSUBTYPE_SD : paramDTO.getAttendSubType());
        comTask.setTaskContent(dto.getTaskDetail());
        comTask.setProvince(dto.getProvince());
        comTask.setCity(dto.getCity());
        comTask.setArea(dto.getArea());
        comTask.setTaskAddress(dto.getAddress());
        comTask.setAddressLatitude(dto.getAddressLatitude());
        comTask.setAddressLongitude(dto.getAddressLongitude());
        comTask.setExecRange(dto.getExecRange());
        comTask.setStartDate(DateUtil.parseDate(dto.getStartDate()));
        comTask.setEndDate(DateUtil.parseDate(dto.getEndDate()));
        comTask.setLocusReportSwitch(dto.getLocusReportSwitch());
        comTask.setChargePerId(dto.getInChargePerId());
        comTask.setServiceObject(dto.getServiceObject());
        comTask.setIsSecurityImportantUnit(dto.getIsSecurityImportantUnit());
        comTask.setServiceObjectSySituation(dto.getServiceObjectSySituation());
        comTask.setServiceObjectType(dto.getServiceObjectType());
        comTask.setTaskStationType(dto.getTaskStationType());

        /*** 驻勤监管公安机构信息 by llc 2020-02-18 ***/
        comTask.setCityOrgId(dto.getCityOrgId());
        comTask.setDistrictOrgId(dto.getDistrictOrgId());
        comTask.setPoliceStationId(dto.getPoliceStationId());
        /*** 获取所选公安机构对应的百保盾ID ***/
        Long policeId = dto.getPoliceStationId() == null ? (dto.getDistrictOrgId() == null ? dto.getCityOrgId() : dto.getDistrictOrgId()) : dto.getPoliceStationId();
        if (policeId != null) {
            Long bbdId = sysPoliceMapper.getBbdIdByPoliceId(policeId);
            comTask.setBbdId(bbdId);
        }
        if (comTaskMapper.insert(comTask) <= 0) {
            throw new BusinessException(Result.ERROR, "新建任务失败");
        }

		/* 2.任务考勤地址 */
        saveTaskAttendAddress(paramDTO, dto, idWorker, comTask);

		/* 3.新增任务班次表 */
        List<ComTaskShift> shiftList = saveTaskShift(paramDTO.getComId(), dto.getShiftIds(), comTask.getComTaskId());

		/* 4.当排班方式为周期排班时，新增周期表 */
        List<ComTaskSchedulCycle> cycleList = Lists.newArrayList();
        if (DictConst.ATTENDSUBTYPE_ZQ.equals(comTask.getAttendSubType())) {
            cycleList = saveTaskSchedule(paramDTO, dto, idWorker, comTask);
        }

		/* 5. 新增负责人 */
        saveChargePer(paramDTO, idWorker, comTask);

		/* 6. 新增执勤人 */
        List<ComTaskInsidePush> perList = packAndsaveTaskPer(paramDTO, dto, comTask);

        /* 7.初始化排班信息 */
        if (DictConst.ATTENDSUBTYPE_SD.equals(comTask.getAttendSubType())) {
            /* 手动排班 */
//            initTaskPerShift(comTask,perList,null);
        } else if (DictConst.ATTENDSUBTYPE_ZQ.equals(comTask.getAttendSubType())) {
            /* 周期排班 */
            initTaskPerShiftCycle(comTask, cycleList);
        }
        /* 8.插入打卡提醒表*/
        comTaskService.initTaskRemind(paramDTO.getComId(), comTask, shiftList);

        /*** 同步百保盾 by llc 2020-02-18 ***/
        ComTaskDto comTaskDto = new ComTaskDto();
        BeanUtil.copyProperties(comTask, comTaskDto);
        comTaskDto.setSessionId(paramDTO.getSessionId());

        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(paramDTO.getComId());
        String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
        /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
        if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//            bdpSyncService.addTask(comTaskDto);
        }else{
            bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
        }

        return Result.success(Result.SUCCESS_MSG, String.valueOf(comTask.getComTaskId()));
    }

    /**
     * 外勤任务列表（我发布的）
     *
     * @param dto
     * @return
     * @update by llc 2020-04-10
     */
    @Override
    public Result listTaskCreatePage(ComTaskDto dto) {
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<Map> list = comTaskMapper.listTaskCreatePage(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 外勤任务列表（我负责的）
     *
     * @param dto
     * @return
     * @update by llc 2020-04-10
     */
    @Override
    public Result listTaskChargePage(ComTaskDto dto) {
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<Map> list = comTaskMapper.listTaskChargePage(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }


    /**
     * 取消外勤
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result cancelTask(ParamDTO paramDTO) {
        ComTask comTask = checkTask(paramDTO.getComTaskId());

        if (DictConst.TASKSTATUS_YQX.equals(comTask.getTaskStatus())
                || DictConst.TASKSTATUS_YJS.equals(comTask.getTaskStatus())) {
            return Result.success(Result.SUCCESS_MSG);
        }
        // 结束任务之前状态
        Date today = new Date();
        String todayStr = DateUtils.formatDate(today);
        String taskStatus = comTask.getTaskStatus();
        comTask.setEndDate(today);
        if (comTask.getTaskStatus().equals(DictConst.TASKSTATUS_WKS)) {
            comTask.setTaskStatus(DictConst.TASKSTATUS_YQX);
        } else {
            comTask.setTaskStatus(DictConst.TASKSTATUS_YJS);
        }
        comTaskMapper.update(comTask);


        /*** 删除今日开始的排班记录 ***/

        comTaskSchedulMapper.deleteTaskSchedulFromDate(paramDTO.getComTaskId(), paramDTO.getComId(), todayStr);

        /*** 删除今日开始的任务执行情况 ***/

        comTaskImplementMapper.deleteImplementFromDate(paramDTO.getComTaskId(), paramDTO.getComId(), todayStr);

        /*** 删除今日开始的打卡记录 ***/

        perTaskCardRecordMapper.deleteTaskCardRecordByDate(paramDTO.getComTaskId(), paramDTO.getComId(), todayStr);

        /*** 删除打卡提醒表 ***/
        taskCardRemindMapper.deleteByTask(paramDTO.getComTaskId());


        // 获取任务出勤人员
        List<Map> perList = comTaskInsidePushMapper.listTaskInsidePushDetail(comTask.getComTaskId(), DateUtil.formatDate(comTask.getEndDate()));
        if (CollectionUtil.isNotEmpty(perList)) {
            String[] taskPerArray = new String[perList.size()];
            int i = 0;
            for (Map map : perList) {
                taskPerArray[i] = map.get("perId").toString();
                i++;
            }
            String taskPers = StringUtils.join(taskPerArray, CommonConst.DOT);
            // 发送取消任务通知
            String tilte = "";
            String content = "";
            // 任务未开始，则取消任务
            if (taskStatus.equals(DictConst.TASKSTATUS_WKS)) {
                tilte = MsgConst.TYPE_020104_TASK_DELETE_TITLE;
                content = MsgConst.TYPE_020104_TASK_DELETE_CONTENT;
            } else {
                // 任务已开始，则关闭任务
                tilte = MsgConst.TYPE_020104_TASK_CLOSE_TITLE;
                content = MsgConst.TYPE_020104_TASK_CLOSE_CONTENT;
            }
            content = content.replace("{taskName}", comTask.getTaskName())
                    .replace("{taskAddress}", comTask.getTaskAddress())
                    .replace("{taskStart}", comTask.getStartDate() == null ? "" : DateUtil.formatDate(comTask.getStartDate()))
                    .replace("{taskEnd}", comTask.getEndDate() == null ? "" : DateUtil.formatDate(comTask.getEndDate()));
            commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020104, taskPers,
                    comTask.getComId(), comTask.getComTaskId());
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 修改任务详情
     *
     * @return
     */
    @Override
    public Result updateTask(ParamDTO paramDTO) {
        AppComTaskContentDTO dto = JSON.parseObject(paramDTO.getTaskDetail(), AppComTaskContentDTO.class);
        if (dto.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "请选择任务id");
        }
        ComTask comTask = comTaskMapper.getByPrimaryKey(dto.getComTaskId());
        comTask.setTaskName(dto.getTaskName());
        comTask.setTaskType(dto.getTaskType());
        comTask.setTaskContent(dto.getTaskDetail());
        comTask.setProvince(dto.getProvince());
        comTask.setCity(dto.getCity());
        comTask.setArea(dto.getArea());
        comTask.setTaskAddress(dto.getAddress());
        comTask.setAddressLatitude(dto.getAddressLatitude());
        comTask.setAddressLongitude(dto.getAddressLongitude());
        comTask.setExecRange(dto.getExecRange());
        comTask.setServiceObject(dto.getServiceObject());
        comTask.setIsSecurityImportantUnit(dto.getIsSecurityImportantUnit());
        comTask.setServiceObjectSySituation(dto.getServiceObjectSySituation());
        comTask.setServiceObjectType(dto.getServiceObjectType());
        comTask.setTaskStationType(dto.getTaskStationType());

        /* 先清除之前的地址 */
        comTaskAttendAddressMapper.deleteTaskAttendAddressById(comTask.getComTaskId());
		/* 再保存 */
        saveTaskAttendAddress(paramDTO, dto, idWorker, comTask);

        /*** 驻勤监管公安机构信息 by llc 2020-02-18 ***/
        comTask.setCityOrgId(dto.getCityOrgId());
        comTask.setDistrictOrgId(dto.getDistrictOrgId());
        comTask.setPoliceStationId(dto.getPoliceStationId());
        /*** 获取所选公安机构对应的百保盾ID ***/
        Long policeId = dto.getPoliceStationId() == null ? (dto.getDistrictOrgId() == null ? dto.getCityOrgId() : dto.getDistrictOrgId()) : dto.getPoliceStationId();
        if (policeId != null) {
            Long bbdId = sysPoliceMapper.getBbdIdByPoliceId(policeId);
            comTask.setBbdId(bbdId);
        }
        comTaskMapper.update(comTask);

        /*** 同步百保盾 by llc 2020-02-18 ***/
        ComTaskDto comTaskDto = new ComTaskDto();
        BeanUtil.copyProperties(comTask, comTaskDto);
        comTaskDto.setSessionId(paramDTO.getSessionId());
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectByID(paramDTO.getComId());
        String bdpProvince = cacheService.getSystemConfig(CommonConst.BDP_PROVINCES);
        /*** 如果企业注册所在省匹配到数据分发中心省份,则推送到数据分发中心，否则推送到百保盾子站 ***/
        if(bdpProvince.contains(comBaseInfo.getRegProvince().toString())){
//            bdpSyncService.updateTask(comTaskDto);
        }else{
            bbdTestService.bbdSaveOrUpdateTask(comTaskDto);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 修改班次
     *
     * @return
     */
    @Override
    public Result updateShift(ParamDTO paramDTO) {
        if (paramDTO.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "请选择任务id");
        }
        if (paramDTO.getIds() == null) {
            throw new BusinessException(Result.ERROR, "请选择班次id");
        }
        saveTaskShift(paramDTO.getComId(), paramDTO.getIds(), paramDTO.getComTaskId());
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 修改周期详情
     *
     * @return
     */
    @Override
    public Result updateCycle(ParamDTO paramDTO) {
        AppComTaskScheduleDTO dto = JSON.parseObject(paramDTO.getTaskDetail(), AppComTaskScheduleDTO.class);
        if (paramDTO.getComTaskId() == null) {
            throw new BusinessException(Result.ERROR, "请选择任务id");
        }
        if (paramDTO.getId() == null) {
            throw new BusinessException(Result.ERROR, "请选择周期id");
        }
        if (DateUtil.offsetDay(DateUtil.parseDate(dto.getStartDate()), 1).before(DateUtil.date())) {
            throw new BusinessException(Result.ERROR, "周期循环开始日期不能早于今天");
        }

        ComTask comTask = comTaskMapper.getByPrimaryKey(paramDTO.getComTaskId());
        ComTaskSchedulCycle cycle = comTaskSchedulCycleMapper.getByPrimaryKey(Long.parseLong(paramDTO.getId()));
        /* 拿到增加的人员名单 */
        List<String> addPerIds = Lists.newArrayList();
        List<String> deletePerIds = Lists.newArrayList();
        if (!cycle.getPerIds().equals(paramDTO.getPerIds())) {
            List<String> selectPerIds = StrSplitter.split(paramDTO.getPerIds(), CommonConst.COMMA, true, true);
            for (String perId : selectPerIds) {
                if (cycle.getPerIds().contains(perId)) {
                    continue;
                }
                addPerIds.add(perId);
            }
        }

        /* 修改周期信息 */
        cycle.setCycleName(dto.getCycleName());
        cycle.setStartDate(DateUtil.parseDate(dto.getStartDate()));
        cycle.setEndDate(DateUtil.parseDate(dto.getEndDate()));
        cycle.setPerIds(dto.getPerIds());
        cycle.setCycleDays(dto.getCycleDays());

        /* 增加新人员，新人员进行排班 */
        List<MultiDataDTO> cycleShiftList = comTaskCycleShiftMapper.getTaskCycleShiftByList(Lists.newArrayList(cycle));
        Multimap<Long, MultiDataDTO> cycleShiftMap = ArrayListMultimap.create();
        for (MultiDataDTO dto2 : cycleShiftList) {
            cycleShiftMap.put(dto2.getId(), dto2);
        }
        packShiftCycle(comTask, Lists.newArrayList(cycle), cycleShiftMap, addPerIds);

        /* 周期时间调整 */


        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 任务详细信息
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskDetail(ParamDTO paramDTO) {
        Map<String, Object> result = Maps.newHashMap();
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        /* 拿签到地址和签到范围 */
        List<ComTaskAttendAddress> attendAddressList = comTaskAttendAddressMapper.listComTaskAttendAddress(comTask.getComTaskId());
        if (DictConst.ATTENDSUBTYPE_ZQ.equals(comTask.getAttendSubType())) {
            /* 拿到周期信息 */
            List<Map> cycleList = comTaskSchedulCycleMapper.getTaskCycle(comTask.getComTaskId());
            result.put("cycleList", cycleList);
        }
        result.put("comTask", comTask);
        result.put("attendAddressList", attendAddressList);

        return Result.success(Result.SUCCESS_MSG, result);
    }


    /**
     * 周期详细信息
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result cycleDetail(ParamDTO paramDTO) {
        if (StringUtil.isEmpty(paramDTO.getId())) {
            throw new BusinessException(Result.ERROR, "请选择周期id");
        }
        ComTaskSchedulCycle cycle = comTaskSchedulCycleMapper.getByPrimaryKey(Long.parseLong(paramDTO.getId()));
        Map<String, Object> result = Maps.newHashMap();
        result.put("cycle", cycle);
        /* 需要将成员的id转成姓名 */
        List<String> perIdList = StrSplitter.split(cycle.getPerIds(), CommonConst.COMMA, true, true);
        Collection<Long> perIdCol = Lists.newArrayList();
        for (String str : perIdList) {
            perIdCol.add(Long.parseLong(str));
        }
        List<String> perNameList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(perIdCol)) {
            perNameList = perBaseInfoMapper.selectNameByPrimaryList(perIdCol);
        }
        result.put("perNameList", perNameList);

        List<MultiDataDTO> cycleShiftList = comTaskCycleShiftMapper.getTaskCycleShift(cycle.getTaskSchedulCycleId());
        result.put("cycleShiftList", cycleShiftList);
        /* 进行别名赋值 */
        List<MultiDataDTO> shiftList = comTaskShiftMapper.getShiftByTask(paramDTO.getComTaskId());
        /* 设置班次的别名 如 班次A：9：00~10：00 班次B：9：00~10：00 */
        convertAliasMap(shiftList);

		/* 设置休息的班次 */
        MultiDataDTO dataDTO = new MultiDataDTO();
        dataDTO.setShiftId(0L);
        dataDTO.setShiftAlias(REST_SHIFT_ALIAS);
        dataDTO.setExtra(REST_EN);
        shiftList.add(dataDTO);

        return Result.success(Result.SUCCESS_MSG, result);
    }


    /**
     * 排班日历（总览）
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskCalendarGeneral(ParamDTO paramDTO) {
		/* 先拿当月，如果当月不在任务范围内，则拿任务最近的一个月 */
        ComTask comTask = comTaskMapper.getByPrimaryKey(paramDTO.getComTaskId());
        if (StringUtil.isEmpty(paramDTO.getMonth())) {
            throw new BusinessException(Result.ERROR, "请选择月份");
        }
        List<MultiDataDTO> dataDTOList = Lists.newArrayList();
        Date taskStartDate = comTask.getStartDate();
        Date taskEndDate = comTask.getEndDate();
        Date correctStartDate = DateUtil.offsetMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01"), -1);
        Date correctEndDate = DateUtil.endOfMonth(DateUtil.offsetMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01"), 1));
        if (correctStartDate.after(taskEndDate)) {
            return Result.success(Result.SUCCESS_MSG, dataDTOList);
        }
        if (correctEndDate.before(taskStartDate)) {
            return Result.success(Result.SUCCESS_MSG, dataDTOList);
        }
        /* 如果correctStartDate早于任务开始时间，则取任务开始时间 */
        if (correctStartDate.before(taskStartDate)) {
            correctStartDate = taskStartDate;
        }
        /* 如果correctEndDate晚于任务结束时间，则取任务结束时间 */
        if (correctEndDate.after(taskEndDate)) {
            correctEndDate = taskEndDate;
        }
        dataDTOList = comTaskImplementMapper.groupMonthPerTask(paramDTO.getComTaskId(),
                correctStartDate, correctEndDate);
        return Result.success(Result.SUCCESS_MSG, dataDTOList);
    }

    /**
     * 排班日历（总览） 点击某一天，查找当天的班次，以及班次对应的人员
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskDayShift(ParamDTO paramDTO) {
        // 1、参数校验
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        if (StringUtil.isEmpty(paramDTO.getDate())) {
            throw new BusinessException(Result.ERROR, "请选择日期");
        }
        Map<Long, Map> resultMap = Maps.newHashMap();
		/* 拿到任务排班对应的班次，人员情况 */
        List<MultiDataDTO> shiftList = comTaskImplementMapper.listDatesTaskShift(comTask.getComTaskId(),
                paramDTO.getDate());
        for (MultiDataDTO dto : shiftList) {
            /* 已经获得到班次信息了，只需要将人员再次添加进去即可 */
            if (resultMap.containsKey(dto.getShiftId())) {
                Map map = resultMap.get(dto.getShiftId());
                List<MultiDataDTO> newList = (List<MultiDataDTO>) map.get("perList");
                newList.add(dto);
                map.put("perList", newList);
                resultMap.put(dto.getShiftId(), map);
            } else {
                /* 拿到班次的轮次规则 */
                List<MultiDataDTO> dataDTOList = comShiftRuleMapper.getTimeNodeByShiftId(dto.getShiftId());
                StringBuilder stringBuffer = new StringBuilder();
                for (MultiDataDTO dto2 : dataDTOList) {
                    stringBuffer.append(dto2.getTimeNode()).append(" ");
                }
                Map<String, Object> map = Maps.newHashMap();
                map.put("shiftId", dto.getShiftId());
                map.put("shiftName", dto.getShiftName());
                map.put("shiftRule", stringBuffer.toString());
                List<MultiDataDTO> perList = Lists.newArrayList();
                perList.add(dto);
                map.put("perList", perList);
                resultMap.put(dto.getShiftId(), map);
            }
        }
        return Result.success(Result.SUCCESS_MSG, resultMap.values());
    }

    /**
     * 排班日历（个人） 点击某个月，某个人，查找当月的所有班次
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskPerCalendarGeneral(ParamDTO paramDTO) {
        // 1、参数校验
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        if (StringUtil.isEmpty(paramDTO.getMonth())) {
            throw new BusinessException(Result.ERROR, "请选择月份");
        }
        if (paramDTO.getPerId() == null) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }

        Date startDate = comTask.getStartDate();
        Date endDate = comTask.getEndDate();
        Date correctStartDate;
        Date correctEndDate;

		/* 开始时间是否早于当月1号，如果早于，则拿当月1号，如果晚，则拿开始时间 */
        if (startDate.before(DateUtil.beginOfMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01")))) {
            correctStartDate = DateUtil.beginOfMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01"));
        } else {
            correctStartDate = startDate;
        }
		/* 结束时间是否晚于当月月底，如果晚于，则拿当月月底，如果早，则拿结束时间 */
        if (endDate.after(DateUtil.endOfMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01")))) {
            correctEndDate = DateUtil.endOfMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01"));
        } else {
            correctEndDate = endDate;
        }

        Map<String, Object> resultMap = Maps.newHashMap();
		/* 拿到任务排班对应的班次，人员排班情况 */
        List<MultiDataDTO> dataDTOList = comTaskImplementMapper.listMonthPerTask(paramDTO.getComTaskId(),
                paramDTO.getPerId(), correctStartDate, correctEndDate);
        List<MultiDataDTO> shiftList = comTaskShiftMapper.getShiftByTask(comTask.getComTaskId());
        Map<Long, String> alphaMap = calcAliasAlphaMap(shiftList);
        for (MultiDataDTO dataDTO : dataDTOList) {
            if (dataDTO.getShiftId() == null) {
                dataDTO.setShiftAlias(REST_EN);
            } else {
                dataDTO.setShiftAlias(alphaMap.get(dataDTO.getShiftId()));
            }
        }
        resultMap.put("shiftList", dataDTOList);
        return Result.success(Result.SUCCESS_MSG, resultMap);
    }

    /**
     * 排班日历（个人） 查找任务对应的班次
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskShift(ParamDTO paramDTO) {
        // 1、参数校验
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        List<MultiDataDTO> shiftList = comTaskShiftMapper.getShiftByTask(comTask.getComTaskId());

        /* 设置班次的别名 如 班次A：9：00~10：00 班次B：9：00~10：00 */
        convertAliasMap(shiftList);

		/* 设置休息的班次 */
        MultiDataDTO dataDTO = new MultiDataDTO();
        dataDTO.setShiftId(0L);
        dataDTO.setShiftAlias(REST_SHIFT_ALIAS);
        dataDTO.setExtra(REST_EN);
        shiftList.add(dataDTO);

        return Result.success(Result.SUCCESS_MSG, shiftList);
    }


    /**
     * 个人当天排班（校验），支持多人
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result validatePerShift(ParamDTO paramDTO) {
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        if (paramDTO.getPerId() == null && StringUtil.isEmpty(paramDTO.getPerIds())) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }
        if (StringUtil.isEmpty(paramDTO.getDate())) {
            throw new BusinessException(Result.ERROR, "请选择日期");
        }
        if (StringUtil.isEmpty(paramDTO.getIds())) {
            throw new BusinessException(Result.ERROR, "请选择班次");
        }
        /* 判断当前选中的日期是否在 有效的任务时间区间内 */
        if (!DateUtil.isIn(DateUtil.parseDate(paramDTO.getDate()), comTask.getStartDate(), comTask.getEndDate())) {
            throw new BusinessException(Result.ERROR, "排班日期不能超出任务有效日期范围");
        }
        if (paramDTO.getComId() == null) {
            paramDTO.setComId(0L);
        }
        if (paramDTO.getPerId() != null) {
            List<String> conflictList = comTaskPerShiftService.validateShiftDateConflict(paramDTO.getIds(), paramDTO.getDate(), Lists.newArrayList(paramDTO.getPerId() + ""), paramDTO.getComTaskId(), paramDTO.getComId());
            if (CollectionUtil.isNotEmpty(conflictList)) {
                return Result.fail("人员排班有冲突", conflictList);
            }
        } else if (StringUtil.isNotEmpty(paramDTO.getPerIds())) {
            List<String> idList = StrSplitter.split(paramDTO.getPerIds(), CommonConst.COMMA, true, true);
            List<String> conflictList = comTaskPerShiftService.validateShiftDateConflict(paramDTO.getIds(), paramDTO.getDate(), idList, paramDTO.getComTaskId(), paramDTO.getComId());
            if (CollectionUtil.isNotEmpty(conflictList)) {
                return Result.fail("人员排班有冲突", conflictList);
            }
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 个人当天排班（插入），支持多人
     *
     * @param dto
     * @return
     */
    @Override
    public Result perShiftInDB(ParamDTO dto) {
        if (StringUtil.isEmpty(dto.getPerIds())) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }
        if (StringUtil.isEmpty(dto.getDate())) {
            throw new BusinessException(Result.ERROR, "请选择日期");
        }
        if (StringUtil.isEmpty(dto.getId())) {
            throw new BusinessException(Result.ERROR, "请选择班次");
        }
        List<String> perIdList = StrSplitter.split(dto.getPerIds(), CommonConst.COMMA, true, true);

        /*** 校验是否存在排班冲突 ***/

        List<Map<String, String>> conflictSchedulList = comTaskSchedulMapper.getConflictSchedulList(dto.getComTaskId(), dto.getComId(), dto.getDate(), perIdList);

        List<String> checkPassPerIdList = new ArrayList<>();
        for (String perId : perIdList) {
            Boolean matchFlag = false;
            for (Map<String, String> map : conflictSchedulList) {
                if (ObjectUtils.equals(perId,map.get("perId"))) {
                    matchFlag = true;
                    break;
                }
            }
            /*** 不存在排班冲突才进行排班 ***/
            if (!matchFlag) {
                checkPassPerIdList.add(perId);
            }
        }

        if (checkPassPerIdList.size() > 0) {

            /*** 清除当日的排班情况 ***/
            comTaskSchedulMapper.deleteByPerListAndDate(dto.getDate(), checkPassPerIdList, dto.getComTaskId(), dto.getComId());

            /*** 清除当日的任务执行情况 ***/
            comTaskImplementMapper.deleteByPerListAndDate(dto.getDate(), checkPassPerIdList, dto.getComTaskId(), dto.getComId());

            List<ComTaskImplement> implementList = Lists.newArrayList();
            List<ComTaskSchedul> taskSchedulList = Lists.newArrayList();

            Date date = null;
            try {
                date = DateUtils.parseDate(dto.getDate(), "yyyy-MM-dd");
            } catch (Exception e) {

            }
            int weekDay = DateUtils.dayOfWeek(dto.getDate());

            Long shiftId = Long.parseLong(dto.getId());
            if (shiftId.equals(0L)) {
                /*** 休息 ***/
                for (String perId : checkPassPerIdList) {
                    ComTaskSchedul comTaskSchedul = new ComTaskSchedul();
                    comTaskSchedul.setTaskSchedulId(idWorker.nextId());
                    comTaskSchedul.setCreateTime(dto.getCreateTime());
                    comTaskSchedul.setCreateBy(dto.getCreateBy());
                    comTaskSchedul.setComId(dto.getComId());
                    comTaskSchedul.setSchedulDate(date);
                    comTaskSchedul.setIsRest(CommonConst.Y);
                    comTaskSchedul.setComTaskId(dto.getComTaskId());
                    comTaskSchedul.setPerId(Long.parseLong(perId));
                    comTaskSchedul.setShiftId(null);
                    taskSchedulList.add(comTaskSchedul);

                    ComTaskImplement comTaskImplement = new ComTaskImplement();
                    comTaskImplement.setTaskImplementId(idWorker.nextId());
                    comTaskImplement.setCreateTime(dto.getCreateTime());
                    comTaskImplement.setCreateBy(dto.getCreateBy());
                    comTaskImplement.setWeekDay(weekDay);
                    comTaskImplement.setDates(date);
                    comTaskImplement.setIsRest(CommonConst.Y);
                    comTaskImplement.setAttendType(DictConst.ATTENDTYPE_PBZ);
                    comTaskImplement.setComTaskId(dto.getComTaskId());
                    comTaskImplement.setComId(dto.getComId());
                    comTaskImplement.setPerId(Long.parseLong(perId));
                    implementList.add(comTaskImplement);
                }

            } else {
                /*** 未休息 **/
                List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getShiftRuleByShiftId(shiftId);
                for (String perId : checkPassPerIdList) {
                    ComTaskSchedul comTaskSchedul = new ComTaskSchedul();
                    comTaskSchedul.setTaskSchedulId(idWorker.nextId());
                    comTaskSchedul.setCreateTime(dto.getCreateTime());
                    comTaskSchedul.setCreateBy(dto.getCreateBy());
                    comTaskSchedul.setComId(dto.getComId());
                    comTaskSchedul.setSchedulDate(date);
                    comTaskSchedul.setIsRest(CommonConst.N);
                    comTaskSchedul.setComTaskId(dto.getComTaskId());
                    comTaskSchedul.setPerId(Long.parseLong(perId));
                    comTaskSchedul.setShiftId(shiftId);
                    taskSchedulList.add(comTaskSchedul);
                    for (ComShiftRule comShiftRule : shiftRuleList) {
                        ComTaskImplement comTaskImplement = new ComTaskImplement();
                        comTaskImplement.setTaskImplementId(idWorker.nextId());
                        comTaskImplement.setCreateTime(dto.getCreateTime());
                        comTaskImplement.setCreateBy(dto.getCreateBy());
                        comTaskImplement.setWeekDay(weekDay);
                        comTaskImplement.setDates(date);
                        comTaskImplement.setIsRest(CommonConst.N);
                        comTaskImplement.setAttendType(DictConst.ATTENDTYPE_PBZ);
                        comTaskImplement.setComTaskId(dto.getComTaskId());
                        comTaskImplement.setComId(dto.getComId());
                        comTaskImplement.setPerId(Long.parseLong(perId));
                        comTaskImplement.setShiftId(comShiftRule.getShiftId());
                        comTaskImplement.setShiftRuleId(comShiftRule.getShiftRuleId());
                        implementList.add(comTaskImplement);
                    }
                }
            }

            /*** 插入排班记录 ***/

            comTaskSchedulMapper.insertBatch(taskSchedulList);

            /*** 插入任务执行情况 ***/

            comTaskImplementMapper.insertBatch(implementList);

            /*** 同步百保盾 ***/
            bbdTestService.bbdSyncTaskSchedul(taskSchedulList,dto);
        }
        return Result.success(Result.SUCCESS_MSG, conflictSchedulList);
    }

    private void setTaskImplement(ParamDTO paramDTO, Long comTaskId, Long perId, String date, List<String> shiftIdList, List<ComTaskImplement> implementList, List<ComTaskSchedul> taskSchedulList) {
        /* 排班制排班 */
        /* 删除这个人当天排班表的排班情况 */
        comTaskImplementMapper.deleteImplementByTask(date, perId, comTaskId);
        comTaskSchedulMapper.deleteByPerTask(date, perId, comTaskId);
        /* 重新插入当天排班表的排班情况 */
        for (String shiftId : shiftIdList) {
            /* 同时插入轮次，如果一个班次有多个轮次，则插入多条记录 */
            List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getShiftRuleByShiftId(Long.parseLong(shiftId));
            for (ComShiftRule shiftRule : shiftRuleList) {
                /* 休息日，插入休息日的数据 */
                if (StrUtil.isEmpty(shiftId) || "null".equals(shiftId) || "0".equals(shiftId)) {
                    ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, paramDTO.getComId(), comTaskId, perId, date,
                            null, shiftRule.getShiftRuleId(), DictConst.ATTENDTYPE_PBZ, PublicConst.Y,
                            paramDTO.getCreateBy());
                    implementList.add(obj);
                } else {
                    /* 重新插入新的排班情况 */
                    ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, paramDTO.getComId(), comTaskId, perId, date,
                            shiftId, shiftRule.getShiftRuleId(), DictConst.ATTENDTYPE_PBZ, PublicConst.N,
                            paramDTO.getCreateBy());
                    implementList.add(obj);
                }
            }
            if (StrUtil.isEmpty(shiftId) || "null".equals(shiftId) || "0".equals(shiftId)) {
                ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, paramDTO.getComId(), comTaskId, perId, date,
                        null, PublicConst.Y);
                taskSchedulList.add(obj2);
            } else {
                ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, paramDTO.getComId(), comTaskId, perId, date,
                        shiftId, PublicConst.N);
                taskSchedulList.add(obj2);
            }

        }
    }


    /**
     * 任务组员
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskPer(ParamDTO paramDTO) {
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        List<Map> list = comTaskInsidePushMapper.listTaskInsidePushDetail(paramDTO.getComTaskId(), DateUtil.formatDate(comTask.getEndDate()));
        return Result.success(Result.SUCCESS_MSG, list);
    }

    /**
     * 任务负责人
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result taskChargePer(ParamDTO paramDTO) {
        List<Map> list = comTaskMapper.listTaskChargePerDetail(paramDTO.getComTaskId());
        return Result.success(Result.SUCCESS_MSG, list);
    }

    /**
     * 移除组员
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result removePer(ParamDTO paramDTO) {
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        if (paramDTO.getPerId() == null) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }

        // 按人员列表删除未到的班次但是已经提前打卡
        comTaskImplementMapper.deletePerTaskCardRecordByPerson(paramDTO.getComTaskId(), Lists.newArrayList(paramDTO.getPerId() + ""));
        comTaskImplementMapper.deleteRestTaskImplementByDateAndPer(paramDTO.getComTaskId(), paramDTO.getPerId(), DateUtil.today());
        comTaskImplementMapper.deleteTaskImplementByDateAndPer(paramDTO.getComTaskId(), paramDTO.getPerId());
        comTaskSchedulMapper.deleteByPerTaskAndFromDate(DateUtil.today(), paramDTO.getPerId(), paramDTO.getComTaskId());

        /* 修改班次人员信息表 */
        /* 上一条记录结束日期设置为今天 */
        ComTaskInsidePush comTaskInsidePush = comTaskInsidePushMapper.getLastPer(paramDTO.getPerId(), paramDTO.getComTaskId());
        if (comTaskInsidePush != null) {
            comTaskInsidePush.setEndDate(DateUtil.date());
            comTaskInsidePushMapper.update(comTaskInsidePush);
        }

        if (paramDTO.getCreateBy() != null) {

            List<Map> chargeList = comTaskMapper.listTaskChargePerDetail(comTask.getComTaskId());
            String removePerName = perBaseInfoMapper.getNameById(paramDTO.getPerId());
            String opName = perBaseInfoMapper.getNameById(paramDTO.getCreateBy());


            /* 通知管理员，负责人 */
            StringBuilder taskPers = new StringBuilder();
            taskPers.append(String.valueOf(comTask.getCreateBy())).append(CommonConst.COMMA);
            for (Map map : chargeList) {
                taskPers.append(map.get("perId").toString()).append(CommonConst.COMMA);
            }
            String content2 = MsgConst.TYPE_020114_TASK_REMOVE_PER_MANAGE_CONTENT;
            content2 = content2.replace("{taskName}", comTask.getTaskName()).replace("{operate}", opName).replace("{perName}", removePerName);
            commonService.sendMessageToApp(MsgConst.TYPE_020114_TASK_REMOVE_PER_MANAGE_TITLE, content2, DictMessageTypeConst.MESSAGETYPE_020114, taskPers.toString(),
                    comTask.getComId(), comTask.getComTaskId());
        }
        return Result.success(Result.SUCCESS_MSG);
    }


    /**
     * 增加组员
     *
     * @param paramDTO
     * @return
     */
    @Override
    public Result addPer(ParamDTO paramDTO) {
        ComTask comTask = checkTask(paramDTO.getComTaskId());
        if (StringUtil.isEmpty(paramDTO.getIds())) {
            throw new BusinessException(Result.ERROR, "请选择人员");
        }
        List<String> perList = StrSplitter.split(paramDTO.getIds(), ",", true, true);
        /* 需要添加到关联人员这里 */
        packAndsaveTaskPer(paramDTO, null, comTask);
        /* 初始化排班信息 */
//        initTaskPerShift(comTask,null,perList);

        if (paramDTO.getCreateBy() != null) {

            /* 通知当事人 */
            String tilte = MsgConst.TYPE_020101_TASK_NEW_TITLE;// 标题
            String content = MsgConst.TYPE_020101_TASK_NEW_CONTENT; // 通知内容
            content = content.replace("{taskName}", comTask.getTaskName())
                    .replace("{taskStart}",
                            comTask.getStartDate() == null ? ""
                                    : DateUtils.formatDate(comTask.getStartDate(), "yyyy-MM-dd"))
                    .replace("{taskEnd}", comTask.getEndDate() == null ? ""
                            : DateUtils.formatDate(comTask.getEndDate(), "yyyy-MM-dd"))
                    .replace("{taskAddress}", comTask.getTaskAddress())
                    .replace("{taskContent}", comTask.getTaskContent());
            String perListStr = StringUtils.join(perList, ",");
            commonService.sendMessageToApp(tilte, content, DictMessageTypeConst.MESSAGETYPE_020101, perListStr, comTask.getComId(), comTask.getComTaskId());


            /* 通知管理员，负责人 */
            String operatePerName = perBaseInfoMapper.getNameById(paramDTO.getCreateBy());
            List<Map> chargeList = comTaskMapper.listTaskChargePerDetail(comTask.getComTaskId());
            StringBuilder taskPers = new StringBuilder();
            taskPers.append(String.valueOf(comTask.getCreateBy())).append(CommonConst.COMMA);
            for (Map map : chargeList) {
                taskPers.append(map.get("perId").toString()).append(CommonConst.COMMA);
            }
            String content2 = MsgConst.TYPE_020110_TASK_ADD_PER_MANAGE_CONTENT;
            StringBuilder addPerNameList = new StringBuilder();
            int loop = 0;
            for (String per : perList) {
                String addPerName = perBaseInfoMapper.getNameById(Long.parseLong(per));
                if (loop == 0) {
                    addPerNameList.append(addPerName);
                } else {
                    addPerNameList.append(",").append(addPerName);
                }
                loop++;
            }
            content2 = content2.replace("{taskName}", comTask.getTaskName()).replace("{operate}", operatePerName).replace("{perName}", addPerNameList.toString());
            commonService.sendMessageToApp(MsgConst.TYPE_020110_TASK_ADD_PER_MANAGE_TITLE, content2, DictMessageTypeConst.MESSAGETYPE_020110, taskPers.toString(),
                    comTask.getComId(), comTask.getComTaskId());
        }

        return Result.success(Result.SUCCESS_MSG);
    }


    /**
     * 保存任务周期
     *
     * @param paramDTO
     * @param dto
     * @param idWorker
     * @param comTask
     */
    private List<ComTaskSchedulCycle> saveTaskSchedule(ParamDTO paramDTO, AppComTaskContentDTO dto, IdWorker idWorker, ComTask comTask) {
        List<AppComTaskScheduleDTO> scheduleList = dto.getScheduleList();
        List<ComTaskSchedulCycle> cycleList = Lists.newArrayList();
        List<ComTaskCycleShift> cycleShiftList = Lists.newArrayList();
        for (AppComTaskScheduleDTO scheduleDTO : scheduleList) {
            ComTaskSchedulCycle cycle = new ComTaskSchedulCycle();
            cycle.setComId(paramDTO.getComId());
            cycle.setComTaskId(comTask.getComTaskId());
            cycle.setCycleDays(scheduleDTO.getCycleDays());
            cycle.setCycleName(scheduleDTO.getCycleName());
            cycle.setStartDate(DateUtil.parseDate(scheduleDTO.getStartDate()));
            cycle.setEndDate(DateUtil.parseDate(scheduleDTO.getEndDate()));
            cycle.setPerIds(scheduleDTO.getPerIds());
            cycle.setTaskSchedulCycleId(idWorker.nextId());
            cycleList.add(cycle);

            List<String> cycleShiftIdList = StrSplitter.split(scheduleDTO.getShiftIds(), CommonConst.COMMA, true, true);
            int whatDay = 1;
            for (String cycleShiftId : cycleShiftIdList) {
                ComTaskCycleShift shift = new ComTaskCycleShift();
                shift.setTaskSchedulCycleId(idWorker.nextId());
                shift.setComId(paramDTO.getComId());
                shift.setWhatDay(whatDay);
                shift.setIsRest("0".equals(cycleShiftId) ? CommonConst.Y : CommonConst.N);
                shift.setTaskSchedulCycleId(cycle.getTaskSchedulCycleId());
                shift.setShiftId(Long.parseLong(cycleShiftId));
                cycleShiftList.add(shift);
                whatDay++;
            }
        }
        comTaskSchedulCycleMapper.batchInsertComTaskSchedulCycle(cycleList);
        comTaskCycleShiftMapper.batchInsertComTaskCycleShift(cycleShiftList);
        return cycleList;
    }

    /**
     * 保存负责人
     *
     * @param paramDTO
     * @param idWorker
     * @param comTask
     */
    private void saveChargePer(ParamDTO paramDTO, IdWorker idWorker, ComTask comTask) {
        ComTaskChargeRecord comTaskChargeRecord = new ComTaskChargeRecord();
        comTaskChargeRecord.setComTaskChargeRecordId(idWorker.nextId());
        comTaskChargeRecord.setStartTime(comTask.getStartDate());
        comTaskChargeRecord.setEndTime(comTask.getEndDate());
        comTaskChargeRecord.setChargePerId(comTask.getChargePerId());
        comTaskChargeRecord.setComTaskId(comTask.getComTaskId());
        comTaskChargeRecord.setComId(paramDTO.getComId());
        comTaskMapper.addRecord(comTaskChargeRecord);
    }

    /**
     * 保存 任务对应的班次
     *
     * @param comId
     * @param shiftIds
     * @param comTaskId
     */
    private List<ComTaskShift> saveTaskShift(Long comId, String shiftIds, Long comTaskId) {
        List<ComTaskShift> taskShiftList = Lists.newArrayList();
        List<String> shiftIdList = StrSplitter.split(shiftIds, CommonConst.COMMA, true, true);
        for (String shiftId : shiftIdList) {
            ComTaskShift comTaskShift = new ComTaskShift();
            comTaskShift.setComId(comId);
            comTaskShift.setComTaskId(comTaskId);
            comTaskShift.setShiftId(Long.parseLong(shiftId));
            taskShiftList.add(comTaskShift);
        }
        if(taskShiftList.size() > 0) {
            comTaskShiftMapper.batchInsertComTaskShift(taskShiftList);
        }
        return taskShiftList;
    }

    /**
     * 保存 任务执行地址
     *
     * @param paramDTO
     * @param dto
     * @param idWorker
     * @param comTask
     */
    private void saveTaskAttendAddress(ParamDTO paramDTO, AppComTaskContentDTO dto, IdWorker idWorker,
                                       ComTask comTask) {
        List<ComTaskAttendAddress> addressList = Lists.newArrayList();
        for (AppComTaskAttendAddressDTO addressDTO : dto.getAttendAddressList()) {
            ComTaskAttendAddress address = new ComTaskAttendAddress();
            address.setTaskAttendAddressId(idWorker.nextId());
            address.setComId(paramDTO.getComId());
            address.setComTaskId(comTask.getComTaskId());
            address.setAddress(addressDTO.getSignAddress());
            address.setAddressLongitude(addressDTO.getSignAddressLongitude());
            if (StringUtil.isNotEmpty(addressDTO.getSignAddressLatitude())) {
                address.setAddressLatitude(addressDTO.getSignAddressLatitude());
            }
            address.setAddressRange(addressDTO.getSignAddressRange());
            addressList.add(address);
        }
        comTaskAttendAddressMapper.batchInsertAttendAddress(addressList);
    }

    /**
     * 保存任务相关人员
     *
     * @param paramDTO
     * @param dto
     * @param comTask
     */
    private List<ComTaskInsidePush> packAndsaveTaskPer(ParamDTO paramDTO, AppComTaskContentDTO dto, ComTask comTask) {
        List<String> perIdList = Lists.newArrayList();
        if (dto != null) {
            perIdList = StrSplitter.split(dto.getPerIds(), CommonConst.COMMA, true, true);
        } else {
            perIdList = StrSplitter.split(paramDTO.getIds(), CommonConst.COMMA, true, true);
        }
        if (perIdList.size() > 1000) {
            throw new BusinessException(Result.ERROR, "外勤人员人数上限为1000人");
        }
        return saveTaskPer(paramDTO.getComId(), comTask, perIdList);
    }

    private List<ComTaskInsidePush> saveTaskPer(Long comId, ComTask comTask, List<String> perIdList) {
        List<ComTaskInsidePush> listComTaskInsidePush = Lists.newArrayList();
        Date startDate = comTask.getStartDate();
		/* 如果任务开始日期早于当天，从当天开始算 */
        if (startDate.before(DateUtil.date())) {
            startDate = DateUtil.date();
        }
		/* 添加推送给给抄送人员 */
        for (String perId : perIdList) {
            ComTaskInsidePush comTaskInsidePush = new ComTaskInsidePush();
            comTaskInsidePush.setInsidePushId(idWorker.nextId());
            comTaskInsidePush.setPerId(Long.parseLong(perId));
            comTaskInsidePush.setPushPerType(DictConst.PUSHPERTYPE_CYRY);
            comTaskInsidePush.setCreateBy(comTask.getCreateBy());
            comTaskInsidePush.setComTaskId(comTask.getComTaskId());
            comTaskInsidePush.setComId(comId);
            comTaskInsidePush.setStartDate(startDate);
            comTaskInsidePush.setEndDate(comTask.getEndDate());
            listComTaskInsidePush.add(comTaskInsidePush);
        }
        if (CollectionUtil.isNotEmpty(listComTaskInsidePush)) {
            // 批量推送给给抄送人员
            int status3 = comTaskInsidePushMapper.insertComTaskInsidePushList(listComTaskInsidePush);
            if (status3 <= 0) {
                throw new BusinessException(Result.ERROR, "任务内部推送失败，请稍后重试");
            }
        }
        return listComTaskInsidePush;
    }


    private Map<Long, String> calcAliasAlphaMap(List<MultiDataDTO> shiftList) {
        Map<Long, String> shiftAliasAlphaMap = Maps.newHashMap();
        int index = 0;
		/* 设置班次的别名 如 A B C */
        if (CollectionUtil.isNotEmpty(shiftList)) {
            for (MultiDataDTO dataMap : shiftList) {
                shiftAliasAlphaMap.put(dataMap.getShiftId(), SHIFT_ALIAS_ALPHA_ARRAY[index]);
                index++;
            }
        }
        return shiftAliasAlphaMap;
    }


    private void convertAliasMap(List<MultiDataDTO> shiftList) {
        int index = 0;
		/* 设置班次的别名 如 班次A：9：00~10：00 班次B：9：00~10：00 */
        if (CollectionUtil.isNotEmpty(shiftList)) {
            for (MultiDataDTO dataMap : shiftList) {
                String workTimeStr = commonService.listChangeToString(dataMap.getShiftId(), false, false);
                dataMap.setShiftAlias("（" + SHIFT_ALIAS_ALPHA_ARRAY[index] + "）" + dataMap.getShiftName() + CommonConst.COLON_CN + workTimeStr);
                dataMap.setExtra(SHIFT_ALIAS_ALPHA_ARRAY[index]);
                index++;
            }
        }
    }

    /**
     * 检查任务信息
     *
     * @param comTaskId 任务ID
     * @return ComTask 任务
     * @throws BusinessException The custom exception, contains bussness message.
     * @date 2017/12/26 13:59
     */
    private ComTask checkTask(Long comTaskId) throws BusinessException {
        // 检查任务id是否为空，为了预防空指针异常
        if (Objects.isNull(comTaskId)) {
            throw new BusinessException(Result.ERROR, "任务ID不可以为空");
        }
        // 检查任务是否存在
        ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskId);
        if (comTask == null) {
            throw new BusinessException(Result.ERROR, "任务不存在");
        }
        return comTask;
    }

    //private String validatePerShiftCycle(){
    //    List<String> idList = StrSplitter.split(paramDTO.getPerIds(),CommonConst.COMMA,true,true);
    //    List<String> conflictList = comTaskPerShiftService.validateShiftDateConflict(paramDTO.getIds(),paramDTO.getDate(),idList,paramDTO.getComTaskId(),paramDTO.getComId());
    //    if (CollectionUtil.isNotEmpty(conflictList)) {
    //        return Result.fail("人员排班有冲突",conflictList);
    //    }
    //}

    /**
     * 初始化该任务所有的排班记录，周期排班
     */
    private void initTaskPerShiftCycle(ComTask comTask, List<ComTaskSchedulCycle> cycleList) {
        if (CollUtil.isEmpty(cycleList)) {
            return;
        }
        List<MultiDataDTO> cycleShiftList = comTaskCycleShiftMapper.getTaskCycleShiftByList(cycleList);
        Multimap<Long, MultiDataDTO> cycleShiftMap = ArrayListMultimap.create();
        for (MultiDataDTO dto : cycleShiftList) {
            cycleShiftMap.put(dto.getId(), dto);
        }
        /* 循环所有的周期并进行排班 */
        packShiftCycle(comTask, cycleList, cycleShiftMap, null);
    }

    /**
     * 循环周期并进行排班
     *
     * @param comTask
     * @param cycleList
     * @param cycleShiftMap
     * @param appointCyclePerIds 指定周期人员，如果有指定，则将周期中的人员换成指定人员进行循环
     */
    private void packShiftCycle(ComTask comTask, List<ComTaskSchedulCycle> cycleList, Multimap<Long, MultiDataDTO> cycleShiftMap, List<String> appointCyclePerIds) {
        Map<String, List<ComShiftRule>> ruleMap = Maps.newHashMap();
        List<ComTaskImplement> implementList = Lists.newArrayList();
        List<ComTaskSchedul> taskScheduleList = Lists.newArrayList();
        for (ComTaskSchedulCycle cycle : cycleList) {
            /* 如果任务开始日期早于当天，从当天开始算 */
            Date startDate = cycle.getStartDate();
            if (cycle.getStartDate().before(DateUtil.date())) {
                startDate = DateUtil.date();
            }
            /* 获得周期的人 */
            List<String> perIdList = Lists.newArrayList();
            if (CollectionUtil.isEmpty(appointCyclePerIds)) {
                String perIds = cycle.getPerIds();
                perIdList = StrSplitter.split(perIds, CommonConst.COMMA, true, true);
            } else {
                /* 指定周期人员，如果有指定，则将周期中的人员换成指定人员进行循环 */
                perIdList = appointCyclePerIds;
            }
            /* 获得周期的开始结束阶段 */
            List<String> dateList = DateUtils.getBetweenDatesByDate(startDate, cycle.getEndDate());
            Collection<MultiDataDTO> shiftList = cycleShiftMap.get(cycle.getTaskSchedulCycleId());
            int loop = 1;
            int resetDay = 0;
            for (String date : dateList) {
                /* 如果已经大于第一轮排班了，则重置轮次 */
                if (loop > cycle.getCycleDays()) {
                    resetDay = loop % cycle.getCycleDays();
                    /* 刚好除尽，说明是最后一天，需要拿最后一天 */
                    if (resetDay == 0) {
                        resetDay = cycle.getCycleDays();
                    }
                } else {
                    resetDay++;
                }
                /* 获得当前天对应周期的天数和班次 */
                String shiftId = "";
                for (MultiDataDTO dataDTO : shiftList) {
                    if (dataDTO.getWhatDay().equals(resetDay + "")) {
                        shiftId = dataDTO.getShiftId() + "";
                        break;
                    }
                }
				/* 休息日，插入休息日的数据 */
                if (StrUtil.isEmpty(shiftId) || "null".equals(shiftId)) {
                    for (String perId : perIdList) {
                        ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, comTask.getComId(), comTask.getComTaskId(), Long.parseLong(perId),
                                date, null, null, DictConst.ATTENDTYPE_PBZ, PublicConst.Y, comTask.getCreateBy());
                        ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, comTask.getComId(), comTask.getComTaskId(), Long.parseLong(perId),
                                date, null, PublicConst.Y);
                        implementList.add(obj);
                        taskScheduleList.add(obj2);
                    }
                }
                /* 非休息日的情况 */
                else {
                    /* 同时插入轮次，如果一个班次有多个轮次，则插入多条记录 */
                    if (CollectionUtil.isEmpty(ruleMap.get(shiftId))) {
                        List<ComShiftRule> shiftRuleList = comShiftRuleMapper
                                .getShiftRuleByShiftId(Long.parseLong(shiftId));
                        ruleMap.put(shiftId, shiftRuleList);
                    }
                    List<ComShiftRule> shiftRuleList = ruleMap.get(shiftId);
                    /* 遍历周期所有人 */
                    for (String perId : perIdList) {
                        for (ComShiftRule shiftRule : shiftRuleList) {
					        /* 重新插入新的排班情况 */
                            ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, comTask.getComId(), comTask.getComTaskId(), Long.parseLong(perId),
                                    date, shiftId, shiftRule.getShiftRuleId(), DictConst.ATTENDTYPE_PBZ, PublicConst.N,
                                    comTask.getCreateBy());
                            implementList.add(obj);
                        }
                        ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, comTask.getComId(), comTask.getComTaskId(), Long.parseLong(perId),
                                date, shiftId, PublicConst.N);
                        taskScheduleList.add(obj2);
                    }
                }
                loop++;
            }
        }

         /* 批量插入 */
        if (CollectionUtil.isNotEmpty(taskScheduleList)) {
            comTaskSchedulMapper.insertBatch(taskScheduleList);
        }

        if (CollectionUtil.isNotEmpty(implementList)) {
            comTaskImplementMapper.insertBatch(implementList);
        }
    }

    /**
     * 初始化该任务所有的排班记录，仅限第一次保存的人员
     */
    private void initTaskPerShift(ComTask comTask, List<ComTaskInsidePush> perList, List<String> perList2) {
        if (CollUtil.isEmpty(perList) && CollUtil.isEmpty(perList2)) {
            return;
        }
        List<ComTaskImplement> implementList = Lists.newArrayList();
        List<ComTaskSchedul> taskScheduleList = Lists.newArrayList();

        Date startDate = comTask.getStartDate();
        Date endDate = comTask.getEndDate();

		/* 如果任务开始日期早于当天，从当天开始算 */
        if (startDate.before(DateUtil.date())) {
            startDate = DateUtil.date();
        }
        List<String> dateList = DateUtils.getBetweenDatesByDate(startDate, endDate);

		/* 拿到人员，进行排班 */
        if (CollectionUtil.isNotEmpty(perList)) {
            for (ComTaskInsidePush per : perList) {
                for (String date : dateList) {
                    ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, comTask.getComId(),
                            comTask.getComTaskId(), per.getPerId(), date, null, null, DictConst.ATTENDTYPE_PBZ,
                            PublicConst.Y, comTask.getCreateBy());
                    ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, comTask.getComId(),
                            comTask.getComTaskId(), per.getPerId(), date, null, PublicConst.Y);
                    implementList.add(obj);
                    taskScheduleList.add(obj2);
                }
            }
        }

        if (CollectionUtil.isNotEmpty(perList2)) {
            for (String per : perList2) {
                for (String date : dateList) {
                    ComTaskImplement obj = comTaskPerShiftService.packComTaskImplement(idWorker, comTask.getComId(),
                            comTask.getComTaskId(), Long.parseLong(per), date, null, null, DictConst.ATTENDTYPE_PBZ,
                            PublicConst.Y, comTask.getCreateBy());
                    ComTaskSchedul obj2 = comTaskPerShiftService.packComTaskSchedule(idWorker, comTask.getComId(),
                            comTask.getComTaskId(), Long.parseLong(per), date, null, PublicConst.Y);
                    implementList.add(obj);
                    taskScheduleList.add(obj2);
                }
            }
        }

		/* 批量插入 */
        if (CollectionUtil.isNotEmpty(taskScheduleList)) {
            comTaskSchedulMapper.insertBatch(taskScheduleList);
        }

        if (CollectionUtil.isNotEmpty(implementList)) {
            comTaskImplementMapper.insertBatch(implementList);
        }

    }


    /**
     * 外勤月度出勤情况
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-02-22
     */
    @Override
    public Result getTaskMonthAttendInfo(ParamDTO dto) throws BusinessException {

        /*** 查询外勤统计信息***/
        List<Map<String, String>> taskStatisList = countPerTaskDateMapper.getTaskMonthStatisList(dto.getComTaskId(), dto.getComId(), dto.getMonth());
        Map<String, Object> result = new LinkedHashMap<>();
        result.put("taskStatisList", taskStatisList);// 外勤月度统计列表
        return Result.success(Result.SUCCESS_QUERY_MSG, result);
    }

    /**
     * 获取某天任务出勤人员
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-02-25
     */
    @Override
    public Result getTaskAttendPerDate(ParamDTO dto) throws BusinessException {

        /*** 查询外勤出勤人员 ***/
        List<Map<String, String>> attendPerList = countPerTaskDateMapper.getTaskAttendPerDate(dto.getComTaskId(), dto.getComId(), dto.getDate());
        Map<String, Object> result = new LinkedHashMap<>();
        result.put("attendPerList", attendPerList);// 外勤出勤人员列表
        return Result.success(Result.SUCCESS_QUERY_MSG, result);
    }


    public static void main(String[] args) {
        AppComTaskContentDTO dto = new AppComTaskContentDTO();
        dto.setTaskName("罗鹏创建的外勤任务2");
        dto.setTaskType("01000301");
        dto.setAddress("软件园三期");
        dto.setProvince(350000);
        dto.setCity(350200);
        dto.setArea(350211);
        dto.setAddressLatitude("24.607542");
        dto.setAddressLongitude("118.051982");
        dto.setExecRange(1000L);
        dto.setStartDate("2019-01-01");
        dto.setEndDate("2019-01-10");
        dto.setTaskDetail("我是任务内容2");
        dto.setShiftIds("491616733895852032,0,491617451369299968");
        dto.setPerIds("491619615730827264,494090617819758592,494090946783215616");
        dto.setInChargePerId(491255203043999744L);

        List<AppComTaskAttendAddressDTO> attendAddressList = Lists.newArrayList();
        AppComTaskAttendAddressDTO dto1 = new AppComTaskAttendAddressDTO();
        dto1.setSignAddress("厦门市软件园三期");
        dto1.setSignAddressLatitude("24.607542");
        dto1.setSignAddressLongitude("118.051982");
        dto1.setSignAddressRange(1000L);
        attendAddressList.add(dto1);
        dto.setAttendAddressList(attendAddressList);

        AppComTaskScheduleDTO dto2 = new AppComTaskScheduleDTO();
        dto2.setPerIds("491619615730827264,494090617819758592,494090946783215616");
        dto2.setStartDate("2019-02-26");
        dto2.setEndDate("2019-03-31");
        dto2.setCycleDays(3);
        dto2.setCycleName("我是周期的名称");
        dto2.setShiftIds("491616733895852032,0,491617451369299968");

        dto.setScheduleList(Lists.newArrayList(dto2));

        Console.log(JSON.toJSONString(dto));

        ParamDTO paramDTO = new ParamDTO();
        paramDTO.setMonth("2019-01");
        Date correctStartDate = DateUtil.offsetMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01"), -1);
        Date correctEndDate = DateUtil.endOfMonth(DateUtil.offsetMonth(DateUtil.parseDate(paramDTO.getMonth() + "-01"), 1));
        Console.log(DateUtil.formatDate(correctStartDate));
        Console.log(DateUtil.formatDate(correctEndDate));
    }
}