package com.bcxin.oa.old.service.task.html;

import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.common.Result;

/**
 * APP任务列表
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
public interface HtmlComTaskService {

    /**
     * 发布外勤任务
     * @param paramDTO
     * @return
     */
    Result publishTask(ParamDTO paramDTO);

    /**
     * 修改外勤任务
     * @param paramDTO
     * @return
     */
    Result updateTask(ParamDTO paramDTO);

    /**
     * 修改周期详情
     * @return
     */
    Result updateCycle(ParamDTO paramDTO);

    /**
     * 修改班次
     * @param paramDTO
     * @return
     */
    Result updateShift(ParamDTO paramDTO);

    /**
     * 外勤任务列表（我发布的）
     * @param paramDTO
     * @return
     */
    Result listTaskCreatePage(ComTaskDto dto);

    /**
     *  外勤任务列表（我负责的）
     * @param paramDTO
     * @return
     */
    Result listTaskChargePage(ComTaskDto dto);

    /**
     * 取消外勤
     * @param paramDTO
     * @return
     */
    Result cancelTask(ParamDTO paramDTO);
    /**
     * 任务详细信息
     * @param paramDTO
     * @return
     */
    Result taskDetail(ParamDTO paramDTO);

    /**
     * 周期详细信息
     * @param paramDTO
     * @return
     */
    Result cycleDetail(ParamDTO paramDTO);

    /**
     * 排班日历（总览）
     * @param paramDTO
     * @return
     */
    Result taskCalendarGeneral(ParamDTO paramDTO);

    /**
     * 排班日历（总览）
     * 点击某一天，查找当天的班次，以及班次对应的人员
     * @param paramDTO
     * @return
     */
    Result taskDayShift(ParamDTO paramDTO);

    /**
     * 排班日历（个人）
     * 点击某个月，某个人，查找当月的所有班次
     * @param paramDTO
     * @return
     */
    Result taskPerCalendarGeneral(ParamDTO paramDTO);

    /**
     * 排班日历（个人） 查找任务对应的班次
     * @param paramDTO
     * @return
     */
    Result taskShift(ParamDTO paramDTO);

    /**
     * 个人当天排班（校验）
     * @param paramDTO
     * @return
     */
    Result validatePerShift(ParamDTO paramDTO);


    /**
     * 个人当天排班（插入）
     * @param paramDTO
     * @return
     */
    Result perShiftInDB(ParamDTO paramDTO);

    /**
     * 获得任务组员
     * @param paramDTO
     * @return
     */
    Result taskPer(ParamDTO paramDTO);

    /**
     * 获得任务负责人
     * @param paramDTO
     * @return
     */
    Result taskChargePer(ParamDTO paramDTO);

    /**
     * 移除组员
     * @param paramDTO
     * @return
     */
    Result removePer(ParamDTO paramDTO);

    /**
     * 增加组员
     * @param paramDTO
     * @return
     */
    Result addPer(ParamDTO paramDTO);


    /**
     * 任务月度出勤情况
     * @param paramDTO
     * @return
     * @author llc
     * @date 2019-02-22
     * @return
     */
    Result getTaskMonthAttendInfo(ParamDTO paramDTO);

    /**
     * 获取某天任务出勤人员
     * @param paramDTO
     * @return
     * @author llc
     * @date 2019-02-25
     * @return
     */
    Result getTaskAttendPerDate(ParamDTO paramDTO);
}