package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

import java.util.Map;

/**
 * 任务执行情况表
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskImplementService {


    /**
     * 获取任务执行情况表
     *
     * @param comTaskImplementDto
     * @return
     */
    Result listAttendanceRecord(ComTaskImplementDto comTaskImplementDto) throws BusinessException;


    /**
     * 获取任务日志
     *
     * @param comTaskFeedbackParamDto
     * @return
     */
    Result listTaskLog(ComTaskFeedbackParamDto comTaskFeedbackParamDto) throws BusinessException;

    /**
     * 定时器生成任务执行情况
     *
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/03/13
     */
    Result runTaskImplement() throws BusinessException;


    /**
     * 任务出勤记录-查看轨迹
     *
     * @param comTaskTrackPageParamDto
     * @return
     */
    Result showTrack(ComTaskTrackPageParamDto comTaskTrackPageParamDto) throws BusinessException;


    /**
     * APP-查询任务轨迹
     *
     * @param comTaskImplementDto
     * @return
     * @author zhangjianhua
     * @date 2018/03/14
     */
    Result listTaskTrack(ComTaskImplementDto comTaskImplementDto) throws BusinessException;


    /**
     * 获取状态
     *
     * @param comTaskImplementDto
     * @return
     */
    Result attendanceStatus(ComTaskImplementDto comTaskImplementDto);

    /**
     * 任务-发布设置-固定排班-校验人员是否有排班冲突（第三步）
     *
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/03/26
     */
    Map<String, String> checkPerImplement(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;

    /**
     * 任务执行情况信息
     *
     * @param multiDataDTO
     * @return
     */
    Result listTaskImplement(MultiDataDTO multiDataDTO);

    /**
     * 出勤情况列表
     *
     * @param multiDataDTO
     * @return
     */
    Result listImplement(MultiDataDTO multiDataDTO);

    /**
     * 查询任务轨迹最近出勤月份
     * @param multiDataDTO
     * @return
     */
    Result selectImplementMonth(MultiDataDTO multiDataDTO);
}