package com.bcxin.oa.old.service.task;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.ComShiftMapper;
import com.bcxin.oa.old.mapper.ComShiftRuleMapper;
import com.bcxin.oa.old.entity.task.ComShift;
import com.bcxin.oa.old.entity.task.ComShiftRule;
import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 企业班次
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
@Service
@Transactional
public class ComShiftServiceImpl implements ComShiftService {
	@Resource
	private ComShiftMapper comShiftMapper;
	@Resource
	private ComShiftRuleMapper comShiftRuleMapper;
	@Resource
	private IdWorker idWorker;
	@Resource
	private BbdTestService bbdTestService;

	@Override
	public Result pageForShift(ComShiftDto comShiftDto) {
		PageHelper.startPage(comShiftDto.getPageNumber(), comShiftDto.getPageSize());
		List<Map<String, String>> shiftList = comShiftMapper.pageForShift(comShiftDto);
		return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(shiftList));
	}

	@Override
	public Result delete(ComShiftDto comShiftDto) throws BusinessException {

		if (comShiftDto.getShiftId() == null || comShiftDto.getShiftId().toString() == "") {
			throw new BusinessException(Result.ERROR, "班次ID不能为空");
		}
		// TODO 先获取shiftType
		ComShift comShift = comShiftMapper.getByPrimaryKey(comShiftDto.getShiftId());
		if (StringUtil.isEmpty(comShift.getShiftType())) {
			throw new BusinessException(Result.ERROR, "班次类型不能为空");
		}
		String shiftMessage;
		if (comShift.getShiftType().equalsIgnoreCase(DictConst.SHIFTTYPE_RWBC)) {
			comShiftDto.setIsOnlyCheckEffect(CommonConst.N);
			shiftMessage = this.checkTaskShift(comShiftDto);

		} else {
			shiftMessage = this.checkAttenpShift(comShiftDto);

		}
		if (StringUtils.isNotEmpty(shiftMessage)) {
			throw new BusinessException(Result.ERROR, shiftMessage);
		}
//		List<ComShiftRule> ruleList = comShiftRuleMapper.getShiftRuleByShiftId(comShiftDto.getShiftId());
		comShiftMapper.deleteByPrimaryKey(comShiftDto.getShiftId());
		comShiftRuleMapper.deleteByShiftId(comShiftDto.getShiftId());

		/*** 只有驻勤班次才需要同步百保盾 ***/

//		if(ObjectUtils.equals(DictConst.SHIFTTYPE_RWBC,comShiftDto.getShiftType())) {
//			bbdTestService.bbdDeleteComTaskShift(comShiftDto);
//		}

		return Result.success(Result.SUCCESS_MSG, "删除成功");
	}

	private String checkTaskShift(ComShiftDto comShiftDto) {
		// 考勤班次
		List<String> taskNamelist;
		taskNamelist = comShiftMapper.countForShift(comShiftDto);
		return this.returnShiftMessage("该班次已经被任务使用，任务为：\n", taskNamelist);
	}

	private String returnShiftMessage(String notice, List<String> namelist) {
		String shiftMessage = "";
		StringBuilder names = new StringBuilder();
		if (namelist.size() > 0) {
			for (int i = 0; i < namelist.size(); i++) {
				names.append(i + 1);
				names.append(".");
				names.append(namelist.get(i));
				names.append("\n");
			}

			shiftMessage = notice + names.substring(0, names.length() - 1).toString();
		}
		return shiftMessage;
	}

	private String checkAttenpShift(ComShiftDto comShiftDto) {
		// 考勤班次
		List<String> attendGroupNamelist = comShiftMapper.getAttendGroupListByShiftId(comShiftDto.getShiftId(),
				comShiftDto.getComId());
		return this.returnShiftMessage("该班次已经被考勤组使用，考勤组为：", attendGroupNamelist);
	}

	/**
	 * 校验添加班次或编辑班次
	 *
	 * @param shiftDto
	 */
	private void checkShift(ComShiftDto shiftDto) throws BusinessException {
		// 一天上下班次数不超过24次
		int maxCommutTimes = 24;
		// 班次名称限制15个汉字
		int msxShiftNameLen = 15;
		// 判断班次名称是否为空
		if (StringUtils.isBlank(shiftDto.getShiftName())) {
			throw new BusinessException(Result.ERROR, "班次名称不能为空");
		}
		// 判断班次名称长度
		if (shiftDto.getShiftName().length() > msxShiftNameLen) {
			throw new BusinessException(Result.ERROR, "班次名称长度不得超过15个字");
		}
		// 判断一天上下班次数是否为空
		if (shiftDto.getCommutTimes() <= 0) {
			throw new BusinessException(Result.ERROR, "一天上下班次数不能为空");
		}
		// 判断一天上下班次数是否小于1次
		if (shiftDto.getCommutTimes() < 1) {
			throw new BusinessException(Result.ERROR, "一天上下班次数不能小于1次");
		}
		// 判断一天上下班次数是否超过24次
		if (shiftDto.getCommutTimes() > maxCommutTimes) {
			throw new BusinessException(Result.ERROR, "一天上下班次数不能超过24次");
		}
		// 判断上下班轮数是否为空
		if (shiftDto.getShiftRuleList() == null || shiftDto.getShiftRuleList().isEmpty()) {
			throw new BusinessException(Result.ERROR, "上下班轮数不能为空");
		}
		// 判断上下班轮数是否等于一天上下班次数
		if (shiftDto.getShiftRuleList().size() != shiftDto.getCommutTimes()) {
			throw new BusinessException(Result.ERROR, "上下班轮数不等于一天上下班次数");
		}

		// 判断上班时间或下班时间是否为空
		for (ComShiftRule dto : shiftDto.getShiftRuleList()) {
			if (dto.getStartWorkTime() == null || dto.getEndWorkTime() == null) {
				throw new BusinessException(Result.ERROR, "上班时间或下班时间不能为空");
			}
		}

		List<Date> validateList = Lists.newLinkedList();
		// 判断上班时间是否大于下班时间
		int loop = 1;
		for (ComShiftRule dto : shiftDto.getShiftRuleList()) {
			/* 下班时间是当天，需要校验； 下班时间是次日，所有下班时间都会大于上班时间*/
			if ( "0".equals(dto.getIsEndNextDay()) ) {
				if ( dto.getStartWorkTime().compareTo(dto.getEndWorkTime()) >= 0) {
					throw new BusinessException(Result.ERROR, "上班时间不得大于或等于下班时间");
				}
			}
			/* 如果出现跨日的班次，必须是最后一条，否则抛出异常 */
			if ( "1".equals(dto.getIsEndNextDay()) && loop != shiftDto.getShiftRuleList().size()) {
				throw new BusinessException(Result.ERROR, "下班时间为次日时，必须是最后一轮的轮次");
			}
			/* 下面会有跨轮次的上下班校验，先进行存储 */
			if (loop == 1) {
				validateList.add(dto.getEndWorkTime());
			} else {
				validateList.add(dto.getStartWorkTime());
				validateList.add(dto.getEndWorkTime());
			}
			loop++;
		}

		/* 判断第二轮的上班时间要大于第一轮下班时间 */
		for (int i=0;i<validateList.size();i=i+2) {
			/* 上一轮的下班时间 */
			Date offDuty = validateList.get(i);
			if (validateList.size() > (i+1)) {
				/* 本轮的上班时间 */
				Date onDuty = validateList.get(i+1);
				if (onDuty == null) {
					break;
				}
				/* 上一轮的下班时间晚于本轮的上班时间，则提示 */
				if (offDuty.compareTo(onDuty) >=0 ) {
					throw new BusinessException(Result.ERROR, "下轮次上班时间需晚于上一轮的下班时间，请重新选择");
				}
			}
		}

		// 判断上下班时间是否存在交错
		Map<String, List<Date>> timeMap = new HashMap<>();
		for (ComShiftRule dto : shiftDto.getShiftRuleList()) {
			String timeKey = UUID.randomUUID().toString().replaceAll("-", "");
			Date startWorkTime = dto.getStartWorkTime();
			Date endWorkTime = dto.getEndWorkTime();
			List<Date> timeList = new ArrayList<>();
			timeList.add(startWorkTime);
			timeList.add(endWorkTime);
			timeMap.put(timeKey, timeList);
		}
		for (String key1 : timeMap.keySet()) {
			Date startWorkTime1 = timeMap.get(key1).get(0);
			Date endWorkTime1 = timeMap.get(key1).get(1);
			for (String key2 : timeMap.keySet()) {
				if (key1.equals(key2)) {
					continue;
				}
				Date startWorkTime2 = timeMap.get(key2).get(0);
				Date endWorkTime2 = timeMap.get(key2).get(1);
				if (startWorkTime1.compareTo(endWorkTime2) == -1 && endWorkTime1.compareTo(endWorkTime2) == 1) {
					throw new BusinessException(Result.ERROR, "上下班时间存在交错");
				}
				if (startWorkTime1.compareTo(startWorkTime2) == -1 && endWorkTime1.compareTo(startWorkTime2) == 1) {
					throw new BusinessException(Result.ERROR, "上下班时间存在交错");
				}
				if (startWorkTime1 == startWorkTime2 && endWorkTime1 == endWorkTime2) {
					throw new BusinessException(Result.ERROR, "上下班时间存在交错");
				}
			}
		}

		// 判断上下班时间段限制：总时长不超过24小时，如第1轮上班时间为09:00，则第n轮结束时间不得超过次日的08:59
		int[] startMinutesArr = new int[0];
		int[] endMinutesArr = new int[0];
		for (ComShiftRule dto : shiftDto.getShiftRuleList()) {
			SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
			// 将时间转化成字符串
			String startWorkTime = sdf.format(dto.getStartWorkTime());
			String endWorkTime = sdf.format(dto.getEndWorkTime());
			int startHours = Integer.parseInt(startWorkTime.split(":")[0]);
			int startMinutes = Integer.parseInt(startWorkTime.split(":")[1]);
			int endHours = Integer.parseInt(endWorkTime.split(":")[0]);
			int endMinutes = Integer.parseInt(endWorkTime.split(":")[1]);
			startMinutes += startHours * 60;
			endMinutes += endHours * 60;
			// 数组扩容
			startMinutesArr = Arrays.copyOf(startMinutesArr, startMinutesArr.length + 1);
			// 数组扩容
			endMinutesArr = Arrays.copyOf(endMinutesArr, endMinutesArr.length + 1);
			startMinutesArr[startMinutesArr.length - 1] = startMinutes;
			endMinutesArr[endMinutesArr.length - 1] = endMinutes;
		}
		// 数组排序，从小到大
		Arrays.sort(startMinutesArr);
		Arrays.sort(endMinutesArr);
		// 一天有几分钟
		int duration = 24 * 60;
		// 最后一轮下班时间 - 第一轮上班时间，以分钟为单位
		int minutes = endMinutesArr[endMinutesArr.length - 1] - startMinutesArr[0];
		if (minutes > duration) {
			throw new BusinessException(Result.ERROR, "第一轮上班时间到最后一轮下班时间总时长不得超过24个小时");
		}

		// 校验迟到x分钟
		if (ComShiftDto.COMM_TRUE.equals(shiftDto.getPermitLateSwitch())) {
			if ((Integer) shiftDto.getPermitLateUp() == null) {
				throw new BusinessException(Result.ERROR, "迟到x分钟不能为空");
			}
			if (shiftDto.getPermitLateUp() < 0) {
				throw new BusinessException(Result.ERROR, "迟到x分钟不能小于0");
			}
		} else {
			shiftDto.setPermitLateUp(0);
			shiftDto.setPermitLateSwitch(ComShiftDto.COMM_FALSE);
		}

		//// 校验严重迟到x分钟
		// if (ComShiftDto.COMM_TRUE.equals(shiftDto.getSeriousLateSwitch())) {
		// if ((Integer) shiftDto.getSeriousLateLow() == null) {
		// throw new BusinessException(Result.ERROR, "严重迟到x分钟不能为空");
		// }
		// if (shiftDto.getSeriousLateLow() < 0) {
		// throw new BusinessException(Result.ERROR, "严重迟到x分钟不能小于0");
		// }
		// } else {
		// shiftDto.setSeriousLateLow(0);
		// shiftDto.setSeriousLateSwitch(ComShiftDto.COMM_FALSE);
		// }

		// 校验旷工x分钟
		if (ComShiftDto.COMM_TRUE.equals(shiftDto.getAbsentSwitch())) {
			if ((Integer) shiftDto.getAbsentLow() == null) {
				throw new BusinessException(Result.ERROR, "旷工x分钟不能为空");
			}
			if (shiftDto.getAbsentLow() < 0) {
				throw new BusinessException(Result.ERROR, "旷工x分钟不能小于0");
			}
		} else {
			shiftDto.setAbsentLow(0);
			shiftDto.setAbsentSwitch(ComShiftDto.COMM_FALSE);
		}
		// 校验打卡时限
		if (ComShiftDto.COMM_TRUE.equals(shiftDto.getClockLimitSwitch())) {
			if (shiftDto.getClockWorkLimit() == null) {
				throw new BusinessException(Result.ERROR, "打卡时限不能为空");
			}
			if (shiftDto.getClockWorkLimit() < 0) {
				throw new BusinessException(Result.ERROR, "打卡时限不能小于0");
			}
		} else {
			shiftDto.setClockWorkLimit(0);
			shiftDto.setClockLimitSwitch(ComShiftDto.COMM_FALSE);
		}

	}

	/**
	 * 拼接班次规则
	 *
	 * @param shiftDto
	 */
	private String jointShiftRule(ComShiftDto shiftDto) {
		String shiftRuleDetail = "";
		if (shiftDto.getShiftRuleList() != null && shiftDto.getShiftRuleList().size() > 0) {
			for (ComShiftRule comShiftRule : shiftDto.getShiftRuleList()) {
				SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
				// 将时间转化成字符串
				String startWorkTime = sdf.format(comShiftRule.getStartWorkTime());
				String endWorkTime = sdf.format(comShiftRule.getEndWorkTime());
				if (startWorkTime != null || endWorkTime != null) {
					if (comShiftRule.getIsStartNextDay().equals(CommonConst.Y)) {
						startWorkTime = "<span style=\"color:#F5222E\">次日</span>" + startWorkTime;
					}

					if (comShiftRule.getIsEndNextDay().equals(CommonConst.Y)) {
						endWorkTime = "<span style=\"color:#F5222E\">次日</span>" + endWorkTime;
					}
				}
				if (shiftRuleDetail != null) {
					shiftRuleDetail = shiftRuleDetail + startWorkTime + "-" + endWorkTime + " | ";
				} else {
					shiftRuleDetail = startWorkTime + "-" + endWorkTime + " | ";
				}

			}
			shiftRuleDetail = shiftRuleDetail.substring(0, shiftRuleDetail.length() - 2);

		}
		return shiftRuleDetail;
	}

	/**
	 * 添加班次规则
	 *
	 * @param shiftDto
	 */
	private Result addShiftRule(ComShiftDto shiftDto) {
		int i = 1;
		List<ComShiftRule> shiftRuleList = new ArrayList<>();
		for (ComShiftRule comShiftRule : shiftDto.getShiftRuleList()) {
			Long shiftRuleId = idWorker.nextId();
			comShiftRule.setShiftRuleId(shiftRuleId);
			comShiftRule.setComId(shiftDto.getComId());
			comShiftRule.setCreateTime(shiftDto.getCreateTime());
			comShiftRule.setCreateBy(shiftDto.getCreateBy());
			comShiftRule.setShiftId(shiftDto.getShiftId());;
			comShiftRule.setCommutRound(i);
			i++;
			shiftRuleList.add(comShiftRule);
			// 添加班次规则
			comShiftRuleMapper.insert(comShiftRule);
		}

		/*** 只有驻勤班次才需要同步百保盾 ***/

		if(ObjectUtils.equals(DictConst.SHIFTTYPE_RWBC,shiftDto.getShiftType())) {
			bbdTestService.bbdSaveComTaskShift(shiftDto, shiftRuleList);
		}
		return Result.success(Result.SUCCESS_MSG);

	}

	@Override
	public Result addShift(ComShiftDto comShiftDto) throws BusinessException {
		JSON.DEFFAULT_DATE_FORMAT = "HH:mm";
		comShiftDto.setShiftRuleList(JSON.parseArray(comShiftDto.getShiftRuleJson(), ComShiftRule.class));

		// 班次校验
		this.checkShift(comShiftDto);
		Long shiftId = idWorker.nextId();
		comShiftDto.setShiftId(shiftId);
		// 冗余字段 班次规则详情
		comShiftDto.setShiftRuleDetail(this.jointShiftRule(comShiftDto));
		comShiftDto.setEffectStartTime(comShiftDto.getCreateTime());
		if (comShiftMapper.findShiftNameRepetition(comShiftDto) > 0) {
			throw new BusinessException(Result.ERROR, "班次名称重复");
		}
		// 添加班次
		comShiftMapper.insert(comShiftDto);
		// 添加班次规则
		this.addShiftRule(comShiftDto);

		return Result.success(Result.SUCCESS_MSG);
	}

	@Override
	public Result updateShift(ComShiftDto comShiftDto) throws BusinessException {
		Long oldShiftID = comShiftDto.getShiftId();
		comShiftDto.setOldShiftId(oldShiftID);
		// 上一秒日期
		JSON.DEFFAULT_DATE_FORMAT = "HH:mm";
		comShiftDto.setShiftRuleList(JSON.parseArray(comShiftDto.getShiftRuleJson(), ComShiftRule.class));
		// 班次校验
		this.checkShift(comShiftDto);
		// todo 百保盾 先删除之前班次
//		List<ComShiftRule> ruleList = comShiftRuleMapper.getShiftRuleByShiftId(comShiftDto.getShiftId());
//		bbdTestService.bbdDeleteCompanySchedule(comShiftDto, ruleList);

		Long shiftId = idWorker.nextId();
		comShiftDto.setShiftId(shiftId);

		// 冗余字段 班次规则详情
		comShiftDto.setShiftRuleDetail(this.jointShiftRule(comShiftDto));
		comShiftDto.setUpdateTime(new Date());
		// ShiftDto.EFFECT_RULE_TODAY：生效规则今天，ShiftDto.EFFECT_RULE_TOMORROW：生效规则明天
		if (ComShiftDto.EFFECT_RULE_TODAY.equals(comShiftDto.getEffectRule())) {
			comShiftDto.setEffectStartTime(new Date());
		} else if (ComShiftDto.EFFECT_RULE_TOMORROW.equals(comShiftDto.getEffectRule())) {
			comShiftDto.setEffectStartTime(DateUtil.tomorrow());
		}
		// 冗余字段 班次规则详情
		comShiftDto.setShiftRuleDetail(this.jointShiftRule(comShiftDto));
		comShiftDto.setUpdateTime(new Date());
		// ShiftDto.EFFECT_RULE_TODAY：生效规则今天，ShiftDto.EFFECT_RULE_TOMORROW：生效规则明天
		if (ComShiftDto.EFFECT_RULE_TODAY.equals(comShiftDto.getEffectRule())) {
			comShiftDto.setEffectStartTime(new Date());
		} else if (ComShiftDto.EFFECT_RULE_TOMORROW.equals(comShiftDto.getEffectRule())) {
			String currDateTimeStr = DateUtils.getDateTime();
			// 一天有多少毫秒
			Long ms = 24L * 60L * 60L * 1000L;
			// 明天日期
			Date tomorrowDate = new Date(DateUtils.parseDate(currDateTimeStr).getTime() + ms);
			comShiftDto.setEffectStartTime(tomorrowDate);
		}

		// 添加班次
		comShiftMapper.insert(comShiftDto);
		// 添加班次规则
		this.addShiftRule(comShiftDto);
		// 新增完新的班次，把旧的班次失效
		ComShift oldComShift = comShiftMapper.getByPrimaryKey(oldShiftID);
		if (oldComShift.getEffectEndTime() != null) {
			throw new BusinessException(Result.ERROR, "该班次已失效");
		}
		Date newShiftEffectStartTime = comShiftDto.getEffectStartTime();
		Date lastSecondDate = DateUtils.addMilliseconds(newShiftEffectStartTime, -1000);
		// 设置失效时间
		oldComShift.setEffectEndTime(lastSecondDate);
		oldComShift.setShiftId(oldShiftID);
		oldComShift.setUpdateTime(comShiftDto.getUpdateTime());
		oldComShift.setUpdateBy(comShiftDto.getUpdateBy());
		comShiftMapper.update(oldComShift);
		if (comShiftMapper.findShiftNameRepetition(comShiftDto) > 0) {
			throw new BusinessException(Result.ERROR, "班次名称重复");
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	@Override
	public Result getByPrimaryKey(ComShiftDto comShiftDto) {
		ComShiftDto comShift = new ComShiftDto();
		ObjectUtils.copyProperties(comShift, comShiftMapper.getByPrimaryKey(comShiftDto.getShiftId()));
		comShift.setShiftRuleList(comShiftRuleMapper.getShiftRuleByShiftId(comShiftDto.getShiftId()));
		comShift.setCanEdit(true);
		String shiftMessage;
		if (DictConst.SHIFTTYPE_RWBC.equals(comShift.getShiftType())) {
			// 任务班次
			comShiftDto.setIsOnlyCheckEffect(CommonConst.Y);
			shiftMessage = this.checkTaskShift(comShiftDto);
		} else {
			// 考勤班次
			shiftMessage = this.checkAttenpShift(comShiftDto);
		}
		if (StringUtils.isNotEmpty(shiftMessage)) {
			comShift.setShiftMessage(shiftMessage);
			comShift.setCanEdit(false);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, comShift);
	}
}