package com.bcxin.oa.old.service.system;

import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.ComDepartDto;
import com.bcxin.oa.old.dto.OrgTreeDto;
import com.bcxin.oa.old.entity.system.ComDepart;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 部门
 *
 * @author zhangye
 * @since 2017-12-22 10:37:19
 */
public interface ComDepartService {

	/**
	 * 通过上级ID查询部门
	 *
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method selecteByParentDepartId @date：2017/12/21 13:58 @params： * @param
	 *         ComDepart
	 */
	Result selecteByParentDepartId(ComDepartDto comDepart);

	/**
	 * 通过上级ID查询部门
	 *
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method selecteComAndDepartByParentDepartId @date：2017/12/21
	 *         13:58 @params： * @param ComDepart
	 */
	Result selecteComAndDepartByParentDepartId(ComDepartDto comDepart);


	/**
	 * 保存部门信息
	 *
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method getByPrimaryKey @date：2017/12/22 17:59 @params： * @param
	 *         ComDepart
	 */
	Result getByPrimaryKey(ComDepartDto comDepart);

	/**
	 * 获取公司所有部门人员树形接口
	 *
	 * @param comDepart
	 * @return
	 */
	Result getTreePerByDepart(ComDepartDto comDepart);

	/**
	 * 获取公司所有部门人员map接口
	 *
	 * @param comDepart
	 * @return
	 */
	Result getTreePerByDepartMap(ComDepartDto comDepart);

	/**
	 * 获取公司所有部门树形接口
	 *
	 * @param comDepart
	 * @return
	 */
	Result getTreeDepart(ComDepartDto comDepart);

	/**
	 * 导出组织架构Excel模板 by llc 2018-09-13
	 * 
	 * @param response
	 * @return
	 */
	Result exportDepartTemp(String comId, HttpServletResponse response) throws BusinessException;

	/**
	 * 导出组织架构Excel
	 *
	 * @param response
	 * @return
	 */
	Result exportDepart(HttpServletResponse response, ComDepartDto comDepartDto) throws BusinessException;

	/**
	 * 获取公司所有部门树形接口(无数据权限)
	 *
	 * @param comDepart
	 * @return
	 */
	Result getTreeDepartNotDataAuth(ComDepartDto comDepart);


	/**
	 * 人事模块-组织架构部门树（新）
	 * @param comDepartDto
	 * @auth llc
	 * @date 2019-07-16
	 * @return
	 */
	Result getDepartTree(ComDepartDto comDepartDto);

	/**
	 * 递归生成部门树
	 *
	 * @param
	 * @return
	 * @auth llc
	 * @date 2019-07-16
	 */
	List<OrgTreeDto> getDepartChild(String parentDepartId, List<OrgTreeDto> departList);


	/**
	 * 获取部门app通讯录权限设置信息
	 * @param comDepart
	 * @auth llc
	 * @date 2019-07-26
	 * @return
	 */
	Result getDepartAppAuthInfo(ComDepart comDepart);

}