package com.bcxin.oa.old.service.system;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.dto.ComBaseInfoDto;
import com.bcxin.oa.old.entity.enterprise.company.ComBaseInfo;
import com.bcxin.oa.old.mapper.ComBaseInfoMapper;
import com.bcxin.oa.old.mapper.PerBaseInfoMapper;
import com.bcxin.oa.old.mapper.PerOrgRelationMapper;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 企业基础信息
 *
 * @author zhangye
 * @since 2017-12-22 11:20:53
 */
@Service
@Transactional
public class ComBaseInfoServiceImpl implements ComBaseInfoService {
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private PerBaseInfoService perBaseInfoService;
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Autowired
    public CacheService cacheService;
    @Resource
    private BbdTestService bbdTestService;
    @Resource
    private IdWorker idWorker;


    @Override
    public Result getByPrimaryKey(ComBaseInfoDto comBaseInfoDto) {
        long a = System.currentTimeMillis();
        ComBaseInfo comBaseInfo = comBaseInfoMapper.getByPrimaryKey(comBaseInfoDto.getComId());
        /*** 需排除离职人员 ***/
        if (comBaseInfo != null) {
            ObjectUtils.copyProperties(comBaseInfoDto, comBaseInfo);
            // 获取主管理员信息
//            comBaseInfoDto.setAdminPhone(perAccountInfoMapper.selectMobilePhone(comBaseInfoDto.getComId()));
            // 获取对应城市的保险规则
            comBaseInfoDto.setBxgzContent(comBaseInfoMapper.getContentByCity(comBaseInfo.getRegCity(), comBaseInfo.getInstitutionType()));
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, comBaseInfoDto);
    }


    @Override
    public Result getAllComId(String institutionType) {
        List<String> comIdList = comBaseInfoMapper.getAllComId(institutionType);
        return Result.success(Result.SUCCESS_QUERY_MSG, comIdList);
    }

    @Override
    public Result getInfoByComIdList(String comIdList) {
        List<String> idList;
        try {
            idList = Arrays.asList(comIdList);
        } catch (Exception e){
            try {
                idList = JSON.parseArray(comIdList, String.class);
            } catch (Exception ec){
                throw new BusinessException(Result.ERROR, "企业id转换失败");
            }
        }
        List<Map> infoList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(idList)) {
            infoList = comBaseInfoMapper.getInfoByComIds(idList);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, infoList);
    }

    /**
     * 获取当前请求对象
     *
     * @return
     */
    public HttpServletRequest getRequest() {
        try {
            return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        } catch (Exception e) {
            return null;
        }
    }
}