package com.bcxin.oa.old.service.system;

/**
 * @Author: 陈堂君
 * @Date: 2018/1/2
 * @Description:
 * @Modified By:
 */
public interface CacheService {
	/**
	 * 得到库表的配置信息
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 15:46
	 * @param key
	 * @return value
	 */
	String getSystemConfig(String key);

	/**
	 * 设置手机验证码缓存
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 16:16
	 * @param key
	 * @param value
	 */
	void setPhoneAuthCode(String key, String value);

	/**
	 * 获取手机验证码
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 16:17
	 * @param key
	 * @return
	 */
	String getPhoneAuthCode(String key, String value);

	/**
	 * 存储百保盾登陆状态
	 * 
	 * @apiNote 作者 张烨
	 * @since 创建于 2018/11/13 16:17
	 * @param key
	 * @return
	 */
	void setLoginBBD(String key, String value);

	/**
	 * 获取百保盾登陆状态
	 * 
	 * @apiNote 作者 张烨
	 * @since 创建于 2018/11/13 16:17
	 * @param key
	 * @return
	 */
	String getLoginBBD(String key);

	/**
	 * 设置支付平台手机验证码校验码
	 * @param key
	 * @param value
	 * @auth llc
	 * @date 2019-06-21
	 */
	void setActiveCodeSerial(String key, String value);

	/**
	 * 获取支付平台手机验证码校验码
	 * @param key
	 * @auth llc
	 * @date 2019-06-21
	 */
	 String getActiveCodeSerial(String key);


	/**
	 * 获取百保盾acessToken
	 *
	 * @param comId
	 * @param platUrl
	 * @return accessToken
	 * @auth llc
	 * @date 2020-06-02
	 */
	String getBbdAccessToken(Long comId,String platUrl);



	/**
	 * 区域代码缓存
	 * @param key
	 * @author llc
	 * @date 2019-04-11
	 */
	String getSysRegion(String key);


	/**
	 * 分发服务配置表缓存
	 * @param key
	 * @author llc
	 * @date 2021-03-13
	 */
	String getConfigBdp(String key);


}
