package com.bcxin.oa.old.service.attend.app;

import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ValidsUtils;
import com.bcxin.oa.old.mapper.ComShiftRuleMapper;
import com.bcxin.oa.old.mapper.app.PerAttendCardRecordMapper;
import com.bcxin.oa.old.entity.task.ComShiftRule;
import com.bcxin.oa.old.entity.task.PerAttendCardRecord;
import com.bcxin.oa.old.dto.app.AppPerAttendCardRecordDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 考勤打卡记录
 *
 * @author wangjianchi
 * @since 2018-03-05 16:39:29
 */
@Service
@Transactional
public class PerAttendCardRecordServiceImpl implements PerAttendCardRecordService {
	@Resource
	private PerAttendCardRecordMapper perAttendCardRecordMapper;

	@Resource
	private ComShiftRuleMapper comShiftRuleMapper;

	@Resource
	private IdWorker idWorker;

	@Override
	public Result saveSignIn(AppPerAttendCardRecordDTO appPerAttendCardRecordDTO) {
		// 判断前段数据是否符合规范
		if (StringUtils.isNotEmpty(ValidsUtils.judgebean(appPerAttendCardRecordDTO))) {
			return Result.fail(ValidsUtils.judgebean(appPerAttendCardRecordDTO), null);
		}
		ComShiftRule comShiftRule = comShiftRuleMapper.getShiftRuleByRuleId(appPerAttendCardRecordDTO.getShiftRuleId());
		if (comShiftRule != null) {
			appPerAttendCardRecordDTO.setShiftId(comShiftRule.getShiftId());
		} else {
			return Result.fail("该班次规则不存在，打卡失败!", null);
		}
		Date setClockInTime = DateUtils
				.parseDate(DateUtils.formatDate(appPerAttendCardRecordDTO.getShiftRuleClockDate()) + " "
						+ DateUtils.formatDate(comShiftRule.getStartWorkTime(), "HH:mm:ss"));
		appPerAttendCardRecordDTO.setSetClockInTime(setClockInTime);
		appPerAttendCardRecordDTO.setClockInDate(
				DateUtils.parseDate(DateUtils.formatDate(appPerAttendCardRecordDTO.getShiftRuleClockDate())));
		appPerAttendCardRecordDTO.setClockInTime(DateUtils.parseDate(DateUtils.getDate("yyyy-MM-dd HH:mm")));
		appPerAttendCardRecordDTO.setClockInRound(comShiftRule.getCommutRound());
		PerAttendCardRecord perAttendCardRecord = perAttendCardRecordMapper
				.getSignInAttendStatus(appPerAttendCardRecordDTO);
		appPerAttendCardRecordDTO.setAttendStatus(perAttendCardRecord.getAttendStatus());

		// 判断是否已经存在上班打卡记录
		List<PerAttendCardRecord> list = perAttendCardRecordMapper.getExitPerAttendRecord(appPerAttendCardRecordDTO);
		PerAttendCardRecord perAttendCardRecordDB = null;
		if (list != null && list.size() > 0) {
			if (list.size() == 1) {
				perAttendCardRecordDB = list.get(0);
			} else {
				throw new BusinessException(Result.ERROR, "打卡失败,存在多条上班打卡记录");
			}
		}
		if (perAttendCardRecordDB == null) {
			Long id = idWorker.nextId();
			appPerAttendCardRecordDTO.setAttendCardRecordId(id);
			int status = perAttendCardRecordMapper.insert(appPerAttendCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "考勤打卡失败，请稍后重试");
			}
		} else {
			// 如果考勤状态是请假，则不更新考勤状态，只更新打卡时间
			if (perAttendCardRecordDB.getAttendStatus().equals(DictConst.ATTENDSTATUS_QJ)) {
				appPerAttendCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_QJ);
			}
			appPerAttendCardRecordDTO.setAttendCardRecordId(perAttendCardRecordDB.getAttendCardRecordId());
			int status = perAttendCardRecordMapper.update(appPerAttendCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "考勤打卡失败，请稍后重试");
			}
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	@Override
	public Result saveSignOut(AppPerAttendCardRecordDTO appPerAttendCardRecordDTO) {
		// 判断前段数据是否符合规范
		if (StringUtils.isNotEmpty(ValidsUtils.judgebean(appPerAttendCardRecordDTO))) {
			return Result.fail(ValidsUtils.judgebean(appPerAttendCardRecordDTO), null);
		}
		ComShiftRule comShiftRule = comShiftRuleMapper.getShiftRuleByRuleId(appPerAttendCardRecordDTO.getShiftRuleId());
		if (comShiftRule != null) {
			appPerAttendCardRecordDTO.setShiftId(comShiftRule.getShiftId());
		} else {
			return Result.fail("该班次规则不存在，打卡失败!", null);
		}
		Date setClockInTime = null;
		if (CommonConst.Y.equals(comShiftRule.getIsEndNextDay())) {
			// 次日下班打卡时间
			setClockInTime = DateUtils
					.parseDate(DateUtils.getDayAfterSomeDay(appPerAttendCardRecordDTO.getShiftRuleClockDate(), 1) + " "
							+ DateUtils.formatDate(comShiftRule.getEndWorkTime(), "HH:mm:ss"));
		} else {
			// 当日下班打卡时间
			setClockInTime = DateUtils.parseDate(DateUtils.formatDate(appPerAttendCardRecordDTO.getShiftRuleClockDate())
					+ " " + DateUtils.formatDate(comShiftRule.getEndWorkTime(), "HH:mm:ss"));
		}
		appPerAttendCardRecordDTO.setSetClockInTime(setClockInTime);
		appPerAttendCardRecordDTO.setClockInDate(
				DateUtils.parseDate(DateUtils.formatDate(appPerAttendCardRecordDTO.getShiftRuleClockDate())));
		appPerAttendCardRecordDTO.setClockInTime(DateUtils.parseDate(DateUtils.getDate("yyyy-MM-dd HH:mm")));
		appPerAttendCardRecordDTO.setClockInRound(comShiftRule.getCommutRound());
		appPerAttendCardRecordDTO.setAttendCardRecordId(idWorker.nextId());
		// 下班考勤状态
		PerAttendCardRecord perAttendCardRecord = perAttendCardRecordMapper
				.getSignOutAttendStatus(appPerAttendCardRecordDTO);
		appPerAttendCardRecordDTO.setAttendStatus(perAttendCardRecord.getAttendStatus());

		// 判断是否已经存在上班打卡记录
		List<PerAttendCardRecord> list = perAttendCardRecordMapper.getExitPerAttendRecord(appPerAttendCardRecordDTO);
		PerAttendCardRecord perAttendCardRecordDB = null;
		if (list != null && list.size() > 0) {
			if (list.size() == 1) {
				perAttendCardRecordDB = list.get(0);
			} else {
				throw new BusinessException(Result.ERROR, "打卡失败,存在多条上班打卡记录");
			}
		}
		if (perAttendCardRecordDB == null) {
			Long id = idWorker.nextId();
			appPerAttendCardRecordDTO.setAttendCardRecordId(id);
			int status = perAttendCardRecordMapper.insert(appPerAttendCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "考勤打卡失败，请稍后重试");
			}
		} else {
			// 如果考勤状态是请假，则不更新考勤状态，只更新打卡时间
			if (perAttendCardRecordDB.getAttendStatus().equals(DictConst.ATTENDSTATUS_QJ)) {
				appPerAttendCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_QJ);
			}
			appPerAttendCardRecordDTO.setAttendCardRecordId(perAttendCardRecordDB.getAttendCardRecordId());
			int status = perAttendCardRecordMapper.update(appPerAttendCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "考勤打卡失败，请稍后重试");
			}
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * APP-按月查询考勤统计情况
	 *
	 * @param perAttendCardRecordDTO
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/22
	 */
	@Override
	public Result countAttendCardRecord(AppPerAttendCardRecordDTO perAttendCardRecordDTO) {
		Map<String, Object> map = new HashMap<>();
		return Result.success(Result.SUCCESS_MSG, map);
	}

	@Override
	public Result getAttendState(AppPerAttendCardRecordDTO appPerAttendCardRecordDTO) {
		// 判断前段数据是否符合规范
		if (appPerAttendCardRecordDTO.getShiftRuleId() == null ) {
			throw new BusinessException(Result.ERROR, "考勤打卡失败，班次ID不能为空");
		}
		if (appPerAttendCardRecordDTO.getShiftRuleClockDate() == null ) {
			throw new BusinessException(Result.ERROR, "考勤打卡失败，打卡日期不能为空");
		}
		ComShiftRule comShiftRule = comShiftRuleMapper.getShiftRuleByRuleId(appPerAttendCardRecordDTO.getShiftRuleId());
		if (comShiftRule != null) {
			appPerAttendCardRecordDTO.setShiftId(comShiftRule.getShiftId());
			appPerAttendCardRecordDTO.setShiftRuleId(appPerAttendCardRecordDTO.getShiftRuleId());
		} else {
			return Result.fail("该班次规则不存在，打卡失败!", null);
		}
		// 班次考勤状态
		PerAttendCardRecord perAttendCardRecord = perAttendCardRecordMapper
				.getSignOutAttendStatus(appPerAttendCardRecordDTO);
		return Result.success(Result.SUCCESS_MSG,perAttendCardRecord.getAttendStatus());
	}
}