package com.bcxin.oa.old.service.attend;

import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.dto.ComAttendGroupFixedDTO;
import com.bcxin.oa.old.dto.ComAttendGroupFixedTempDTO;
import com.bcxin.oa.old.entity.task.ComAttendGroup;
import com.bcxin.oa.old.entity.task.ComAttendGroupFixed;
import com.bcxin.oa.old.mapper.ComAttendGroupFixedMapper;
import com.bcxin.oa.old.mapper.ComAttendGroupMapper;
import com.bcxin.oa.old.service.common.CommonService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 企业考勤组固定班制明细
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
@Service
@Transactional
public class ComAttendGroupFixedServiceImpl implements ComAttendGroupFixedService {
	@Resource
	private ComAttendGroupFixedMapper comAttendGroupFixedMapper;

	@Resource
	private ComAttendGroupMapper comAttendGroupMapper;

	@Resource
	private CommonService commonService;

	@Resource
	private IdWorker idWorker;

	@Override
	public Result save(ComAttendGroupFixedTempDTO comAttendGroupFixedTempDTO) throws BusinessException {
		String comAttendGroupFixeds = comAttendGroupFixedTempDTO.getComAttendGroupFixeds();
		Long attendGroupId = comAttendGroupFixedTempDTO.getAttendGroupId();// 考勤组ID
		String attendType = comAttendGroupFixedTempDTO.getAttendType();// 考勤类型
		List<ComAttendGroupFixedDTO> comAttendGroupFixedDTOList = null;
		if (attendGroupId == null) {
			throw new BusinessException(Result.ERROR, "考勤组ID为空");
		}
		if (StringUtils.isEmpty(comAttendGroupFixeds)) {
			throw new BusinessException(Result.ERROR, "考勤班次为空");
		}
		if (StringUtils.isEmpty(attendType)) {
			throw new BusinessException(Result.ERROR, "考勤类型为空");
		}
		comAttendGroupFixedDTOList = JSON.parseArray(comAttendGroupFixeds, ComAttendGroupFixedDTO.class);
		// 查找考勤组ID是否存在,如果存在则修改考勤类型
		ComAttendGroup comAttendGroup = comAttendGroupMapper.getByPrimaryKey(attendGroupId);
		if (comAttendGroup == null) {
			throw new BusinessException(Result.ERROR, "考勤组不存在");
		}
		comAttendGroup.setAttendType(attendType);
		comAttendGroupMapper.updateAttendGroup(comAttendGroup);
		// 保存固定班制明显
		for (ComAttendGroupFixedDTO comAttendGroupFixedDTO : comAttendGroupFixedDTOList) {
			comAttendGroupFixedDTO.setAttendGroupFixedId(idWorker.nextId());
			comAttendGroupFixedDTO.setAttendGroupId(attendGroupId);
			comAttendGroupFixedDTO.setComId(comAttendGroupFixedTempDTO.getComId());
			comAttendGroupFixedDTO.setCreateBy(comAttendGroupFixedTempDTO.getCreateBy());
			comAttendGroupFixedDTO.setCreateTime(comAttendGroupFixedTempDTO.getCreateTime());
			comAttendGroupFixedMapper.insert(comAttendGroupFixedDTO);
		}
		return Result.success(Result.SUCCESS_MSG, comAttendGroupFixedDTOList);
	}

	@Override
	public Result update(ComAttendGroupFixedTempDTO comAttendGroupFixedTempDTO) throws BusinessException {
		String comAttendGroupFixeds = comAttendGroupFixedTempDTO.getComAttendGroupFixeds();
		List<ComAttendGroupFixedDTO> comAttendGroupFixedDTOList = null;
		if (StringUtils.isEmpty(comAttendGroupFixeds)) {
			throw new BusinessException(Result.ERROR, "考勤班次为空");
		} else {
			comAttendGroupFixedDTOList = JSON.parseArray(comAttendGroupFixeds, ComAttendGroupFixedDTO.class);
			for (ComAttendGroupFixedDTO comAttendGroupFixedDTO : comAttendGroupFixedDTOList) {
				comAttendGroupFixedDTO.setUpdateBy(comAttendGroupFixedTempDTO.getUpdateBy());
				comAttendGroupFixedDTO.setUpdateTime(comAttendGroupFixedTempDTO.getUpdateTime());
				comAttendGroupFixedMapper.update(comAttendGroupFixedDTO);
			}
		}
		return Result.success(Result.SUCCESS_MSG, comAttendGroupFixedDTOList);
	}

	@Override
	public Result getDetail(ComAttendGroupFixedDTO comAttendGroupFixedDTO) throws BusinessException {
		Long attendGroupId = comAttendGroupFixedDTO.getAttendGroupId();// 考勤组ID
		if (attendGroupId == null) {
			throw new BusinessException(Result.ERROR, "考勤组ID为空");
		}
		// 查找考勤组ID是否存在,如果存在则修改考勤类型
		ComAttendGroup comAttendGroup = comAttendGroupMapper.getByPrimaryKey(attendGroupId);
		if (comAttendGroup == null) {
			throw new BusinessException(Result.ERROR, "考勤组不存在");
		}
		ComAttendGroupFixedTempDTO comAttendGroupFixedTempDTO = new ComAttendGroupFixedTempDTO();
		comAttendGroupFixedTempDTO.setAttendGroupId(attendGroupId);
		comAttendGroupFixedTempDTO.setAttendType(comAttendGroup.getAttendType());
		List<ComAttendGroupFixedDTO> comAttendGroupFixedDTOList = new ArrayList<ComAttendGroupFixedDTO>();
		List<ComAttendGroupFixed> comAttendGroupFixedList = comAttendGroupFixedMapper.list(comAttendGroupFixedDTO);
		if (comAttendGroupFixedList != null && comAttendGroupFixedList.size() > 0) {
			for (ComAttendGroupFixed comAttendGroupFixed : comAttendGroupFixedList) {
				ComAttendGroupFixedDTO comAttendGroupFixedReturnDTO = new ComAttendGroupFixedDTO();
				ObjectUtils.copyProperties(comAttendGroupFixedReturnDTO, comAttendGroupFixed);
				Long shiftId = comAttendGroupFixedReturnDTO.getShiftId();
				comAttendGroupFixedReturnDTO.setShiftDetails(commonService.listChangeToString(shiftId, true, true));
				comAttendGroupFixedDTOList.add(comAttendGroupFixedReturnDTO);
			}
		}
		comAttendGroupFixedTempDTO.setReturnComAttendGroupFixedList(comAttendGroupFixedDTOList);
		return Result.success(Result.SUCCESS_QUERY_MSG, comAttendGroupFixedTempDTO);
	}

	@Override
	public Result getAddTemp(ComAttendGroupFixedDTO comAttendGroupFixedDTO) throws BusinessException {
		List<ComAttendGroupFixedDTO> comAttendGroupFixedDTOList = new ArrayList<ComAttendGroupFixedDTO>();
		for (int i = 1; i < 8; i++) {
			ComAttendGroupFixedDTO comAttendGroupFixedDTOTemp = new ComAttendGroupFixedDTO();
			comAttendGroupFixedDTOTemp.setWeekDay(i);
			comAttendGroupFixedDTOTemp.setIsRest(CommonConst.Y);
			comAttendGroupFixedDTOList.add(comAttendGroupFixedDTOTemp);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, comAttendGroupFixedDTOList);
	}

}