package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskSchedulCycle;
import com.bcxin.oa.old.dto.ComTaskSchedulCycleDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 任务排班周期
 *
 * @author zhangye
 * @since 2018-02-26 10:04:47
 */
public interface ComTaskSchedulCycleMapper extends CrudDao<ComTaskSchedulCycle> {

    int deleteBySchedulCycleId(@Param("taskSchedulCycleId") Long taskSchedulCycleId);

    List<Map> getTaskCycle(@Param("comTaskId") Long comTaskId);

    /**
     * 查询任务排班周期所选班次信息
     *
     * @param comTaskId
     */
    List<Long> findTaskCycleShiftByComTaskId(Long comTaskId);

    /**
     * 查询周期排班信息
     *
     * @param comTaskId
     */
    List<ComTaskSchedulCycleDTO> selectComTaskSchedulCycleByComTaskId(Long comTaskId);

    /**
     * 批量添加周期基础信息
     *
     * @param listComTaskSchedulCycle
     * @return
     */
    int batchInsertComTaskSchedulCycle(List<ComTaskSchedulCycle> listComTaskSchedulCycle);
}