package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.common.CrudDao;
import com.bcxin.oa.old.dto.ComDepartDto;
import com.bcxin.oa.old.dto.ComDepartTreeResultDto;
import com.bcxin.oa.old.dto.OrgTreeDto;
import com.bcxin.oa.old.entity.system.ComDepart;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 部门
 * 
 * @author zhangye
 * @since 2017-12-22 10:37:19
 */
public interface ComDepartMapper extends CrudDao<ComDepart> {

	/**
	 * 通过部门ID查询下级部门
	 * 
	 * @Decription:
	 * @author：zhongjianhui
	 * @method selecteByParentDepartId @date：2017/12/26 16:25 @params： * @param
	 *         parentDepartId  * @param comId
	 * @return java.util.List<com.bcxin.platform.domain.ComDepart>
	 */
	List<ComDepart> selecteByParentDepartId(@Param(value = "parentDepartId") Long parentDepartId,
			@Param(value = "comId") Long comId, @Param(value = "keyword") String keyword);

	/**
	 * 查出该部门的管理员
	 * 
	 * @Decription:
	 * @author：zhongjianhui
	 * @method selectChargeByDepartId @date：2017/12/26 16:30 @params： * @param
	 *         departId
	 * @return ComDepartDto
	 */
	ComDepartDto selectChargeByDepartId(@Param(value = "departId") Long departId);


	/**
	 * 公司人员返回树形人员
	 *
	 * @Decription:
	 * @author：zhongjianhui
	 * @return java.util.Map
	 */
	List<Map> treePersonByComId(@Param(value = "comId") Long comId, @Param(value = "orgType") String orgType);

	/**
	 * 部门的人数
	 * 
	 * @Decription:
	 * @author：zhongjianhui
	 * @method countForSelecteByDepartID @date：2017/12/27 13:42 @params：
	 *         * @param departId
	 * @return java.lang.Integer
	 */
	Integer countForSelecteByDepartID(@Param(value = "departId") Long departId);

	/**
	 * 部门下面是否有子集
	 *
	 * @Decription:
	 * @author：zhongjianhui
	 * @method countForHaveChildDepart @date：2018/01/19 13:42 @params： * @param
	 *         departId
	 * @return java.lang.Integer
	 */
	Integer countForHaveChildDepart(@Param(value = "departId") Long departId);

	/**
	 * 查询公司的人数
	 * 
	 * @Decription:
	 * @author：zhongjianhui
	 * @method countForSelecteByDepartID @date：2017/12/27 13:42 @params：
	 *         * @param departId
	 * @return java.lang.Integer
	 */
	Integer countForCompany(@Param(value = "comId") Long comId);

	/**
	 * 根据部门ID获取部门人员列表
	 * 
	 * @Decription:
	 * @author：zhongjianhui
	 * @method personByDepartId @date：2017/12/26 16:30 @params： * @param
	 *         departId
	 * @return java.util.Map
	 */
	List<Map> personByDepartId(@Param(value = "departId") Long departId);

	/**
	 * 根据部门ID和限制类型获取部门人员列表 限制类型 1为限制选择出不是部门主管的人员
	 * 
	 * @Decription:
	 * @author：zhongjianhui
	 * @method personByDepartIdAndLimitType @date：2017/12/26 16:30 @params：
	 * @param departId,limitType
	 * @return java.util.Map
	 */
	List<Map> personByDepartIdAndLimitType(@Param(value = "departId") Long departId,
			@Param(value = "limitType") String limitType);

	/**
	 * 根据公司ID获取公司所有部门底下人员列表(排除没有部门人员)
	 * 
	 * @Decription:
	 * @author：zhangye
	 * @method personByComId @date：2017/12/26 16:30 @params： * @param comId
	 * @return java.util.Map
	 */
	List<Map> personByComId(@Param(value = "comId") Long comId);

	/**
	 * 把导入人员批量插入到临时表
	 * 
	 * @param perInfoList
	 * @param importBatchId
	 *            by llc 2018-09-17 13:40:00
	 */
	Integer insertTempBatchPerImport(@Param("perInfoList") List<Map<String, String>> perInfoList,
			@Param("importBatchId") Long importBatchId);

	/**
	 * 1.人员批量导入-更新临时表数据
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer updateTempPerImport(@Param("importBatchId") Long importBatchId);

	/**
	 * 2.人员批量导入-校验导入的人员是否存在身份证重复
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer checkIdCardNoRepeat(@Param("importBatchId") Long importBatchId);

	/**
	 * 3.人员批量导入-校验导入的人员是否存在手机重复
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer checkMobilePhoneRepeat(@Param("importBatchId") Long importBatchId);

	/**
	 * 4.人员批量导入-校验部门的有效性
	 * 
	 * @param importBatchId
	 * @param comId
	 *            by llc 2018-09-20
	 */
	Integer checkDepartActive(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);


	/**
	 * 4.1 人员批量导入-校验人员类型的有效性
	 *
	 * @param importBatchId
	 * @param comId
	 *            by llc 2018-12-15
	 */
	Integer checkPerTypeActive(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * 5.人员批量导入-校验角色的有效性
	 * 
	 * @param importBatchId
	 * @param comId
	 *            by llc 2018-09-20
	 */
	Integer checkRoleActive(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);


	/**
	 * 6.人员批量导入-校验人员是否已经存在其他公司
	 * 
	 * @param importBatchId
	 * @param comId
	 *            by llc 2018-09-20
	 */
	Integer checkInOtherCom(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * 7.人员批量导入-校验人员是否存在本公司
	 * 
	 * @param importBatchId
	 * @param comId
	 *            by llc 2018-09-20
	 */
	Integer checkInCom(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * 8.人员批量导入-校验手机号是否已使用(需排除离职)
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer checkInJobPhoneUse(@Param("importBatchId") Long importBatchId);

	/**
	 * 9.人员批量导入-校验手机号是否已使用(离职情况)
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer checkLeaveJobPhoneUse(@Param("importBatchId") Long importBatchId);

	/**
	 * 10.人员批量导入-校验离职人员的离职日期晚于入职日期
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer checkEntryDate(@Param("importBatchId") Long importBatchId);

	/**
	 * 11.人员批量导入-筛选出已在系统但是离职的人员
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer filtLeaveJobPer(@Param("importBatchId") Long importBatchId);

	/**
	 * 12.人员批量导入-更新离职人员信息
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-20
	 */
	Integer updateLeaveJobPer(@Param("importBatchId") Long importBatchId);

	/**
	 * 13.人员批量导入-更新离职人员在职状态
	 * 
	 * @param importBatchId
	 * @param createBy
	 *            by llc 2018-09-20
	 */
	Integer updateLeaveJobPerStatus(@Param("importBatchId") Long importBatchId, @Param("createBy") Long createBy);

	/**
	 * 13.1 人员批量导入-更新离职人员用户信息
	 *
	 * @param importBatchId
	 * @param createBy
	 *            by llc 2019-07-17
	 */
	Integer updateLeaveJobPerAccount(@Param("importBatchId") Long importBatchId, @Param("createBy") Long createBy);

	/**
	 * 14.人员批量导入-系统中不存在的人员新增
	 * 
	 * @param importBatchId
	 * @param createBy
	 * @param comId
	 * by llc 2018-09-20
	 */
	Integer insertPerBaseInfo(@Param("importBatchId") Long importBatchId, @Param("createBy") Long createBy , @Param("comId") Long comId);

	/**
	 * 15.人员批量导入-插入人员账户信息
	 * 
	 * @param importBatchId
	 * @param createBy
	 *            by llc 2018-09-20
	 */
	Integer insertPerAccountInfo(@Param("importBatchId") Long importBatchId, @Param("createBy") Long createBy);

	/**
	 * 16.人员批量导入-插入人员组织关系
	 * 
	 * @param importBatchId
	 * @param createBy
	 *            by llc 2018-09-20
	 */
	Integer insertPerOrgRelation(@Param("importBatchId") Long importBatchId, @Param("createBy") Long createBy,
			@Param("comId") Long comId);

	/**
	 * 17.人员批量导入-插入用户角色
	 * 
	 * @param importBatchId
	 * @param createBy
	 *            by llc 2018-09-20
	 */
	Integer insertComUserRole(@Param("importBatchId") Long importBatchId, @Param("createBy") Long createBy);

	/**
	 * 获取导入的人员信息
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-17 13:40:00
	 */
	List<Map<String, String>> getTempImportPerList(@Param("importBatchId") Long importBatchId);

	/**
	 * 删除临时表的导入人员
	 * 
	 * @param importBatchId
	 *            by llc 2018-09-17 13:40:00
	 */
	Integer deleteTempBatchPerImport(@Param("importBatchId") Long importBatchId);



	/**
	 * 批量调整部门
	 * 
	 * @param comId
	 * @param orgId
	 * @param orgType
	 * @param updateBy
	 * @param perIdList
	 *            by llc 2018-09-21
	 */
	Integer batchAdjustOrg(@Param("comId") Long comId, @Param("orgId") Long orgId, @Param("orgType") String orgType,
			@Param("updateBy") Long updateBy, @Param("perIdList") List<String> perIdList);

	/**
	 * 批量删除部门主管角色
	 *
	 * @param comId
	 * @param perIdList
	 *            by llc 2018-09-21
	 */
	Integer batchRemoveDepartAdminRole(@Param("comId") Long comId, @Param("perIdList") List<String> perIdList);

	/**
	 * 通过上级部门ID查询部门信息
	 * 
	 * @param parentDepartId
	 * @param comId
	 * @return
	 */
	ComDepart getParentDepart(@Param(value = "parentDepartId") Long parentDepartId, @Param(value = "comId") Long comId);

	/**
	 * 获取部门(部门总人数)树型(有数据权限)
	 * 
	 * @param comId
	 *            公司ID
	 *            当前用户ID
	 * @return
	 */
	List<Map> getTreeDepart(@Param(value = "comId") Long comId);

	/**
	 * 获取部门列表
	 * 
	 * @param comId
	 * @return by llc 2018-09-13
	 */
	List<ComDepartTreeResultDto> getComDepartByComId(@Param(value = "comId") Long comId);

	/**
	 * 获取组织架构的下一级部门
	 * 
	 * @param comId
	 * @return by llc 2018-10-30
	 */
	List<Map<String, Object>> getChildDepart(@Param(value = "comId") Long comId,
			@Param(value = "departId") Long departId, @Param(value = "perId") Long perId);



	/**
	 * 根据角色ID、公司ID返回角色的人员部门列表
	 * 
	 * @param comId
	 * @param roleId
	 * @return
	 */
	List<Map> getDepartListByRoleIDAndComID(@Param(value = "comId") Long comId, @Param(value = "roleId") Long roleId);

	/**
	 * 根据角色ID、公司ID返回角色的人员部门及下级部门列表
	 * 
	 * @param comId
	 * @param roleId
	 * @return
	 */
	List<Map> getDepartAndChildListByRoleIDAndComID(@Param(value = "comId") Long comId,
			@Param(value = "roleId") Long roleId);

	/**
	 * 获取部门(部门总人数)树型(无数据权限)
	 * 
	 * @param comId
	 *            公司ID
	 * @return
	 */
	List<Map> getTreeDepartNotDataAuth(@Param(value = "comId") Long comId);


	/**
	 * 获取公司的人员类别
	 *
	 * @param comId
	 * @return
	 * by llc 2018-12-15
	 */
	List<Map<String,String>> getComPerType(@Param(value = "comId") Long comId);


	/**
	 * 获取人员信息
	 *
	 * @param perId
	 * @return
	 * by llc 2019-03-15
	 */
	List<Map> getPerInfoByPerId(@Param(value = "perId") Long perId);

	/**
	 * 获取企业的部门列表
	 *
	 * @param comId
	 * @return
	 * by llc 2019-07-16
	 */
	List<OrgTreeDto> getDepartList(@Param(value = "comId") Long comId);

	/**
	 * 获取所在部门或者所在部门以及下级部门
	 *
	 * @param perId
	 * @param comId
	 * @param dataAuthType
	 * @return
	 * by llc 2019-07-10
	 */
	List<Long> getOrgIdList(@Param(value = "perId") Long perId,@Param(value = "comId") Long comId,@Param(value = "dataAuthType") String dataAuthType);


	/**
	 * 查询某个部门的深度
	 * @param comId
	 * @param departId
	 * @return
	 * @date 2019-07-23
	 * @auth llc
	 */
	Integer getDepartDepth(@Param(value = "comId") Long comId,@Param(value = "departId") Long departId);

	/**
	 * 更新子孙部门的departTreeCode
	 * @param comId
	 * @param oldTreeCode
	 * @param newTreeCode
	 * @return
	 * @date 2019-07-23
	 * @auth llc
	 */
	int updateChildDepartTreeCode(@Param(value = "comId") Long comId,
								  @Param(value = "oldTreeCode") String oldTreeCode,
								  @Param(value = "newTreeCode") String newTreeCode);


	/**
	 * 获取企业的部门列表(app html通讯录)
	 *
	 * @param comId
	 * @return
	 * by llc 2019-07-25
	 */
	List<OrgTreeDto> getHtmlDepartList(@Param(value = "comId") Long comId);


	/**
	 * 查询部门以及子孙部门ID集合（包含本部门）
	 * @param comId
	 * @param departId
	 * @return
	 * by llc 2019-07-25
	 */
	List<Long> getChildDepartIdList(@Param(value = "comId") Long comId,@Param(value = "departId") Long departId);


	/**
	 * 获取每个部门的人员数量(包含app通讯录查看权限)
	 * @param comId
	 * @param departIdList
	 * @return
	 * by llc 2019-07-25
	 */
	List<Map<String,Object>> getHtmlDepartPerCountList(@Param(value = "comId") Long comId,@Param(value = "departIdList") List<Long> departIdList);


	/**
	 * 更新部门app可视权限设置
	 * @param comDepart
	 * @return
	 * @date 2019-07-29
	 * @auth llc
	 */
	int updateDepartAppVisibleSet(ComDepart comDepart);

}