package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComAttendPer;
import com.bcxin.oa.old.dto.ComAttendPerDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 企业考勤组考勤人员
 *
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
public interface ComAttendPerMapper extends CrudDao<ComAttendPer> {



    /**
     * 批量删除考勤组人员
     *
     * @param perIdList
     * @return
     */
    int deleteBatchComAttendPer(@Param(value = "perIdList") List<String> perIdList,@Param(value = "comAttendGroupId") Long comAttendGroupId);


    /**
     * 检查人员是否存在于其他考勤组
     *
     * @param comAttendPerDTO
     * @return
     */
    ComAttendPerDTO findAttendGroupByPerId(ComAttendPerDTO comAttendPerDTO);

    /**
     * 批量插入考勤组人员
     *
     * @param attendPerList
     * @return
     */
    int insertAttendPer(@Param("list") List<ComAttendPer> attendPerList);


    /**
     * 把其他考勤组的人员移出
     *
     * @param paramMap
     * @return
     */
    int updateAttendPer(Map<String,Object> paramMap);


    /**
     * 更新旧的考勤组人员的生效截止时间
     *
     * @param paramMap
     * @return
     */
    int updateOldAttendPer(Map<String,Object> paramMap);



    /**
     * 查询考勤组的人员Id列表
     *
     * @param attendGroupId
     * @param updateTime
     * @return
     * by llc 2018-12-18
     */
    List<Long> getAttendPerIdList(@Param(value = "attendGroupId") Long attendGroupId,
                                 @Param(value = "updateTime") Date updateTime);


    /**
     * 删除考勤组把考勤组人员置为失效 by llc 2018-11-23
     *
     * @param attendGroupId
     * @param updateBy
     * @param updateTime
     * @return
     */
    int deleteAttendGroupPerById(@Param(value = "attendGroupId") Long attendGroupId,
                                  @Param(value = "updateBy") Long updateBy,
                                  @Param(value = "updateTime") Date updateTime);


    /**
     * 删除考勤组校验表人员
     *
     * @param midAttendGroupId
     * @return
     */
    int deleteValidateAttendPer(@Param(value = "midAttendGroupId") Long midAttendGroupId);

    /**
     * 批量插入考勤组人员到校验表
     *
     * @param list
     * @return
     */
    int insertValidateAttendPer(List<Map<String,Object>> list);


    /**
     * 校验考勤组人员是否在其他考勤组重复
     *
     * @param map
     * @return
     */
    int validateAttendPer(Map<String,Object> map);


    /**
     * 校验考勤组人员是否已经存在本考勤组明日生效
     *
     * @param map
     * @return
     * by llc 2018-11-22
     */
    int validateThisAttendPer(Map<String,Object> map);



    /**
     * 查询考勤人员校验表
     *
     * @param map
     * @return
     */
    List<Map<String,String>> getValAttendPerList(Map<String,Object> map);


    /**
     * 查询校验失败（存在其他考勤组）的人员
     * by llc 2018-11-15
     * @param  midAttendGroupId
     * @return
     */
    List<Long> getCheckFailAttendPerList(@Param("midAttendGroupId") Long midAttendGroupId);


    /**
     * 查询考勤组人员
     *
     * @param attendGroupId
     * @return
     */
    List<Map<String,Object>> getAttendPerList(@Param(value = "createTime") Date createTime, @Param(value = "attendGroupId") Long attendGroupId);


    /**
     * 查询已经存在其他考勤组的人员列表
     *
     * @param map
     * @return
     */
    List<Map<String,String>> getExistsAttendPerList(Map<String,Object> map);



    /**
     * 定时任务删除考勤组人员校验表
     *
     * @param
     * @return
     * @author llc
     * @since 2018-04-02
     */
    int deleteValidateAttendPerBytask() ;


    /**
     * 清除当天的人员考勤打卡记录
     *
     * @param
     * @return
     * @author llc
     * @date 2018-11-15
     */
    int deleteAttendCardRecord(@Param("list") List<Long> perIdList ,@Param("clockInDate")String clockInDate ,@Param("comId") Long comId ) ;


    /**
     * 修改考勤组更新减少的人员
     *
     * @param paramMap
     * @return
     * by llc 2018-11-19
     */
    int updateOldAttendLessPer(Map<String,Object> paramMap);


    /**
     * 获取考勤组更新新增的人员
     *
     * @param attendGroupId
     * @param midAttendGroupId
     * @return
     * by llc 2018-11-19
     */
    List<Map<String,String>>  getAddAttendPerList(@Param("attendGroupId")Long attendGroupId ,@Param("midAttendGroupId")Long midAttendGroupId,@Param("updateTime")Date updateTime);

}