package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 考勤打卡记录
 *
 * @author wangjianchi
 * @since 2018-03-05 16:39:29
 */
@TableName("per_attend_card_record")
public class PerAttendCardRecord extends BaseEntity<PerAttendCardRecord> {
	private static final long serialVersionUID = 991038105L;

	/**
	 * 考勤打卡记录ID
	 */
	@ApiModelProperty(value = "考勤打卡记录ID")
	private Long attendCardRecordId;

	/**
	 * 设置的打卡时间
	 */
	@ApiModelProperty(value = "设置的打卡时间")
	private Date setClockInTime;

	/**
	 * 打卡日期
	 */
	@ApiModelProperty(value = "打卡日期")
	private Date clockInDate;

	/**
	 * 打卡时间
	 */
	@ApiModelProperty(value = "打卡时间")
	private Date clockInTime;

	/**
	 * 打卡类别(上班打卡、下班打卡)
	 */
	@ApiModelProperty(value = "打卡类别(上班打卡、下班打卡)")
	private String clockInType;

	/**
	 * 第几轮打卡
	 */
	@NotNull(message = "第几轮打卡不能为空")
	@ApiModelProperty(value = "第几轮打卡")
	private int clockInRound;

	/**
	 * 打卡地点经度
	 */
	@NotNull(message = "打卡地点经度不能为空")
	@ApiModelProperty(value = "打卡地点经度")
	private String placeLongitude;

	/**
	 * 打卡地点纬度
	 */
	@NotNull(message = "打卡地点纬度不能为空")
	@ApiModelProperty(value = "打卡地点纬度")
	private String palceLatitude;

	/**
	 * 打卡方式(wifi打卡、地点打卡)
	 */
	@NotNull(message = "打卡方式不能为空")
	@ApiModelProperty(value = "打卡方式(wifi打卡、地点打卡)")
	private String clockInWay;

	/**
	 * 考勤状态
	 */
	@ApiModelProperty(value = "考勤状态")
	private String attendStatus;

	/**
	 * 班次ID
	 */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	/**
	 * 班次规则ID
	 */
	@NotNull(message = "班次规则ID不能为空")
	@ApiModelProperty(value = "班次规则ID")
	private Long shiftRuleId;

	/**
	 * 考勤WIFIID
	 */
	@ApiModelProperty(value = "考勤WIFIID")
	private Long attendWifiId;

	/**
	 * 打卡人员ID
	 */
	@ApiModelProperty(value = "打卡人员ID")
	private Long perId;

	/**
	 * 审批申请ID
	 */
	@ApiModelProperty(value = "审批申请ID")
	private Long approveApplyId;

	/**
	 * 打卡地点
	 */
	@ApiModelProperty(value = "打卡地点")
	private String attendAddress;

	public Long getAttendCardRecordId() {
		return attendCardRecordId;
	}

	public void setAttendCardRecordId(Long attendCardRecordId) {
		this.attendCardRecordId = attendCardRecordId;
	}

	public void setSetClockInTime(Date setClockInTime) {
		this.setClockInTime = setClockInTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getSetClockInTime() {
		return setClockInTime;
	}

	public Date getClockInDate() {
		return clockInDate;
	}

	public void setClockInDate(Date clockInDate) {
		this.clockInDate = clockInDate;
	}

	public void setClockInTime(Date clockInTime) {
		this.clockInTime = clockInTime;
	}

	public Date getClockInTime() {
		return clockInTime;
	}

	public String getClockInType() {
		return clockInType;
	}

	public void setClockInType(String clockInType) {
		this.clockInType = clockInType;
	}

	public int getClockInRound() {
		return clockInRound;
	}

	public void setClockInRound(int clockInRound) {
		this.clockInRound = clockInRound;
	}

	public String getPlaceLongitude() {
		return placeLongitude;
	}

	public void setPlaceLongitude(String placeLongitude) {
		this.placeLongitude = placeLongitude;
	}

	public String getPalceLatitude() {
		return palceLatitude;
	}

	public void setPalceLatitude(String palceLatitude) {
		this.palceLatitude = palceLatitude;
	}

	public String getClockInWay() {
		return clockInWay;
	}

	public void setClockInWay(String clockInWay) {
		this.clockInWay = clockInWay;
	}

	public String getAttendStatus() {
		return attendStatus;
	}

	public void setAttendStatus(String attendStatus) {
		this.attendStatus = attendStatus;
	}

	public Long getShiftId() {
		return shiftId;
	}

	public void setShiftId(Long shiftId) {
		this.shiftId = shiftId;
	}

	public Long getShiftRuleId() {
		return shiftRuleId;
	}

	public void setShiftRuleId(Long shiftRuleId) {
		this.shiftRuleId = shiftRuleId;
	}

	public Long getAttendWifiId() {
		return attendWifiId;
	}

	public void setAttendWifiId(Long attendWifiId) {
		this.attendWifiId = attendWifiId;
	}

	public Long getPerId() {
		return perId;
	}

	public void setPerId(Long perId) {
		this.perId = perId;
	}

	public Long getApproveApplyId() {
		return approveApplyId;
	}

	public void setApproveApplyId(Long approveApplyId) {
		this.approveApplyId = approveApplyId;
	}

	public String getAttendAddress() {
		return attendAddress;
	}

	public void setAttendAddress(String attendAddress) {
		this.attendAddress = attendAddress;
	}

}