package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业班次规则
 * 
 * @author zhangye
 * @since 2018-02-26 14:14:14
 */
@Data
@TableName("com_shift_rule")
public class ComShiftRule extends BaseEntity<ComShiftRule> {
	private static final long serialVersionUID = 926253435L;

	/** 班次规则ID */
	@ApiModelProperty(value = "班次规则ID")
	private Long shiftRuleId;

	/** 企业ID */
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	/** 上下班第几轮 */
	@ApiModelProperty(value = "上下班第几轮")
	private int commutRound;

	/** 上班时间 */
	@ApiModelProperty(value = "上班时间")
	private Date startWorkTime;

	/** 下班时间 */
	@ApiModelProperty(value = "下班时间")
	private Date endWorkTime;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	/** 是否次日上班 */
	@ApiModelProperty(value = "是否次日上班")
	private String isStartNextDay;

	/** 是否次日下班 */
	@ApiModelProperty(value = "是否次日下班")
	private String isEndNextDay;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftRuleId() {
		return shiftRuleId;
	}

	@Override
	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComId() {
		return comId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

	@JsonFormat(pattern = "HH:mm:ss")
	public Date getStartWorkTime() {
		return startWorkTime;
	}

	@JsonFormat(pattern = "HH:mm:ss")
	public Date getEndWorkTime() {
		return endWorkTime;
	}

}